/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.StorageClusterSettings;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.cloud.StorageNodeConfigurationComposite;
import org.rhq.core.domain.cloud.StorageNodeLoadComposite;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.cloud.StorageNodeManagerRemote;

@Local
public interface StorageNodeManagerLocal
extends StorageNodeManagerRemote {
    public static final String STORAGE_NODE_GROUP_NAME = "RHQ Storage Nodes";
    public static final String STORAGE_NODE_RESOURCE_TYPE_NAME = "RHQ Storage Node";
    public static final String STORAGE_NODE_PLUGIN_NAME = "RHQStorage";

    public List<StorageNode> getStorageNodes();

    public List<StorageNode> getClusterNodes();

    public PageList<StorageNodeLoadComposite> getStorageNodeComposites(Subject var1);

    public void linkResource(Resource var1);

    public StorageNode linkExistingStorageNodeToResource(StorageNode var1);

    public ListenableFuture<List<StorageNodeLoadComposite>> getLoadAsync(Subject var1, StorageNode var2, long var3, long var5);

    public void updateConfigurationAsync(Subject var1, StorageNodeConfigurationComposite var2);

    public StorageNode findStorageNodeByAddress(String var1);

    public Map<Integer, Integer> findResourcesWithAlertDefinitions();

    public Integer[] findResourcesWithAlertDefinitions(StorageNode var1);

    public void prepareNodeForUpgrade(Subject var1, StorageNode var2);

    public void scheduleOperationInNewTransaction(Subject var1, ResourceOperationSchedule var2);

    public Map<String, List<MeasurementDataNumericHighLowComposite>> findStorageNodeLoadDataForLast(Subject var1, StorageNode var2, long var3, long var5, int var7);

    public StorageNode createStorageNode(Resource var1, StorageClusterSettings var2);

    public void resetInNewTransaction();

    public void scheduleSnapshotManagementOperationsForStorageNode(Subject var1, StorageNode var2, StorageClusterSettings var3);

    public void scheduleSnapshotManagement(Subject var1, StorageClusterSettings var2);

    public void ackFailedOperation(Subject var1, int var2);
}

