/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.DynamicConfigurationPropertyValue;
import org.rhq.enterprise.server.configuration.DynamicConfigurationPropertyLocal;
import org.rhq.enterprise.server.configuration.PropertyExpressionEvaluator;

@Stateless
public class DynamicConfigurationPropertyBean
implements DynamicConfigurationPropertyLocal {
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    public List<DynamicConfigurationPropertyValue> lookupValues(String key) {
        String queryName = PropertyExpressionEvaluator.getQueryNameForKey(key);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Lookup value for key [" + key + "] found query name [" + queryName + "]"));
        }
        if (queryName == null) {
            return Collections.emptyList();
        }
        Query query = this.entityManager.createNamedQuery(queryName);
        List results = query.getResultList();
        ArrayList<DynamicConfigurationPropertyValue> values = new ArrayList<DynamicConfigurationPropertyValue>(results.size());
        for (Object[] result : results) {
            DynamicConfigurationPropertyValue value = this.translate(result);
            values.add(value);
        }
        return values;
    }

    public DynamicConfigurationPropertyValue translate(Object[] results) {
        DynamicConfigurationPropertyValue value = new DynamicConfigurationPropertyValue((String)results[0], (String)results[1]);
        return value;
    }
}

