/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.ejb.Stateless;
import javax.interceptor.ExcludeDefaultInterceptors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.file.FileUtil;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.RemoteClientManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class RemoteClientManagerBean
implements RemoteClientManagerLocal {
    private final Log log = LogFactory.getLog(RemoteClientManagerBean.class);
    private static final String RHQ_SERVER_VERSION = "rhq-server.version";
    private static final String RHQ_SERVER_BUILD_NUMBER = "rhq-server.build-number";
    private static final String RHQ_CLIENT_MD5 = "rhq-client.md5";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeDefaultInterceptors
    public File getRemoteClientVersionFile() throws Exception {
        File versionFile = new File(this.getDataDownloadDir(), "rhq-client-version.properties");
        File zip = this.getRemoteClientBinaryFile();
        Boolean needVersionFile = FileUtil.isNewer((File)zip, (File)versionFile);
        if (needVersionFile == null || needVersionFile.booleanValue()) {
            StringBuilder serverVersionInfo = new StringBuilder();
            CoreServerMBean coreServer = LookupUtil.getCoreServer();
            serverVersionInfo.append("rhq-server.version=").append(coreServer.getVersion()).append('\n');
            serverVersionInfo.append("rhq-server.build-number=").append(coreServer.getBuildNumber()).append('\n');
            this.log.info((Object)("Remote Client Binary File: " + zip.getAbsolutePath()));
            String md5Property = "rhq-client.md5=" + MessageDigestGenerator.getDigestString((File)zip) + '\n';
            FileOutputStream versionFileOutputStream = new FileOutputStream(versionFile);
            try {
                versionFileOutputStream.write(serverVersionInfo.toString().getBytes());
                versionFileOutputStream.write(md5Property.getBytes());
            }
            finally {
                try {
                    versionFileOutputStream.close();
                }
                catch (Exception ignore) {}
            }
            this.log.info((Object)("Remote Client Version File: " + versionFile));
        }
        return versionFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExcludeDefaultInterceptors
    public Properties getRemoteClientVersionFileContent() throws Exception {
        FileInputStream stream = new FileInputStream(this.getRemoteClientVersionFile());
        try {
            Properties props = new Properties();
            props.load(stream);
            Properties properties = props;
            return properties;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    @ExcludeDefaultInterceptors
    public File getRemoteClientBinaryFile() throws Exception {
        File downloadDir = this.getDownloadDir();
        for (File file : downloadDir.listFiles()) {
            if (!file.getName().endsWith(".zip")) continue;
            return file;
        }
        throw new FileNotFoundException("Missing CLI binary in [" + downloadDir + "]");
    }

    private File getDownloadDir() throws Exception {
        File earDir = LookupUtil.getCoreServer().getEarDeploymentDir();
        File downloadDir = new File(earDir, "rhq-downloads/rhq-client");
        if (!downloadDir.isDirectory()) {
            throw new FileNotFoundException("Missing remote client download directory at [" + downloadDir + "]");
        }
        return downloadDir;
    }

    private File getDataDownloadDir() throws Exception {
        File earDir = LookupUtil.getCoreServer().getJBossServerDataDir();
        File downloadDir = new File(earDir, "rhq-downloads/rhq-client");
        if (!downloadDir.isDirectory()) {
            downloadDir.mkdirs();
            if (!downloadDir.isDirectory()) {
                throw new FileNotFoundException("Missing remote client data download directory [" + downloadDir + "]");
            }
        }
        return downloadDir;
    }
}

