/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.cloud.TopologyManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class ShutdownListener {
    private final Log log = LogFactory.getLog(ShutdownListener.class);
    private final String RHQ_SHUTDOWN_TIME_LOG_FILE = "rhq-shutdown-time.dat";
    private final String RHQ_DB_TYPE_MAPPING_PROPERTY = "rhq.server.database.type-mapping";
    @EJB
    private SchedulerLocal schedulerBean;
    @EJB
    private ServerManagerLocal serverManager;
    @EJB
    private TopologyManagerLocal topologyManager;
    @Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
    private DataSource dataSource;
    @Resource(name="NoTx_RHQ_DS", mappedName="java:jboss/datasources/NoTxRHQDS")
    private DataSource noTxDataSource;
    private File shutdownTimeLogFile;

    public void handleNotification() {
        this.log.info((Object)"Shutdown listener has been told we are shutting down - starting to clean up now...");
        this.logShutdownTime();
        this.stopScheduler();
        this.updateServerOperationMode();
        this.stopEmbeddedDatabase();
        this.log.info((Object)"Shutdown listener completed its shutdown tasks. It is safe to shutdown now.");
    }

    public File getShutdownTimeLogFile() throws Exception {
        if (this.shutdownTimeLogFile == null) {
            try {
                CoreServerMBean coreServer = LookupUtil.getCoreServer();
                File dataDir = coreServer.getJBossServerDataDir();
                File timeFile = new File(dataDir, "rhq-shutdown-time.dat");
                if (!timeFile.exists()) {
                    ByteArrayInputStream data = new ByteArrayInputStream("0".getBytes());
                    FileUtil.writeFile((InputStream)data, (File)timeFile);
                }
                this.shutdownTimeLogFile = timeFile;
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn((Object)"Failed to get shutdown time log file", (Throwable)e);
                } else {
                    this.log.warn((Object)("Failed to get shutdown time log file: " + e.getMessage()));
                }
                throw e;
            }
        }
        return this.shutdownTimeLogFile;
    }

    private void logShutdownTime() {
        try {
            File shutdownTimeLogFile = this.getShutdownTimeLogFile();
            ByteArrayInputStream input = new ByteArrayInputStream(String.valueOf(System.currentTimeMillis()).getBytes());
            FileUtil.writeFile((InputStream)input, (File)shutdownTimeLogFile);
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)"Failed to store shutdown time", t);
            }
            this.log.warn((Object)("Failed to store shutdown time: " + t.getMessage()));
        }
    }

    private void stopScheduler() {
        try {
            if (this.schedulerBean.isStarted()) {
                this.log.info((Object)"Shutting down the scheduler gracefully - currently running jobs will be allowed to finish...");
                this.schedulerBean.shutdown(true);
                this.log.info((Object)"The scheduler has been shutdown and all jobs are done.");
            } else {
                this.log.info((Object)"No need for shutting down the scheduler, because it is not running.");
            }
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)"Failed to shutdown the scheduler", t);
            }
            this.log.warn((Object)("Failed to shutdown the scheduler: " + t.getMessage()));
        }
    }

    private void updateServerOperationMode() {
        try {
            Server server = this.serverManager.getServer();
            if (Server.OperationMode.MAINTENANCE != server.getOperationMode()) {
                this.topologyManager.updateServerMode(LookupUtil.getSubjectManager().getOverlord(), new Integer[]{server.getId()}, Server.OperationMode.DOWN);
            }
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)"Could not update this server's OperationMode to DOWN in the database", t);
            }
            this.log.warn((Object)("Could not update this server's OperationMode to DOWN in the database: " + t.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEmbeddedDatabase() {
        if (!this.isEmbedded()) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            statement.execute("shutdown");
            this.log.info((Object)"Embedded database closed cleanly");
        }
        catch (SQLException sqle) {
            block8: {
                block7: {
                    try {
                        if (sqle.getMessage().toLowerCase().indexOf("database is already closed") == -1) break block7;
                        this.log.warn((Object)"Database is already shut down, can not perform graceful service shutdown");
                    }
                    catch (Throwable throwable) {
                        JDBCUtil.safeClose((Connection)connection, statement, null);
                        throw throwable;
                    }
                    JDBCUtil.safeClose((Connection)connection, (Statement)statement, null);
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.warn((Object)"Could not shut down the embedded database cleanly", (Throwable)sqle);
                    break block8;
                }
                this.log.warn((Object)("Could not shut down the embedded database cleanly: " + sqle.getMessage()));
            }
            JDBCUtil.safeClose((Connection)connection, (Statement)statement, null);
        }
        JDBCUtil.safeClose((Connection)connection, (Statement)statement, null);
    }

    private boolean isEmbedded() {
        String identity = System.getProperty("rhq.server.database.type-mapping", "");
        if (identity.equals("")) {
            this.log.error((Object)"Could not determine datatype base; is the rhq.server.database.type-mapping property set in rhq-server.properties?");
        }
        return identity.toLowerCase().indexOf("h2") != -1;
    }
}

