/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.core.domain.criteria.ServerCriteria;
import org.rhq.core.domain.criteria.StorageNodeCriteria;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.server.ExternalizableStrategy;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.communications.command.server.CommandListener;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.cloud.TopologyManagerLocal;
import org.rhq.enterprise.server.cloud.instance.CacheConsistencyManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.cloud.instance.SyncEndpointAddressException;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.core.ExternalizableStrategyCommandListener;
import org.rhq.enterprise.server.core.ShutdownListener;
import org.rhq.enterprise.server.core.StartupLocal;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceUtil;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.naming.NamingHack;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceMBean;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AsyncResourceDeleteJob;
import org.rhq.enterprise.server.scheduler.jobs.CheckForSuspectedAgentsJob;
import org.rhq.enterprise.server.scheduler.jobs.CheckForTimedOutConfigUpdatesJob;
import org.rhq.enterprise.server.scheduler.jobs.CheckForTimedOutContentRequestsJob;
import org.rhq.enterprise.server.scheduler.jobs.CheckForTimedOutOperationsJob;
import org.rhq.enterprise.server.scheduler.jobs.CloudManagerJob;
import org.rhq.enterprise.server.scheduler.jobs.DataCalcJob;
import org.rhq.enterprise.server.scheduler.jobs.DataPurgeJob;
import org.rhq.enterprise.server.scheduler.jobs.DynaGroupAutoRecalculationJob;
import org.rhq.enterprise.server.scheduler.jobs.PurgePluginsJob;
import org.rhq.enterprise.server.scheduler.jobs.PurgeResourceTypesJob;
import org.rhq.enterprise.server.scheduler.jobs.SavedSearchResultCountRecalculationJob;
import org.rhq.enterprise.server.scheduler.jobs.StorageClusterReadRepairJob;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.concurrent.AlertSerializer;
import org.rhq.enterprise.server.util.concurrent.AvailabilityReportSerializer;
import org.rhq.server.metrics.DateTimeService;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class StartupBean
implements StartupLocal {
    private Log log = LogFactory.getLog(this.getClass());
    private volatile boolean initialized = false;
    private String error = "";
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private CacheConsistencyManagerLocal cacheConsistencyManager;
    @EJB
    private TopologyManagerLocal topologyManager;
    @EJB
    private StorageNodeManagerLocal storageNodeManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private SchedulerLocal schedulerBean;
    @EJB
    private ServerManagerLocal serverManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private ShutdownListener shutdownListener;
    @EJB
    private StorageClientManager storageClientManager;
    @Resource
    private TimerService timerService;
    @Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
    private DataSource dataSource;

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getError() {
        return this.error;
    }

    private void secureNaming() {
        NamingHack.bruteForceInitialContextFactoryBuilder();
    }

    @Override
    public void init() throws RuntimeException {
        DateTimeService temp = new DateTimeService();
        this.checkTempDir();
        this.checkCluster();
        this.secureNaming();
        this.initialized = false;
        this.log.info((Object)"All business tier deployments are complete - finishing the startup...");
        AlertConditionCacheCoordinator.getInstance();
        SessionManager.getInstance();
        AlertSerializer.getSingleton();
        AvailabilityReportSerializer.getSingleton();
        try {
            this.resourceTypeManager.reloadResourceFacetsCache();
        }
        catch (Throwable t) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "reloading facets cache";
            this.log.error((Object)"Could not load ResourceFacets cache.", t);
        }
        this.initStorageClient();
        this.initializeServer();
        this.startHibernateStatistics();
        this.initScheduler();
        this.startPluginDeployer();
        this.startServerPluginContainer();
        this.upgradeRhqUserSecurityDomainIfNeeded();
        this.startServerCommunicationServices();
        this.startScheduler();
        this.scheduleJobs();
        this.registerShutdownListener();
        this.registerPluginDeploymentScannerJob();
        this.logServerStartedMessage();
        this.initialized = true;
    }

    private void checkTempDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpDir.exists()) {
            this.log.warn((Object)("Invalid java.io.tmpdir: [" + tmpDir.getAbsolutePath() + "] does not exist."));
            try {
                this.log.info((Object)("Creating java.io.tmpdir: [" + tmpDir.getAbsolutePath() + "]"));
                tmpDir.mkdir();
            }
            catch (Throwable t) {
                throw new RuntimeException("Startup failed: Could not create missing java.io.tmpdir [" + tmpDir.getAbsolutePath() + "]", t);
            }
        }
        if (!tmpDir.isDirectory()) {
            throw new RuntimeException("Startup failed: java.io.tmpdir [" + tmpDir.getAbsolutePath() + "] is not a directory");
        }
        if (!tmpDir.canRead() || !tmpDir.canExecute()) {
            throw new RuntimeException("Startup failed: java.io.tmpdir [" + tmpDir.getAbsolutePath() + "] is not readable");
        }
        if (!tmpDir.canWrite()) {
            throw new RuntimeException("Startup failed: java.io.tmpdir [" + tmpDir.getAbsolutePath() + "] is not writable");
        }
    }

    private void checkCluster() {
        try {
            Subject overlord = this.subjectManager.getOverlord();
            String version = this.getClass().getPackage().getImplementationVersion();
            ServerCriteria sc = new ServerCriteria();
            sc.clearPaging();
            PageList<Server> servers = this.topologyManager.findServersByCriteria(overlord, sc);
            for (Server server : servers) {
                if (version.equals(server.getVersion())) continue;
                throw new RuntimeException("Startup failed: Could not start Server because not all Servers are running the same version. This Server is running version [" + version + "] but Server [" + server.getName() + "] is running version [" + server.getVersion() + "] Please complete the upgrade for all Servers and StorageNodes before trying to start a server.");
            }
            StorageNodeCriteria snc = new StorageNodeCriteria();
            snc.clearPaging();
            PageList<StorageNode> storageNodes = this.storageNodeManager.findStorageNodesByCriteria(overlord, snc);
            for (StorageNode storageNode : storageNodes) {
                if (version.equals(storageNode.getVersion())) continue;
                throw new RuntimeException("Startup failed: Could not start Server because not all Storage Nodes are running the same version. This Server is running version [" + version + "] but Storage Node [" + storageNode.getAddress() + "] is running version [" + storageNode.getVersion() + "] Please complete the upgrade for all Servers and StorageNodes before trying to start a server.");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Startup failed: Could not validat Server or Storage Node versions", t);
        }
    }

    private long readShutdownTimeLogFile() throws Exception {
        File timeFile = this.shutdownListener.getShutdownTimeLogFile();
        if (!timeFile.exists()) {
            throw new FileNotFoundException();
        }
        try {
            FileInputStream input = new FileInputStream(timeFile);
            String timeString = new String(StreamUtil.slurp((InputStream)input));
            long l = Long.parseLong(timeString);
            return l;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)"Failed to read the shutdown time log file", (Throwable)e);
            } else {
                this.log.warn((Object)("Failed to read the shutdown time log file: " + e.getMessage()));
            }
            throw e;
        }
        finally {
            timeFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeServer() {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseTypeFactory.setDefaultDatabaseType((DatabaseType)DatabaseTypeFactory.getDatabaseType((Connection)conn));
        }
        catch (Exception e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "server";
            this.log.error((Object)"Could not initialize server.", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to close temporary connection used for server initialization.", (Throwable)e);
                }
            }
        }
        this.createDefaultServerIfNecessary();
        if (ServerCommunicationsServiceUtil.getService().getMaintenanceModeAtStartup().booleanValue()) {
            this.log.info((Object)"Server is configured to start up in MAINTENANCE mode.");
            Server server = this.serverManager.getServer();
            Integer[] serverId = new Integer[]{server.getId()};
            this.topologyManager.updateServerManualMaintenance(LookupUtil.getSubjectManager().getOverlord(), serverId, true);
        }
        this.serverManager.establishCurrentServerMode();
        if ("true".equals(System.getProperty("rhq.sync.endpoint-address", "false"))) {
            try {
                this.serverManager.syncEndpointAddress();
            }
            catch (SyncEndpointAddressException e) {
                this.log.error((Object)"Failed to sync server endpoint address.", (Throwable)e);
            }
        }
    }

    private void createDefaultServerIfNecessary() {
        String identity = this.serverManager.getIdentity();
        Server server = this.topologyManager.getServerByName(identity);
        if (server == null) {
            String address;
            server = new Server();
            server.setName(identity);
            try {
                address = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                address = "localhost";
            }
            server.setAddress(address);
            server.setPort(7080);
            server.setSecurePort(7443);
            server.setComputePower(1);
            server.setOperationMode(Server.OperationMode.INSTALLED);
            server.setVersion(this.getClass().getPackage().getImplementationVersion());
            this.serverManager.create(server);
            this.log.info((Object)("Default HA server created: " + server));
        }
    }

    private void startHibernateStatistics() throws RuntimeException {
        this.log.info((Object)"Starting hibernate statistics monitoring...");
        try {
            this.systemManager.enableHibernateStatistics();
        }
        catch (Exception e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "hibernate statistics";
            throw new RuntimeException("Cannot start hibernate statistics monitoring!", e);
        }
    }

    private void startPluginDeployer() throws RuntimeException {
        this.log.info((Object)"Starting the agent/server plugin deployer...");
        try {
            PluginDeploymentScannerMBean deployer = this.getPluginDeploymentScanner();
            deployer.startDeployment();
        }
        catch (Exception e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "plugin deployer";
            throw new RuntimeException("Cannot start the agent/server plugin deployer!", e);
        }
    }

    private void registerPluginDeploymentScannerJob() throws RuntimeException {
        this.log.info((Object)"Creating timer to begin scanning for plugins...");
        try {
            PluginDeploymentScannerMBean deployer = this.getPluginDeploymentScanner();
            long scanPeriod = 300000L;
            try {
                String scanPeriodString = deployer.getScanPeriod();
                scanPeriod = Long.parseLong(scanPeriodString);
            }
            catch (Exception e) {
                this.log.warn((Object)("could not determine plugin scanner scan period - using: " + scanPeriod), (Throwable)e);
            }
            this.timerService.createIntervalTimer(scanPeriod, scanPeriod, new TimerConfig(null, false));
        }
        catch (Exception e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "plugin scanner";
            throw new RuntimeException("Cannot schedule plugin scanning timer - new plugins will not be detected!", e);
        }
    }

    @Timeout
    public void scanForPlugins(Timer timer) {
        block2: {
            try {
                PluginDeploymentScannerMBean deployer = this.getPluginDeploymentScanner();
                deployer.scanAndRegister();
            }
            catch (Throwable t) {
                this.log.error((Object)("Plugin scan failed. Cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)"Plugin scan failure stack trace follows:", t);
            }
        }
    }

    private PluginDeploymentScannerMBean getPluginDeploymentScanner() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = PluginDeploymentScannerMBean.OBJECT_NAME;
        Class<PluginDeploymentScannerMBean> iface = PluginDeploymentScannerMBean.class;
        PluginDeploymentScannerMBean deployer = MBeanServerInvocationHandler.newProxyInstance(mbs, name, iface, false);
        return deployer;
    }

    private void upgradeRhqUserSecurityDomainIfNeeded() throws RuntimeException {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = CustomJaasDeploymentServiceMBean.OBJECT_NAME;
            Class<CustomJaasDeploymentServiceMBean> iface = CustomJaasDeploymentServiceMBean.class;
            CustomJaasDeploymentServiceMBean jaas_mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, iface, false);
            jaas_mbean.upgradeRhqUserSecurityDomainIfNeeded();
        }
        catch (Exception e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "security domain upgrade";
            throw new RuntimeException("Cannot upgrade JAAS login modules!", e);
        }
    }

    private void initScheduler() throws RuntimeException {
        this.log.info((Object)"Initializing the scheduler....");
        try {
            this.schedulerBean.initQuartzScheduler();
        }
        catch (SchedulerException e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "scheduler initialization";
            throw new RuntimeException("Cannot initialize the scheduler!", e);
        }
    }

    private boolean initStorageClient() {
        boolean isStorageRunning = this.storageClientManager.init();
        if (!isStorageRunning) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "storage";
        }
        return isStorageRunning;
    }

    private void startScheduler() throws RuntimeException {
        this.log.info((Object)"Starting the scheduler...");
        try {
            this.schedulerBean.startQuartzScheduler();
        }
        catch (SchedulerException e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "scheduler";
            throw new RuntimeException("Cannot start the scheduler!", e);
        }
    }

    private void startServerCommunicationServices() throws RuntimeException {
        long ensureDownTimeSecs;
        try {
            ensureDownTimeSecs = Long.parseLong(System.getProperty("rhq.server.ensure-down-time-secs", "70"));
        }
        catch (Exception e) {
            ensureDownTimeSecs = 70L;
        }
        long elapsed = this.getElapsedTimeSinceLastShutdown();
        long sleepTime = ensureDownTimeSecs * 1000L - elapsed;
        if (sleepTime > 0L) {
            try {
                this.log.info((Object)("Forcing the server to wait [" + sleepTime + "]ms to ensure agents know we went down..."));
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        this.log.info((Object)"Starting the server-agent communications services...");
        try {
            ServerCommunicationsServiceUtil.getService().startCommunicationServices();
            ServerCommunicationsServiceUtil.getService().getServiceContainer().addCommandListener((CommandListener)new ExternalizableStrategyCommandListener(ExternalizableStrategy.Subsystem.AGENT));
        }
        catch (Exception e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "communications services";
            throw new RuntimeException("Cannot start the server-side communications services.", e);
        }
    }

    private void startAgentClients() {
        this.log.info((Object)"Starting agent clients - any persisted messages with guaranteed delivery will be sent...");
        List<Agent> agents = this.agentManager.getAllAgents();
        if (agents != null) {
            for (Agent agent : agents) {
                this.agentManager.getAgentClient(agent);
            }
        }
    }

    private void scheduleJobs() throws RuntimeException {
        String cronString;
        long interval;
        long initialDelay;
        this.log.info((Object)"Scheduling asynchronous jobs...");
        this.serverManager.scheduleServerHeartbeat();
        this.cacheConsistencyManager.scheduleServerCacheReloader();
        this.systemManager.scheduleConfigCacheReloader();
        this.subjectManager.scheduleSessionPurgeJob();
        this.storageClientManager.scheduleStorageSessionMaintenance();
        try {
            initialDelay = 60000L;
            interval = 60000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(SavedSearchResultCountRecalculationJob.class, true, false, 60000L, 60000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule asynchronous resource deletion job.", (Throwable)e);
        }
        try {
            initialDelay = 60000L;
            interval = 300000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(AsyncResourceDeleteJob.class, true, false, 60000L, 300000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule asynchronous resource deletion job.", (Throwable)e);
        }
        try {
            long initialDelay2 = 60000L;
            interval = 300000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(PurgeResourceTypesJob.class, true, false, 60000L, 300000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule purge resource types job.", (Throwable)e);
        }
        try {
            long initialDelay3 = 60000L;
            interval = 180000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(PurgePluginsJob.class, true, false, 60000L, 180000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule purge plugins job.", (Throwable)e);
        }
        try {
            long initialDelay4 = 60000L;
            interval = 60000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(DynaGroupAutoRecalculationJob.class, true, false, 60000L, 60000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule DynaGroup auto-recalculation job.", (Throwable)e);
        }
        try {
            String oldJobName = "org.rhq.enterprise.server.scheduler.jobs.ClusterManagerJob";
            boolean foundAndDeleted = this.schedulerBean.deleteJob(oldJobName, oldJobName);
            if (foundAndDeleted) {
                this.log.info((Object)("Unscheduling deprecated job references for " + oldJobName + "..."));
            } else {
                this.log.debug((Object)("No deprecated job references found for " + oldJobName + "."));
            }
            long initialDelay5 = 120000L;
            long interval2 = 30000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(CloudManagerJob.class, true, false, 120000L, 30000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule cloud management job.", (Throwable)e);
        }
        try {
            long initialDelay6 = 600000L;
            interval = 60000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(CheckForSuspectedAgentsJob.class, true, false, 600000L, 60000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule suspected Agents job.", (Throwable)e);
        }
        try {
            long initialDelay7 = 180000L;
            interval = 600000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(CheckForTimedOutOperationsJob.class, true, false, 180000L, 600000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule check-for-timed-out-operations job.", (Throwable)e);
        }
        try {
            long initialDelay8 = 240000L;
            interval = 600000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(CheckForTimedOutConfigUpdatesJob.class, true, false, 240000L, 600000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule check-for-timed-out-configuration-update-requests job.", (Throwable)e);
        }
        try {
            long initialDelay9 = 300000L;
            interval = 900000L;
            this.schedulerBean.scheduleSimpleRepeatingJob(CheckForTimedOutContentRequestsJob.class, true, false, 300000L, 900000L);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule check-for-timed-out-artifact-requests job.", (Throwable)e);
        }
        try {
            cronString = "0 30 * * * ?";
            this.schedulerBean.scheduleSimpleCronJob(DataPurgeJob.class, true, false, cronString, 2);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule data purge job.", (Throwable)e);
        }
        try {
            cronString = "0 0 * * * ?";
            this.schedulerBean.scheduleSimpleCronJob(DataCalcJob.class, true, false, cronString, 2);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule data calc job.", (Throwable)e);
        }
        try {
            ServerPluginServiceMBean mbean = LookupUtil.getServerPluginService();
            MasterServerPluginContainer masterPC = mbean.getMasterPluginContainer();
            masterPC.scheduleAllPluginJobs();
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot schedule server plugin jobs.", (Throwable)e);
        }
        try {
            cronString = "0 30 0 ? * SUN *";
            this.schedulerBean.scheduleSimpleCronJob(StorageClusterReadRepairJob.class, true, true, cronString, null);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot create storage cluster read repair job", (Throwable)e);
        }
    }

    @Deprecated
    private void startEmbeddedAgent() throws RuntimeException {
        final ObjectName agentBootstrapMBean = ObjectNameFactory.create((String)"rhq:service=EmbeddedAgentBootstrap");
        String agentEnabledAttribute = "AgentEnabled";
        String startAgentMethod = "startAgent";
        String configurationOverridesAttribute = "ConfigurationOverrides";
        final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            String enabled = (String)mbs.getAttribute(agentBootstrapMBean, "AgentEnabled");
            try {
                if (Boolean.valueOf(enabled).booleanValue()) {
                    this.log.info((Object)"The embedded Agent is installed and enabled - it will now be started...");
                    String AgentConfigurationConstants_SERVER_TRANSPORT = "rhq.agent.server.transport";
                    String AgentConfigurationConstants_SERVER_BIND_ADDRESS = "rhq.agent.server.bind-address";
                    String AgentConfigurationConstants_SERVER_BIND_PORT = "rhq.agent.server.bind-port";
                    Properties overrides = (Properties)mbs.getAttribute(agentBootstrapMBean, "ConfigurationOverrides");
                    String serverTransport = overrides.getProperty(AgentConfigurationConstants_SERVER_TRANSPORT);
                    String serverAddress = overrides.getProperty(AgentConfigurationConstants_SERVER_BIND_ADDRESS);
                    String serverPort = overrides.getProperty(AgentConfigurationConstants_SERVER_BIND_PORT);
                    String agentAddress = overrides.getProperty("rhq.communications.connector.bind-address");
                    Server server = this.serverManager.getServer();
                    if (agentAddress == null || agentAddress.trim().equals("")) {
                        overrides.setProperty("rhq.communications.connector.bind-address", server.getAddress());
                    }
                    if (serverAddress == null || serverAddress.trim().equals("")) {
                        overrides.setProperty(AgentConfigurationConstants_SERVER_BIND_ADDRESS, server.getAddress());
                    }
                    if (serverPort == null || serverPort.trim().equals("")) {
                        if (SecurityUtil.isTransportSecure((String)serverTransport)) {
                            overrides.setProperty(AgentConfigurationConstants_SERVER_BIND_PORT, Integer.toString(server.getSecurePort()));
                        } else {
                            overrides.setProperty(AgentConfigurationConstants_SERVER_BIND_PORT, Integer.toString(server.getPort()));
                        }
                    }
                    mbs.setAttribute(agentBootstrapMBean, new Attribute("ConfigurationOverrides", overrides));
                    Runnable agentStartRunnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                mbs.invoke(agentBootstrapMBean, "startAgent", new Object[0], new String[0]);
                            }
                            catch (Throwable t) {
                                StartupBean.this.log.error((Object)"Failed to start the embedded Agent - it will not be available!", t);
                            }
                        }
                    };
                    Thread agentStartThread = new Thread(agentStartRunnable, "Embedded Agent Startup");
                    agentStartThread.setDaemon(true);
                    agentStartThread.start();
                } else {
                    this.log.debug((Object)"The embedded Agent is not enabled, so it will not be started.");
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to start the embedded Agent.", t);
            }
        }
        catch (RuntimeException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.info((Object)("The embedded Agent is not installed, so it will not be started (" + t + ")."));
        }
    }

    private void startServerPluginContainer() throws RuntimeException {
        this.log.info((Object)"Starting the master server plugin container...");
        try {
            ServerPluginServiceMBean mbean = LookupUtil.getServerPluginService();
            mbean.startMasterPluginContainerWithoutSchedulingJobs();
        }
        catch (Exception e) {
            this.error = this.error + (this.error.isEmpty() ? "" : ", ") + "server plugin container";
            throw new RuntimeException("Cannot start the master server plugin container!", e);
        }
    }

    private void registerShutdownListener() throws RuntimeException {
    }

    private long getElapsedTimeSinceLastShutdown() throws RuntimeException {
        long elapsed;
        try {
            long shutdownTime = this.readShutdownTimeLogFile();
            long currentTime = System.currentTimeMillis();
            elapsed = currentTime - shutdownTime;
        }
        catch (Exception ignore) {
            try {
                CoreServerMBean coreServer = LookupUtil.getCoreServer();
                Date startTime = coreServer.getBootTime();
                long currentTime = System.currentTimeMillis();
                elapsed = currentTime - startTime.getTime();
            }
            catch (Exception e1) {
                elapsed = 0L;
            }
        }
        return elapsed;
    }

    private void logServerStartedMessage() {
        Subject overlord = this.subjectManager.getOverlord();
        ProductInfo productInfo = this.systemManager.getProductInfo(overlord);
        this.log.info((Object)"--------------------------------------------------");
        this.log.info((Object)(productInfo.getFullName() + " " + productInfo.getVersion() + " (build " + productInfo.getBuildNumber() + ") Server started."));
        this.log.info((Object)"--------------------------------------------------");
    }
}

