/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.jaas;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.rhq.core.util.StringUtil;

public class DelegatingLoginModule
extends UsernamePasswordLoginModule {
    private static Log LOG = LogFactory.getLog((String)"DelegatingLoginModule");
    LoginContext loginContext;
    private String[] usernamePassword;
    private Principal identity;
    private List<String> rolesList;
    private boolean debugEnabled;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.debugEnabled = LOG.isDebugEnabled();
        super.initialize(subject, callbackHandler, sharedState, options);
        String delegateTo = (String)options.get("delegateTo");
        String additionalRoles = (String)options.get("roles");
        this.rolesList = StringUtil.explode((String)additionalRoles, (String)",");
        if (delegateTo == null || delegateTo.isEmpty()) {
            delegateTo = "other";
            LOG.warn((Object)"module-option 'delegateTo' was not set. Defaults to 'other'.");
        }
        if (this.debugEnabled) {
            LOG.debug((Object)("Delegating to " + delegateTo + " with roles " + additionalRoles));
        }
        try {
            this.loginContext = new LoginContext(delegateTo, new DelegateCallbackHandler());
        }
        catch (LoginException e) {
            LOG.warn((Object)("Initialize failed : " + e.getMessage()));
        }
    }

    public boolean login() throws LoginException {
        try {
            this.usernamePassword = super.getUsernameAndPassword();
            this.loginContext.login();
            this.usernamePassword[1] = null;
            this.identity = this.createIdentity(this.usernamePassword[0]);
            this.useFirstPass = true;
            this.loginOk = true;
            if (this.debugEnabled) {
                LOG.debug((Object)("Login ok for " + this.usernamePassword[0]));
            }
            return true;
        }
        catch (Exception e) {
            if (this.debugEnabled) {
                LOG.debug((Object)("Login failed for : " + this.usernamePassword[0] + ": " + e.getMessage()));
            }
            this.loginOk = false;
            return false;
        }
    }

    protected String getUsersPassword() throws LoginException {
        return null;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        for (String role : this.rolesList) {
            roles.addMember((Principal)new SimplePrincipal(role));
        }
        Group[] roleSets = new Group[]{roles};
        return roleSets;
    }

    private class DelegateCallbackHandler
    implements CallbackHandler {
        private DelegateCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (DelegatingLoginModule.this.debugEnabled) {
                LOG.debug((Object)"private handle callbacks");
            }
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    NameCallback nc = (NameCallback)cb;
                    nc.setName(DelegatingLoginModule.this.usernamePassword[0]);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)cb;
                    pc.setPassword(DelegatingLoginModule.this.usernamePassword[1].toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(cb, "Callback " + cb + " not supported");
            }
        }
    }
}

