/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.group.expressions.CannedGroupExpressions;
import org.rhq.core.domain.plugin.CannedGroupAddition;
import org.rhq.core.domain.plugin.CannedGroupExpression;
import org.rhq.enterprise.server.resource.group.definition.framework.ExpressionEvaluator;

public class PluginAdditionsReader {
    private static final Log log = LogFactory.getLog((String)PluginAdditionsReader.class.getName());

    public static CannedGroupAddition getCannedGroupsAddition(URL url, String pluginName) {
        try {
            CannedGroupExpressions descriptor = AgentPluginDescriptorUtil.loadCannedExpressionsFromUrl((URL)url);
            return PluginAdditionsReader.parseCGAdditions(descriptor, pluginName);
        }
        catch (Exception e) {
            log.error((Object)("Failed to parse plugin addition found in plugin [" + url + "]"), (Throwable)e);
            return null;
        }
    }

    private static CannedGroupAddition parseCGAdditions(CannedGroupExpressions descriptor, String plugin) {
        if (descriptor == null) {
            return null;
        }
        CannedGroupAddition addition = new CannedGroupAddition();
        for (CannedGroupExpressions.Definition def : descriptor.getGroupDefinitions()) {
            CannedGroupExpression cge = new CannedGroupExpression();
            cge.setId(def.getId());
            cge.setName(def.getName());
            cge.setPlugin(plugin);
            cge.setCreateByDefault(def.isCreateByDefault().booleanValue());
            cge.setDescription(def.getDescription());
            cge.setExpression(def.getExpression());
            cge.setRecalcInMinutes(def.getRecalcInMinutes().intValue());
            if (!PluginAdditionsReader.validateCGE(cge)) continue;
            addition.getExpressions().add(cge);
        }
        return addition;
    }

    private static boolean validateCGE(CannedGroupExpression cge) {
        boolean valid = true;
        try {
            ExpressionEvaluator evaluator = new ExpressionEvaluator();
            evaluator.setTestMode(true);
            for (String expr : cge.getExpression()) {
                evaluator.addExpression(expr);
            }
            evaluator.execute();
        }
        catch (Exception ex) {
            log.error((Object)("Failed to evaluate [expression], evaluator result : " + ex.getMessage()));
            valid = false;
        }
        return valid;
    }
}

