/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.install.remote;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.core.domain.install.remote.AgentInstall;
import org.rhq.core.domain.install.remote.AgentInstallInfo;
import org.rhq.core.domain.install.remote.AgentInstallStep;
import org.rhq.core.domain.install.remote.CustomAgentInstallData;
import org.rhq.core.domain.install.remote.RemoteAccessInfo;
import org.rhq.core.domain.install.remote.SSHSecurityException;
import org.rhq.core.util.file.FileUtil;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerLocal;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerRemote;
import org.rhq.enterprise.server.install.remote.SSHInstallUtility;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class RemoteInstallManagerBean
implements RemoteInstallManagerLocal,
RemoteInstallManagerRemote {
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private SystemManagerLocal systemSettingsManager;

    private void processRememberMe(Subject subject, SSHInstallUtility sshSession) {
        RemoteAccessInfo remoteAccessInfo = sshSession.getRemoteAccessInfo();
        String agentName = remoteAccessInfo.getAgentName();
        if (agentName == null) {
            return;
        }
        boolean credentialsOK = sshSession.isConnected();
        if (!credentialsOK) {
            return;
        }
        AgentInstall ai = this.agentManager.getAgentInstallByAgentName(subject, agentName);
        if (ai == null) {
            ai = new AgentInstall();
            ai.setAgentName(agentName);
        }
        ai.setSshPort(Integer.valueOf(remoteAccessInfo.getPort()));
        if (remoteAccessInfo.getRememberMe()) {
            ai.setSshUsername(remoteAccessInfo.getUser());
            ai.setSshPassword(remoteAccessInfo.getPassword());
        } else {
            ai.setSshUsername("");
            ai.setSshPassword("");
        }
        try {
            this.agentManager.updateAgentInstall(subject, ai);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void checkSSHConnection(Subject subject, RemoteAccessInfo remoteAccessInfo) throws SSHSecurityException {
        SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
        try {
            if (!sshUtil.isConnected()) {
                throw new IllegalStateException("Is not connected to [" + remoteAccessInfo.getHost() + ":" + remoteAccessInfo.getPort() + "]");
            }
        }
        finally {
            sshUtil.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public boolean agentInstallCheck(Subject subject, RemoteAccessInfo remoteAccessInfo, String agentInstallPath) {
        SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
        try {
            boolean results = sshUtil.agentInstallCheck(agentInstallPath);
            if (results) {
                this.processRememberMe(subject, sshUtil);
            }
            boolean bl = results;
            return bl;
        }
        finally {
            sshUtil.disconnect();
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public AgentInstallInfo installAgent(Subject subject, RemoteAccessInfo remoteAccessInfo, String parentPath) {
        CustomAgentInstallData data = new CustomAgentInstallData(parentPath, false);
        return this.installAgent(subject, remoteAccessInfo, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public AgentInstallInfo installAgent(Subject subject, RemoteAccessInfo remoteAccessInfo, CustomAgentInstallData customData) {
        try {
            String parentPath = customData.getParentPath();
            boolean agentAlreadyInstalled = this.agentInstallCheck(subject, remoteAccessInfo, parentPath);
            if (agentAlreadyInstalled) {
                if (!customData.isOverwriteExistingAgent()) {
                    throw new IllegalStateException("Agent appears to already be installed under: " + parentPath);
                }
                if (parentPath.endsWith("/rhq-agent")) {
                    SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
                    try {
                        String results = sshUtil.findAgentInstallPath(parentPath);
                        if (parentPath.equals(results)) {
                            parentPath = parentPath.substring(0, parentPath.lastIndexOf("/rhq-agent"));
                            customData.setParentPath(parentPath);
                        }
                    }
                    finally {
                        sshUtil.disconnect();
                    }
                }
                this.stopAgent(subject, remoteAccessInfo, parentPath);
            }
            if (customData.getAgentConfigurationXmlFile() != null) {
                this.deobfuscateFile(new File(customData.getAgentConfigurationXmlFile()));
            }
            if (customData.getRhqAgentEnvFile() != null) {
                this.deobfuscateFile(new File(customData.getRhqAgentEnvFile()));
            }
            AgentInstall agentInstall = new AgentInstall();
            agentInstall.setSshHost(remoteAccessInfo.getHost());
            agentInstall.setSshPort(Integer.valueOf(remoteAccessInfo.getPort()));
            if (remoteAccessInfo.getRememberMe()) {
                agentInstall.setSshUsername(remoteAccessInfo.getUser());
                agentInstall.setSshPassword(remoteAccessInfo.getPassword());
            }
            AgentInstall ai = this.agentManager.updateAgentInstall(subject, agentInstall);
            SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
            try {
                AgentInstallInfo info = sshUtil.installAgent(customData, String.valueOf(ai.getId()));
                List steps = info.getSteps();
                AgentInstallStep lastInstallStep = (AgentInstallStep)steps.get(steps.size() - 1);
                if (lastInstallStep.getResultCode() != 0) {
                    throw new RuntimeException(lastInstallStep.getDescription() + " failed, " + lastInstallStep.getResult());
                }
                AgentInstallInfo agentInstallInfo = info;
                sshUtil.disconnect();
                return agentInstallInfo;
            }
            catch (Throwable throwable) {
                sshUtil.disconnect();
                throw throwable;
            }
        }
        finally {
            if (customData.getAgentConfigurationXmlFile() != null) {
                new File(customData.getAgentConfigurationXmlFile()).delete();
            }
            if (customData.getRhqAgentEnvFile() != null) {
                new File(customData.getRhqAgentEnvFile()).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String uninstallAgent(Subject subject, RemoteAccessInfo remoteAccessInfo, String agentInstallPath) {
        String agentName = remoteAccessInfo.getAgentName();
        if (agentName != null) {
            AgentInstall ai = this.agentManager.getAgentInstallByAgentName(subject, agentName);
            if (ai == null || ai.getInstallLocation() == null || ai.getInstallLocation().trim().length() == 0) {
                throw new IllegalArgumentException("Agent [" + agentName + "] does not have a known install location. For security purposes, the uninstall will not be allowed." + " You will have to manually uninstall it from that machine.");
            }
            if (ai.getSshHost() != null && !ai.getSshHost().equals(remoteAccessInfo.getHost())) {
                throw new IllegalArgumentException("Agent [" + agentName + "] is not known to be on host [" + remoteAccessInfo.getHost() + "] - aborting uninstall");
            }
        }
        SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
        try {
            String string = sshUtil.uninstallAgent(agentInstallPath);
            return string;
        }
        finally {
            sshUtil.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String startAgent(Subject subject, RemoteAccessInfo remoteAccessInfo, String agentInstallPath) {
        SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
        try {
            String results = sshUtil.startAgent(agentInstallPath);
            this.processRememberMe(subject, sshUtil);
            String string = results;
            return string;
        }
        finally {
            sshUtil.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String stopAgent(Subject subject, RemoteAccessInfo remoteAccessInfo, String agentInstallPath) {
        SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
        try {
            String results = sshUtil.stopAgent(agentInstallPath);
            this.processRememberMe(subject, sshUtil);
            String string = results;
            return string;
        }
        finally {
            sshUtil.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String agentStatus(Subject subject, RemoteAccessInfo remoteAccessInfo, String agentInstallPath) {
        SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
        try {
            String results = sshUtil.agentStatus(agentInstallPath);
            if (!"Agent Not Installed".equals(results)) {
                this.processRememberMe(subject, sshUtil);
            }
            String string = results;
            return string;
        }
        finally {
            sshUtil.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String findAgentInstallPath(Subject subject, RemoteAccessInfo remoteAccessInfo, String parentPath) {
        SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
        try {
            String results = sshUtil.findAgentInstallPath(parentPath);
            this.processRememberMe(subject, sshUtil);
            String string = results;
            return string;
        }
        finally {
            sshUtil.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String[] remotePathDiscover(Subject subject, RemoteAccessInfo remoteAccessInfo, String parentPath) {
        SSHInstallUtility sshUtil = this.getSSHConnection(remoteAccessInfo);
        try {
            String[] results = sshUtil.pathDiscovery(parentPath);
            this.processRememberMe(subject, sshUtil);
            String[] stringArray = results;
            return stringArray;
        }
        finally {
            sshUtil.disconnect();
        }
    }

    private SSHInstallUtility getSSHConnection(RemoteAccessInfo remoteAccessInfo) {
        if (remoteAccessInfo.getHost() == null) {
            throw new RuntimeException("Enter a host");
        }
        SystemSettings settings = this.systemSettingsManager.getUnmaskedSystemSettings(false);
        String username = (String)settings.get((Object)SystemSetting.REMOTE_SSH_USERNAME_DEFAULT);
        String password = (String)settings.get((Object)SystemSetting.REMOTE_SSH_PASSWORD_DEFAULT);
        SSHInstallUtility.Credentials creds = null;
        if (username != null && username.length() > 0 || password != null && password.length() > 0) {
            creds = new SSHInstallUtility.Credentials(username, password);
        }
        SSHInstallUtility.SSHConfiguration sshConfig = new SSHInstallUtility.SSHConfiguration();
        File dataDir = LookupUtil.getCoreServer().getJBossServerDataDir();
        File knownHosts = new File(dataDir, "rhq_known_hosts");
        try {
            knownHosts.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create a known_hosts file for SSH communication - aborting");
        }
        sshConfig.setKnownHostsFile(knownHosts.getAbsolutePath());
        SSHInstallUtility sshUtil = new SSHInstallUtility(remoteAccessInfo, creds, sshConfig);
        return sshUtil;
    }

    private void deobfuscateFile(File f) {
        if (!f.exists()) {
            throw new RuntimeException("Uploaded file has been purged and no longer available: " + f);
        }
        try {
            FileUtil.decompressFile((File)f);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot unobfuscate uploaded file [" + f + "]", e);
        }
    }
}

