/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.alert;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginValidator;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.AlertPluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.CustomUi;

public class AlertPluginValidator
implements ServerPluginValidator {
    @Override
    public boolean validate(ServerPluginEnvironment env) {
        Log log = LogFactory.getLog(AlertPluginValidator.class);
        AlertPluginDescriptorType type = (AlertPluginDescriptorType)env.getPluginDescriptor();
        String className = type.getPluginClass();
        if (!className.contains(".")) {
            className = type.getPackage() + "." + className;
        }
        try {
            Class.forName(className, false, env.getPluginClassLoader());
        }
        catch (Exception e) {
            log.error((Object)("Can't find pluginClass " + className + " for plugin " + env.getPluginKey().getPluginName()));
            return false;
        }
        String shortName = type.getShortName();
        CustomUi customUI = type.getCustomUi();
        if (customUI != null) {
            String uiSnippetPath = customUI.getUiSnippetName();
            try {
                URL uiSnippetUrl = env.getPluginClassLoader().getResource(uiSnippetPath);
                log.info((Object)("UI snipped for " + shortName + " is at " + uiSnippetUrl));
            }
            catch (Exception e) {
                log.error((Object)("No valid ui snippet provided, but <custom-ui> given for sender plugin " + shortName + "Error is " + e.getMessage()));
                return false;
            }
            className = customUI.getBackingBeanClass();
            if (!className.contains(".")) {
                className = type.getPackage() + "." + className;
            }
            try {
                Class.forName(className, true, env.getPluginClassLoader());
            }
            catch (Throwable t) {
                log.error((Object)("Backing bean " + className + " not found for plugin " + shortName));
                return false;
            }
        }
        return true;
    }
}

