/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.alert;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.plugin.ServerPluginManagerLocal;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderInfo;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.AlertPluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.CustomUi;

public class AlertSenderPluginManager
extends ServerPluginManager {
    private final Log log = this.getLog();
    private Map<String, String> pluginClassByName = new HashMap<String, String>();
    private Map<String, ServerPluginEnvironment> pluginEnvByName = new HashMap<String, ServerPluginEnvironment>();
    private Map<String, AlertSenderInfo> senderInfoByName = new HashMap<String, AlertSenderInfo>();
    private Map<String, String> backingBeanByName = new HashMap<String, String>();
    private Map<String, String> backingBeanNameByName = new HashMap<String, String>();

    public AlertSenderPluginManager(AbstractTypeServerPluginContainer pc) {
        super(pc);
    }

    @Override
    public void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        super.loadPlugin(env, enabled);
        if (enabled) {
            AlertPluginDescriptorType type = (AlertPluginDescriptorType)env.getPluginDescriptor();
            String className = type.getPluginClass();
            try {
                this.loadPluginClass(env, className, false);
            }
            catch (Exception e) {
                this.log.error((Object)("Alert sender class [" + className + "] defined in plugin [" + env.getPluginKey().getPluginName() + "] is invalid and will be ignored. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
                try {
                    this.unloadPlugin(env.getPluginKey().getPluginName());
                }
                catch (Throwable t) {
                    this.log.warn((Object)("  +--> unload failed too. Cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
                }
                throw e;
            }
            String shortName = type.getShortName();
            this.pluginClassByName.put(shortName, className);
            String uiSnippetPath = null;
            URL uiSnippetUrl = null;
            CustomUi customUI = type.getCustomUi();
            if (customUI != null) {
                uiSnippetPath = customUI.getUiSnippetName();
                try {
                    uiSnippetUrl = env.getPluginClassLoader().getResource(uiSnippetPath);
                    if (uiSnippetUrl == null) {
                        throw new Exception("plugin is missing alert ui snippet named [" + uiSnippetPath + "]");
                    }
                    this.log.debug((Object)("Alert plugin UI snippet for [" + shortName + "] is at: " + uiSnippetUrl));
                }
                catch (Exception e) {
                    this.log.error((Object)("Invalid alert UI snippet provided inside <custom-ui> for alert plugin [" + shortName + "]. Plugin will be ignored. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
                    throw e;
                }
                className = customUI.getBackingBeanClass();
                try {
                    this.loadPluginClass(env, className, true);
                    this.backingBeanByName.put(shortName, className);
                }
                catch (Throwable t) {
                    String errMsg = "Backing bean [" + className + "] not found for plugin [" + shortName + ']';
                    this.log.error((Object)errMsg);
                    throw new Exception(errMsg, t);
                }
                String beanName = customUI.getBackingBeanName();
                if (beanName == null || beanName.length() == 0) {
                    beanName = className;
                }
                this.backingBeanNameByName.put(shortName, beanName);
            }
            AlertSenderInfo info = new AlertSenderInfo(shortName, type.getDescription(), env.getPluginKey());
            info.setUiSnippetUrl(uiSnippetUrl);
            info.setUiSnippetShortPath(uiSnippetPath);
            this.senderInfoByName.put(shortName, info);
            this.pluginEnvByName.put(shortName, env);
        }
    }

    @Override
    protected void unloadPlugin(String pluginName) throws Exception {
        super.unloadPlugin(pluginName);
        String shortName = null;
        for (AlertSenderInfo info : this.senderInfoByName.values()) {
            if (!info.getPluginName().equals(pluginName)) continue;
            shortName = info.getShortName();
            break;
        }
        if (shortName != null) {
            this.pluginClassByName.remove(shortName);
            this.senderInfoByName.remove(shortName);
            this.pluginEnvByName.remove(shortName);
            this.backingBeanByName.remove(shortName);
        }
    }

    public AlertSender getAlertSenderForNotification(AlertNotification notification) {
        AlertSender sender;
        String senderName = notification.getSenderName();
        String className = this.pluginClassByName.get(senderName);
        if (className == null) {
            this.log.error((Object)("getAlertSenderForNotification: No pluginClass found for sender: " + senderName));
            return null;
        }
        ServerPluginEnvironment env = this.pluginEnvByName.get(senderName);
        try {
            sender = (AlertSender)this.instantiatePluginClass(env, className);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return null;
        }
        sender.alertParameters = this.getNewOrCleansed(notification.getConfiguration());
        sender.extraParameters = this.getNewOrCleansed(notification.getExtraConfiguration());
        ServerPluginContext ctx = this.getServerPluginContext(env);
        PluginKey key = ctx.getPluginEnvironment().getPluginKey();
        ServerPluginManagerLocal pluginsMgr = LookupUtil.getServerPluginManager();
        ServerPlugin plugin = pluginsMgr.getServerPlugin(key);
        plugin = pluginsMgr.getServerPluginRelationships(plugin);
        sender.preferences = this.getNewOrCleansed(plugin.getPluginConfiguration());
        sender.pluginComponent = this.getServerPluginComponent(key.getPluginName());
        sender.serverPluginEnvironment = this.pluginEnvByName.get(senderName);
        return sender;
    }

    private Configuration getNewOrCleansed(Configuration config) {
        if (config == null) {
            return new Configuration();
        }
        return config.deepCopy();
    }

    public List<String> getPluginList() {
        return new ArrayList<String>(this.pluginClassByName.keySet());
    }

    public AlertSenderInfo getAlertSenderInfo(String shortName) {
        return this.senderInfoByName.get(shortName);
    }

    public CustomAlertSenderBackingBean getBackingBeanForSender(String shortName) {
        String className = this.backingBeanByName.get(shortName);
        if (className == null) {
            return null;
        }
        ServerPluginEnvironment env = this.pluginEnvByName.get(shortName);
        CustomAlertSenderBackingBean bean = null;
        try {
            bean = (CustomAlertSenderBackingBean)this.instantiatePluginClass(env, className);
            bean.alertParameters = new Configuration();
        }
        catch (Exception e) {
            this.log.error((Object)("Can't instantiate alert sender backing bean [" + className + "]. Cause: " + e.getMessage()));
        }
        return bean;
    }

    public String getBackingBeanNameForSender(String shortName) {
        return this.backingBeanNameByName.get(shortName);
    }
}

