/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content.sync;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.AdvisoryBuglist;
import org.rhq.core.domain.content.AdvisoryCVE;
import org.rhq.core.domain.content.AdvisoryPackage;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.AdvisoryManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.AdvisoryBugDetails;
import org.rhq.enterprise.server.plugin.pc.content.AdvisoryCVEDetails;
import org.rhq.enterprise.server.plugin.pc.content.AdvisoryDetails;
import org.rhq.enterprise.server.plugin.pc.content.AdvisoryPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.AdvisorySource;
import org.rhq.enterprise.server.plugin.pc.content.AdvisorySyncReport;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.SyncException;
import org.rhq.enterprise.server.plugin.pc.content.SyncTracker;
import org.rhq.enterprise.server.plugin.pc.content.ThreadUtil;
import org.rhq.enterprise.server.util.LookupUtil;

public class AdvisorySourceSynchronizer {
    private final Log log = LogFactory.getLog(this.getClass());
    private RepoManagerLocal repoManager;
    private ContentSourceManagerLocal contentSourceManager;
    private SubjectManagerLocal subjectManager;
    private Repo repo;
    private ContentSource source;
    private ContentProvider provider;
    private PageControl pc = PageControl.getUnlimitedInstance();
    private Subject overlord;

    public AdvisorySourceSynchronizer(Repo repo, ContentSource source, ContentProvider provider) {
        this.repo = repo;
        this.source = source;
        this.provider = provider;
        this.repoManager = LookupUtil.getRepoManagerLocal();
        this.contentSourceManager = LookupUtil.getContentSourceManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.overlord = this.subjectManager.getOverlord();
    }

    public SyncTracker synchronizeAdvisoryMetadata(SyncTracker tracker) throws SyncException, InterruptedException {
        if (!(this.provider instanceof AdvisorySource)) {
            return tracker;
        }
        AdvisorySource advisorySource = (AdvisorySource)((Object)this.provider);
        this.log.error((Object)("Synchronize Advisory: [" + this.source.getName() + "]: syncing repo [" + this.repo.getName() + "]"));
        long start = System.currentTimeMillis();
        PageList<Advisory> advs = this.repoManager.findAssociatedAdvisory(this.overlord, this.repo.getId(), this.pc);
        this.log.error((Object)("Found " + advs.size() + " advisories for repo " + this.repo.getId()));
        ThreadUtil.checkInterrupted();
        AdvisorySyncReport advReport = new AdvisorySyncReport(this.repo.getId());
        ArrayList<AdvisoryDetails> advDetails = new ArrayList<AdvisoryDetails>(advs.size());
        this.translateDomainToDto((List<Advisory>)advs, (List<AdvisoryDetails>)advDetails);
        ThreadUtil.checkInterrupted();
        this.log.error((Object)("Synchronize Advisory: [" + this.source.getName() + "]: loaded existing list of size=[" + advs.size() + "] (" + (System.currentTimeMillis() - start) + ")ms"));
        start = System.currentTimeMillis();
        advisorySource.synchronizeAdvisory(this.repo.getName(), advReport, advDetails);
        ThreadUtil.checkInterrupted();
        this.log.error((Object)("Synchronize Advisory: [" + this.source.getName() + "]: got sync report from adapter=[" + advReport + "] (" + (System.currentTimeMillis() - start) + ")ms"));
        RepoSyncResults syncResults = this.contentSourceManager.mergeAdvisorySyncReport(this.source, advReport, tracker.getRepoSyncResults());
        ThreadUtil.checkInterrupted();
        this.log.error((Object)("Synchronize Advisory: [" + this.source.getName() + "]: finished mergeAdvisorySyncReport (" + (System.currentTimeMillis() - start) + ")ms"));
        tracker.setRepoSyncResults(syncResults);
        tracker.finishAdvisoryMetadataWork(this.provider);
        return tracker;
    }

    private void translateDomainToDto(List<Advisory> advs, List<AdvisoryDetails> advDetails) throws InterruptedException {
        AdvisoryManagerLocal advManager = LookupUtil.getAdvisoryManagerLocal();
        for (Advisory d : advs) {
            AdvisoryDetails detail = new AdvisoryDetails(d.getAdvisory(), d.getAdvisoryType(), d.getSynopsis());
            detail.setAdvisory(d.getAdvisory());
            detail.setAdvisory_name(d.getAdvisory_name());
            detail.setAdvisory_type(d.getAdvisoryType());
            detail.setDescription(d.getDescription());
            detail.setSolution(d.getSolution());
            detail.setIssue_date(d.getIssue_date());
            detail.setTopic(d.getTopic());
            detail.setUpdate_date(d.getUpdate_date());
            PageList<AdvisoryPackage> pkgs = advManager.findPackageByAdvisory(this.overlord, d.getId(), this.pc);
            for (AdvisoryPackage pkg : pkgs) {
                PackageVersion pv = advManager.findPackageVersionByPkgId(this.overlord, pkg.getPkg().getFileName(), this.pc);
                AdvisoryPackageDetails apkg = new AdvisoryPackageDetails(pv.getDisplayName(), pv.getVersion(), pv.getArchitecture().getName(), pv.getFileName());
                detail.addPkg(apkg);
            }
            PageList<AdvisoryCVE> cves = advManager.getAdvisoryCVEByAdvId(this.overlord, d.getId(), this.pc);
            for (AdvisoryCVE cve : cves) {
                AdvisoryCVEDetails acve = new AdvisoryCVEDetails(cve.getCVE().getName());
                detail.addCVE(acve);
            }
            List<AdvisoryBuglist> abugs = advManager.getAdvisoryBuglistByAdvId(this.overlord, d.getId());
            if (abugs != null && abugs.size() > 0) {
                for (AdvisoryBuglist abug : abugs) {
                    AdvisoryBugDetails abugdetail = new AdvisoryBugDetails(abug.getBugid());
                    detail.addBug(abugdetail);
                }
            }
            advDetails.add(detail);
            ThreadUtil.checkInterrupted();
        }
    }
}

