/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.purge;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.purge.AlertConditionLogPurge;
import org.rhq.enterprise.server.purge.AlertNotificationLogPurge;
import org.rhq.enterprise.server.purge.AlertPurge;
import org.rhq.enterprise.server.purge.AvailabilityPurge;
import org.rhq.enterprise.server.purge.BundleResourceDeploymentHistoryPurge;
import org.rhq.enterprise.server.purge.CallTimeDataValuePurge;
import org.rhq.enterprise.server.purge.EventDataPurge;
import org.rhq.enterprise.server.purge.GroupResourceConfigurationUpdatePurge;
import org.rhq.enterprise.server.purge.JPADriftFilePurge;
import org.rhq.enterprise.server.purge.MeasurementDataTraitPurge;
import org.rhq.enterprise.server.purge.MeasurementOOBPurge;
import org.rhq.enterprise.server.purge.PartitionEventDetailsPurge;
import org.rhq.enterprise.server.purge.PartitionEventPurge;
import org.rhq.enterprise.server.purge.PurgeManagerLocal;
import org.rhq.enterprise.server.purge.ResourceConfigurationUpdateFromGroupPurge;
import org.rhq.enterprise.server.purge.ResourceConfigurationUpdatePurge;

@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class PurgeManagerBean
implements PurgeManagerLocal {
    private static final Log LOG = LogFactory.getLog(PurgeManagerBean.class);
    @Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
    private DataSource dataSource;
    @Resource
    private UserTransaction userTransaction;

    @Override
    public int purgeAvailabilities(long oldest) {
        AvailabilityPurge availabilityPurge = new AvailabilityPurge(this.dataSource, this.userTransaction, oldest);
        long startTime = System.currentTimeMillis();
        int deleted = availabilityPurge.execute();
        MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
        MeasurementMonitor.getMBean().setPurgedAvailabilities(deleted);
        return deleted;
    }

    @Override
    public int purgeTraits(long oldest) {
        MeasurementDataTraitPurge traitPurge = new MeasurementDataTraitPurge(this.dataSource, this.userTransaction, oldest);
        long startTime = System.currentTimeMillis();
        int deleted = traitPurge.execute();
        MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
        MeasurementMonitor.getMBean().setPurgedMeasurementTraits(deleted);
        return deleted;
    }

    @Override
    public int purgeEventData(long deleteUpToTime) {
        EventDataPurge eventDataPurge = new EventDataPurge(this.dataSource, this.userTransaction, deleteUpToTime);
        long startTime = System.currentTimeMillis();
        int deleted = eventDataPurge.execute();
        MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
        MeasurementMonitor.getMBean().setPurgedEvents(deleted);
        return deleted;
    }

    @Override
    public int purgeCallTimeData(long deleteUpToTime) {
        CallTimeDataValuePurge callTimeDataValuePurge = new CallTimeDataValuePurge(this.dataSource, this.userTransaction, deleteUpToTime);
        long startTime = System.currentTimeMillis();
        int deletedRowCount = callTimeDataValuePurge.execute();
        MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
        MeasurementMonitor.getMBean().setPurgedCallTimeData(deletedRowCount);
        return deletedRowCount;
    }

    @Override
    public int deleteAlerts(long beginTime, long endTime) {
        long totalTime = 0L;
        AlertConditionLogPurge conditionLogPurge = new AlertConditionLogPurge(this.dataSource, this.userTransaction, beginTime, endTime);
        long start = System.currentTimeMillis();
        int conditionsDeleted = conditionLogPurge.execute();
        long end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleted [" + conditionsDeleted + "] alert condition logs in [" + (end - start) + "]ms"));
        }
        totalTime += end - start;
        AlertNotificationLogPurge notificationLogPurge = new AlertNotificationLogPurge(this.dataSource, this.userTransaction, beginTime, endTime);
        start = System.currentTimeMillis();
        int deletedNotifications = notificationLogPurge.execute();
        end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleted [" + deletedNotifications + "] alert notifications in [" + (end - start) + "]ms"));
        }
        totalTime += end - start;
        AlertPurge alertPurge = new AlertPurge(this.dataSource, this.userTransaction, beginTime, endTime);
        start = System.currentTimeMillis();
        int deletedAlerts = alertPurge.execute();
        end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleted [" + deletedAlerts + "] alerts in [" + (end - start) + "]ms"));
        }
        MeasurementMonitor.getMBean().incrementPurgeTime(totalTime += end - start);
        MeasurementMonitor.getMBean().setPurgedAlerts(deletedAlerts);
        MeasurementMonitor.getMBean().setPurgedAlertConditions(conditionsDeleted);
        MeasurementMonitor.getMBean().setPurgedAlertNotifications(deletedNotifications);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleted [" + (deletedAlerts + conditionsDeleted + deletedNotifications) + "] " + "alert audit records in [" + totalTime + "]ms"));
        }
        return deletedAlerts;
    }

    @Override
    public void removeOutdatedOOBs(long cutoffTime) {
        MeasurementOOBPurge measurementOOBPurge = new MeasurementOOBPurge(this.dataSource, this.userTransaction, cutoffTime);
        int count = measurementOOBPurge.execute();
        LOG.info((Object)("Removed [" + count + "] outdated OOBs"));
    }

    @Override
    public int purgeOrphanedBundleResourceDeploymentHistory() {
        BundleResourceDeploymentHistoryPurge purge = new BundleResourceDeploymentHistoryPurge(this.dataSource, this.userTransaction);
        return purge.execute();
    }

    @Override
    public int purgeOrphanedDriftFilesInDatabase(long purgeMillis) {
        JPADriftFilePurge purge = new JPADriftFilePurge(this.dataSource, this.userTransaction, purgeMillis);
        return purge.execute();
    }

    @Override
    public int purgePartitionEvents(long deleteUpToTime) {
        PartitionEventDetailsPurge detailsPurge = new PartitionEventDetailsPurge(this.dataSource, this.userTransaction, deleteUpToTime);
        detailsPurge.execute();
        PartitionEventPurge eventPurge = new PartitionEventPurge(this.dataSource, this.userTransaction, deleteUpToTime);
        return eventPurge.execute();
    }

    @Override
    public int purgeResourceConfigHistory(long deleteUpToTime) {
        int purged = 0;
        purged += new ResourceConfigurationUpdatePurge(this.dataSource, this.userTransaction, deleteUpToTime).execute();
        purged += new ResourceConfigurationUpdateFromGroupPurge(this.dataSource, this.userTransaction, deleteUpToTime).execute();
        return purged += new GroupResourceConfigurationUpdatePurge(this.dataSource, this.userTransaction, deleteUpToTime).execute();
    }
}

