/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.criteria.BundleCriteria;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.ContentMetadataManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

@Stateless
public class ContentMetadataManagerBean
implements ContentMetadataManagerLocal {
    private static final Log log = LogFactory.getLog(ContentMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;
    @EJB
    private ConfigurationMetadataManagerLocal configurationMetadataMgr;
    @EJB
    private BundleManagerLocal bundleMgr;
    @EJB
    private ResourceTypeManagerLocal resourceTypeMgr;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateMetadata(ResourceType existingType, ResourceType newType) {
        log.debug((Object)("Updating bundle type and package types for " + existingType));
        existingType = (ResourceType)this.entityMgr.find(ResourceType.class, (Object)existingType.getId());
        BundleType newBundleType = newType.getBundleType();
        if (newBundleType != null) {
            BundleType existingBundleType = existingType.getBundleType();
            HashSet<ResourceType> targetedResourceTypes = new HashSet<ResourceType>(newBundleType.getExplicitlyTargetedResourceTypes().size());
            if (!newBundleType.getExplicitlyTargetedResourceTypes().isEmpty()) {
                for (ResourceType targetType : newBundleType.getExplicitlyTargetedResourceTypes()) {
                    ResourceType existingTargetType = this.resourceTypeMgr.getResourceTypeByNameAndPlugin(targetType.getName(), targetType.getPlugin());
                    if (existingTargetType == null) {
                        throw new IllegalStateException("Cannot find a resource type explicitly targeted by bundle type " + newBundleType + ". This should not happen because such type should always be persisted prior to the bundle type.");
                    }
                    targetedResourceTypes.add(existingTargetType);
                }
            }
            if (existingBundleType != null) {
                newBundleType.setId(existingBundleType.getId());
            }
            newBundleType.setResourceType(existingType);
            newBundleType.getExplicitlyTargetedResourceTypes().clear();
            newBundleType.getExplicitlyTargetedResourceTypes().addAll(targetedResourceTypes);
            newBundleType = (BundleType)this.entityMgr.merge((Object)newBundleType);
            existingType.setBundleType(newBundleType);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating bundle type to " + newBundleType));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing bundle type");
        }
        existingType.setBundleType(null);
        ResourceTypeBundleConfiguration newBundleConfiguration = newType.getResourceTypeBundleConfiguration();
        ResourceTypeBundleConfiguration existingBundleConfiguration = existingType.getResourceTypeBundleConfiguration();
        if (newBundleConfiguration != null) {
            if (existingBundleConfiguration == null) {
                existingType.setResourceTypeBundleConfiguration(newBundleConfiguration);
            } else if (!existingBundleConfiguration.equals((Object)newBundleConfiguration)) {
                this.entityMgr.remove((Object)existingBundleConfiguration.getBundleConfiguration());
                this.entityMgr.persist((Object)newBundleConfiguration.getBundleConfiguration());
                existingType.setResourceTypeBundleConfiguration(newBundleConfiguration);
            }
        } else if (existingBundleConfiguration != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Removing bundle configuration");
            }
            this.entityMgr.remove((Object)existingBundleConfiguration.getBundleConfiguration());
            existingType.setResourceTypeBundleConfiguration(null);
        }
        if (newType.getPackageTypes().isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing all package types for " + existingType));
            }
            for (PackageType packageType : existingType.getPackageTypes()) {
                this.entityMgr.remove((Object)packageType);
            }
            existingType.getPackageTypes().clear();
            return;
        }
        if (existingType.getPackageTypes().isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(existingType + " previously did not define any package types. Adding " + newType.getPackageTypes()));
            }
            for (PackageType newPackageType : newType.getPackageTypes()) {
                newPackageType.setResourceType(existingType);
                this.entityMgr.persist((Object)newPackageType);
            }
            existingType.setPackageTypes(newType.getPackageTypes());
            return;
        }
        Set existingPackageTypes = existingType.getPackageTypes();
        HashMap<String, PackageType> newPackageTypeDefinitions = new HashMap<String, PackageType>(newType.getPackageTypes().size());
        for (PackageType newPackageType : newType.getPackageTypes()) {
            newPackageTypeDefinitions.put(newPackageType.getName(), newPackageType);
        }
        ArrayList removedPackageTypes = new ArrayList(existingType.getPackageTypes());
        removedPackageTypes.removeAll(newType.getPackageTypes());
        for (PackageType removedPackageType : removedPackageTypes) {
            existingType.removePackageType(removedPackageType);
            this.entityMgr.remove((Object)removedPackageType);
        }
        ArrayList mergedPackageTypes = new ArrayList(existingType.getPackageTypes());
        mergedPackageTypes.retainAll(newType.getPackageTypes());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating package types: " + mergedPackageTypes));
        }
        for (PackageType mergedPackageType : mergedPackageTypes) {
            this.updatePackageConfigurations(mergedPackageType, (PackageType)newPackageTypeDefinitions.get(mergedPackageType.getName()));
            mergedPackageType.update((PackageType)newPackageTypeDefinitions.get(mergedPackageType.getName()));
            this.entityMgr.merge((Object)mergedPackageType);
        }
        ArrayList newPackageTypes = new ArrayList(newType.getPackageTypes());
        newPackageTypes.removeAll(existingType.getPackageTypes());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding package types: " + newPackageTypes));
        }
        for (PackageType newPackageType : newPackageTypes) {
            newPackageType.setResourceType(existingType);
            this.entityMgr.persist((Object)newPackageType);
            existingPackageTypes.add(newPackageType);
        }
    }

    void updatePackageConfigurations(PackageType existingType, PackageType newType) {
        ConfigurationDefinition newConfigurationDefinition = newType.getDeploymentConfigurationDefinition();
        if (newConfigurationDefinition != null) {
            if (existingType.getDeploymentConfigurationDefinition() == null) {
                this.entityMgr.persist((Object)newConfigurationDefinition);
                existingType.setDeploymentConfigurationDefinition(newConfigurationDefinition);
            } else {
                ConfigurationDefinition existingDefinition = existingType.getDeploymentConfigurationDefinition();
                this.configurationMetadataMgr.updateConfigurationDefinition(newConfigurationDefinition, existingDefinition);
            }
        } else if (existingType.getDeploymentConfigurationDefinition() != null) {
            existingType.setDeploymentConfigurationDefinition(null);
        }
    }

    @Override
    public void deleteMetadata(Subject subject, ResourceType resourceType) {
        log.debug((Object)("Deleting bundle type and bundles for " + resourceType));
        try {
            this.deleteBundles(subject, resourceType);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete bundles for " + resourceType, e);
        }
    }

    private void deleteBundles(final Subject subject, ResourceType resourceType) throws Exception {
        BundleType bundleType = resourceType.getBundleType();
        if (bundleType == null) {
            return;
        }
        BundleCriteria criteria = new BundleCriteria();
        criteria.addFilterBundleTypeId(Integer.valueOf(bundleType.getId()));
        CriteriaQueryExecutor<Bundle, BundleCriteria> queryExecutor = new CriteriaQueryExecutor<Bundle, BundleCriteria>(){

            @Override
            public PageList<Bundle> execute(BundleCriteria criteria) {
                return ContentMetadataManagerBean.this.bundleMgr.findBundlesByCriteria(subject, criteria);
            }
        };
        CriteriaQuery<Bundle, BundleCriteria> bundles = new CriteriaQuery<Bundle, BundleCriteria>(criteria, queryExecutor);
        for (Bundle bundle : bundles) {
            this.bundleMgr.deleteBundle(subject, bundle.getId());
        }
    }
}

