/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MeasurementMetadataManagerLocal;

@Stateless
public class MeasurementMetadataManagerBean
implements MeasurementMetadataManagerLocal {
    private static final Log LOG = LogFactory.getLog(MeasurementMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;
    @EJB
    private MeasurementScheduleManagerLocal scheduleMgr;
    @EJB
    private MeasurementDefinitionManagerLocal measurementDefinitionMgr;
    @EJB
    private SubjectManagerLocal subjectMgr;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateMetadata(ResourceType existingType, ResourceType newType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating metric definitions for " + existingType));
        }
        existingType = (ResourceType)this.entityMgr.find(ResourceType.class, (Object)existingType.getId());
        Set existingDefinitions = existingType.getMetricDefinitions();
        Set<MeasurementDefinition> newTypeMetricDefinitions = MeasurementMetadataManagerBean.getMetricDefinitions(newType);
        if (existingDefinitions.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(existingType + " currently does not define any metric definitions. " + "New metric definitions to be added: " + newType.getMetricDefinitions()));
            }
            for (MeasurementDefinition newDefinition : newType.getMetricDefinitions()) {
                if (newDefinition.getDefaultInterval() < 30000L) {
                    newDefinition.setDefaultInterval(30000L);
                    LOG.info((Object)("Definition [" + newDefinition + "] has too short of a default interval, setting to minimum"));
                }
                existingType.addMetricDefinition(newDefinition);
                this.entityMgr.persist((Object)newDefinition);
                this.scheduleMgr.createSchedulesForExistingResources(existingType, newDefinition);
            }
        } else {
            for (MeasurementDefinition newDefinition : newType.getMetricDefinitions()) {
                boolean found = false;
                for (MeasurementDefinition existingDefinition : existingDefinitions) {
                    if (!existingDefinition.getName().equals(newDefinition.getName()) || existingDefinition.isPerMinute() != newDefinition.isPerMinute()) continue;
                    found = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Updating existing metric definition: " + existingDefinition));
                    }
                    boolean isAvail = "rhq.availability".equals(newDefinition.getName());
                    long defaultInterval = ResourceCategory.SERVER == existingDefinition.getResourceType().getCategory() ? MeasurementDefinition.AVAILABILITY_DEFAULT_PERIOD_SERVER : MeasurementDefinition.AVAILABILITY_DEFAULT_PERIOD_SERVICE;
                    boolean updateInterval = isAvail && defaultInterval == existingDefinition.getDefaultInterval();
                    existingDefinition.update(newDefinition, updateInterval);
                    if (existingDefinition.getDefaultInterval() < 30000L) {
                        existingDefinition.setDefaultInterval(30000L);
                        LOG.info((Object)("Definition [" + existingDefinition + "] has too short of a default interval, setting to minimum"));
                    }
                    this.entityMgr.merge((Object)existingDefinition);
                    break;
                }
                if (found) continue;
                LOG.info((Object)("Metadata update: Adding new " + newDefinition.getDataType().name().toLowerCase() + " definition [" + newDefinition.getDisplayName() + "] to type " + existingType + "..."));
                existingType.addMetricDefinition(newDefinition);
                this.entityMgr.persist((Object)newDefinition);
                this.scheduleMgr.createSchedulesForExistingResources(existingType, newDefinition);
            }
            ArrayList<MeasurementDefinition> definitionsToDelete = new ArrayList<MeasurementDefinition>();
            for (MeasurementDefinition existingDefinition : existingDefinitions) {
                if (newType.getMetricDefinitions().contains(existingDefinition)) continue;
                definitionsToDelete.add(existingDefinition);
            }
            existingDefinitions.removeAll(definitionsToDelete);
            for (MeasurementDefinition definitionToDelete : definitionsToDelete) {
                LOG.info((Object)("Metadata update: Removing " + definitionToDelete.getDataType().name().toLowerCase() + " definition [" + definitionToDelete.getDisplayName() + "] from type " + existingType + "..."));
                this.measurementDefinitionMgr.removeMeasurementDefinition(definitionToDelete);
            }
            this.entityMgr.flush();
        }
    }

    public static Set<MeasurementDefinition> getMetricDefinitions(ResourceType newType) {
        long period;
        Set result = newType.getMetricDefinitions();
        result = null == result ? new HashSet(1) : result;
        switch (newType.getCategory()) {
            case PLATFORM: {
                return result;
            }
            case SERVER: {
                period = MeasurementDefinition.AVAILABILITY_DEFAULT_PERIOD_SERVER;
                break;
            }
            default: {
                period = MeasurementDefinition.AVAILABILITY_DEFAULT_PERIOD_SERVICE;
            }
        }
        MeasurementDefinition rhqAvailability = new MeasurementDefinition(newType, "rhq.availability");
        rhqAvailability.setDefaultInterval(period);
        rhqAvailability.setDefaultOn(true);
        rhqAvailability.setCategory(MeasurementCategory.AVAILABILITY);
        rhqAvailability.setDisplayName("Availability");
        rhqAvailability.setDescription("The number of seconds between availability checks. The agent honors this setting as best as possible but the actual period can be longer based on agent activity.");
        rhqAvailability.setDataType(DataType.AVAILABILITY);
        rhqAvailability.setUnits(MeasurementUnits.NONE);
        rhqAvailability.setNumericType(NumericType.DYNAMIC);
        rhqAvailability.setDisplayType(DisplayType.DETAIL);
        if (!result.contains(rhqAvailability)) {
            result.add(rhqAvailability);
        } else {
            MeasurementDefinition aResult;
            MeasurementDefinition override = null;
            Iterator i$ = result.iterator();
            while (i$.hasNext() && !(override = (aResult = (MeasurementDefinition)i$.next())).equals((Object)rhqAvailability)) {
            }
            override.setCategory(MeasurementCategory.AVAILABILITY);
            override.setDisplayName("Availability");
            override.setDescription("The number of seconds between availability checks. The agent honors this setting as best as possible but the actual period can be longer based on agent activity.");
            override.setDataType(DataType.AVAILABILITY);
            override.setUnits(MeasurementUnits.NONE);
            override.setNumericType(NumericType.DYNAMIC);
            override.setDisplayType(DisplayType.DETAIL);
        }
        return result;
    }

    @Override
    public void deleteMetadata(ResourceType existingType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting metric definitions for " + existingType));
        }
        MeasurementDefinitionCriteria criteria = new MeasurementDefinitionCriteria();
        criteria.addFilterResourceTypeId(Integer.valueOf(existingType.getId()));
        criteria.setRestriction(Criteria.Restriction.COLLECTION_ONLY);
        List<MeasurementDefinition> definitions = Collections.emptyList();
        do {
            for (MeasurementDefinition definition : definitions) {
                this.measurementDefinitionMgr.removeMeasurementDefinition(definition);
            }
        } while (!(definitions = this.measurementDefinitionMgr.findMeasurementDefinitionsByCriteria(this.subjectMgr.getOverlord(), criteria)).isEmpty());
    }
}

