/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.Arrays;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationDefinitionUpdateReport;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.util.BatchIterator;

@Stateless
public class PluginConfigurationMetadataManagerBean
implements PluginConfigurationMetadataManagerLocal {
    private static Log log = LogFactory.getLog(PluginConfigurationMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;
    @EJB
    private ConfigurationMetadataManagerLocal configurationMetadataMgr;
    @EJB
    private PluginConfigurationMetadataManagerLocal pluginConfigurationMetadataMgr;
    @EJB
    private SubjectManagerLocal subjectMgr;
    @EJB
    private ResourceManagerLocal resourceMgr;

    @Override
    public void updatePluginConfigurationDefinition(ResourceType existingType, ResourceType newType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating plugin configuration definition for " + existingType));
        }
        existingType = (ResourceType)this.entityMgr.find(ResourceType.class, (Object)existingType.getId());
        ConfigurationDefinition existingConfigurationDefinition = existingType.getPluginConfigurationDefinition();
        if (newType.getPluginConfigurationDefinition() != null) {
            if (existingConfigurationDefinition == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(existingType + " currently does not have a plugin configuration definition. Adding " + "new plugin configuration."));
                }
                this.entityMgr.persist((Object)newType.getPluginConfigurationDefinition());
                existingType.setPluginConfigurationDefinition(newType.getPluginConfigurationDefinition());
            } else {
                ConfigurationDefinitionUpdateReport updateReport;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating plugin configuration definition for " + existingType));
                }
                if ((updateReport = this.configurationMetadataMgr.updateConfigurationDefinition(newType.getPluginConfigurationDefinition(), existingConfigurationDefinition)).getNewPropertyDefinitions().size() > 0 || updateReport.getUpdatedPropertyDefinitions().size() > 0) {
                    List<Integer> resourceIds = this.resourceMgr.findIdsByTypeIds(Arrays.asList(existingType.getId()));
                    BatchIterator<Integer> batchIterator = new BatchIterator<Integer>(resourceIds, 200);
                    while (batchIterator.hasMoreBatches()) {
                        this.pluginConfigurationMetadataMgr.updateResourcePluginConfigurationsInNewTransaction(batchIterator.getNextBatch(), updateReport);
                    }
                }
            }
        } else if (existingConfigurationDefinition != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing plugin configuration definition for " + existingType));
            }
            existingType.setPluginConfigurationDefinition(null);
            this.entityMgr.remove((Object)existingConfigurationDefinition);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateResourcePluginConfigurationsInNewTransaction(List<Integer> resourceIds, ConfigurationDefinitionUpdateReport updateReport) {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterIds(resourceIds.toArray(new Integer[resourceIds.size()]));
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        PageList<Resource> resources = this.resourceMgr.findResourcesByCriteria(this.subjectMgr.getOverlord(), criteria);
        for (Resource resource : resources) {
            boolean modified = false;
            ConfigurationTemplate template = updateReport.getConfigurationDefinition().getDefaultTemplate();
            Configuration templateConfiguration = template.getConfiguration();
            for (PropertyDefinition propertyDef : updateReport.getNewPropertyDefinitions()) {
                if (!propertyDef.isRequired()) continue;
                Property templateProperty = templateConfiguration.get(propertyDef.getName());
                if (templateProperty == null) {
                    throw new IllegalArgumentException("The property [" + propertyDef.getName() + "] marked as required in the configuration definition of [" + propertyDef.getConfigurationDefinition().getName() + "] has no attribute 'default'");
                }
                Configuration pluginConfiguration = resource.getPluginConfiguration();
                int numberOfProperties = pluginConfiguration.getProperties().size();
                pluginConfiguration.put(templateProperty.deepCopy(false));
                modified = true;
            }
            for (PropertyDefinition propertyDef : updateReport.getUpdatedPropertyDefinitions()) {
                if (!propertyDef.isRequired()) continue;
                Configuration pluginConfiguration = resource.getPluginConfiguration();
                int numberOfProperties = pluginConfiguration.getProperties().size();
                String propertyValue = pluginConfiguration.getSimpleValue(propertyDef.getName(), null);
                if (propertyValue != null) continue;
                Property templateProperty = templateConfiguration.get(propertyDef.getName());
                pluginConfiguration.put(templateProperty.deepCopy(false));
                modified = true;
            }
            if (!modified) continue;
            resource.setAgentSynchronizationNeeded();
        }
    }
}

