/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.lang.reflect.UndeclaredThrowableException;
import javax.ejb.EJBException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.ParameterMissingException;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.RHQErrorWrapper;

@Provider
public class CustomExceptionMapper
implements ExceptionMapper<Exception> {
    @Context
    private HttpHeaders httpHeaders;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public Response toResponse(Exception e) {
        Response.Status status;
        String message = null;
        if (e instanceof StuffNotFoundException) {
            status = Response.Status.NOT_FOUND;
        } else if (e instanceof ResourceNotFoundException) {
            status = Response.Status.NOT_FOUND;
        } else if (e instanceof ResourceGroupNotFoundException) {
            status = Response.Status.NOT_FOUND;
        } else if (e instanceof ResourceTypeNotFoundException) {
            status = Response.Status.NOT_FOUND;
        } else if (e instanceof ParameterMissingException) {
            status = Response.Status.NOT_ACCEPTABLE;
        } else if (e instanceof BadArgumentException) {
            status = Response.Status.NOT_ACCEPTABLE;
        } else if (e instanceof PermissionException) {
            status = Response.Status.FORBIDDEN;
        } else if (e instanceof EJBException && e.getCause() != null) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException) {
                status = Response.Status.NOT_ACCEPTABLE;
            } else if (cause instanceof UndeclaredThrowableException) {
                if (cause.getCause() != null && cause.getCause() instanceof IllegalAccessException) {
                    status = Response.Status.FORBIDDEN;
                    message = "User was authorized, but has no rights for the operation. If this is an LDAP user, the user needs to log in to the UI and complete registration.";
                } else {
                    status = Response.Status.SERVICE_UNAVAILABLE;
                }
            } else {
                status = Response.Status.SERVICE_UNAVAILABLE;
            }
        } else {
            status = Response.Status.SERVICE_UNAVAILABLE;
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        if (message == null) {
            message = e.getMessage();
        }
        this.wrapMessage(builder, message);
        return builder.build();
    }

    private void wrapMessage(Response.ResponseBuilder builder, String message) {
        MediaType mediaType;
        try {
            mediaType = (MediaType)this.httpHeaders.getAcceptableMediaTypes().get(0);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage());
            mediaType = MediaType.TEXT_PLAIN_TYPE;
        }
        if (mediaType.getType().equals("text") && mediaType.getSubtype().equals("csv")) {
            mediaType = MediaType.TEXT_PLAIN_TYPE;
        }
        if (mediaType.equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            message = message + "\n";
            builder.entity((Object)message);
        } else if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder.entity((Object)("<html><body><h1>Error</h1><h2>" + message + "</h2></body></html>"));
        } else {
            RHQErrorWrapper error = new RHQErrorWrapper(message);
            builder.entity((Object)error);
        }
        builder.type(mediaType);
    }
}

