/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.domain;

import com.wordnik.swagger.annotations.ApiClass;
import com.wordnik.swagger.annotations.ApiProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.rhq.enterprise.server.rest.domain.Link;

@XmlRootElement
@ApiClass(value="Represents an operation to be scheduled.", description="You use this object to prepare the operation to be scheduled. The object is derived from an OperationDefinition. When you are ready preparing,you need to set 'readyToSubmit' to true.")
public class OperationRest {
    int id;
    String name;
    boolean readyToSubmit;
    int resourceId;
    int definitionId;
    Map<String, Object> params = new HashMap<String, Object>();
    List<Link> links = new ArrayList<Link>();

    public OperationRest() {
    }

    public OperationRest(int resourceId, int definitionId) {
        this.resourceId = resourceId;
        this.definitionId = definitionId;
    }

    @ApiProperty(value="Id of the operation schedule")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @ApiProperty(value="Name of the operation")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiProperty(value="Is this schedule ready to finally be submitted (and thus be scheduled to run)")
    public boolean isReadyToSubmit() {
        return this.readyToSubmit;
    }

    public void setReadyToSubmit(boolean readyToSubmit) {
        this.readyToSubmit = readyToSubmit;
    }

    @ApiProperty(value="The id of the resource the operation should run ")
    public int getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    @ApiProperty(value="The id of the operation definition this schedule was created from")
    public int getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(int definitionId) {
        this.definitionId = definitionId;
    }

    @ApiProperty(value="A key/value map of parameters. Keys are strings. The map is populated at the time the schedule is created from its definition")
    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    @XmlElementRef
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationRest that = (OperationRest)o;
        if (this.definitionId != that.definitionId) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.resourceId != that.resourceId) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id ^ this.id >>> 32;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.resourceId;
        result = 31 * result + this.definitionId;
        return result;
    }
}

