/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.purge.PurgeManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.domain.AggregateNumericMetric;

public class DataCalcJob
extends AbstractStatefulJob {
    private static final Log LOG = LogFactory.getLog(DataCalcJob.class);

    public static void calcNow() throws Exception {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        SimpleTrigger trigger = new SimpleTrigger("DataCalcJobNow", DataCalcJob.class.getName());
        trigger.setJobName(DataCalcJob.class.getName());
        trigger.setJobGroup(DataCalcJob.class.getName());
        scheduler.scheduleJob((Trigger)trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)"Data Calc Job STARTING");
        try {
            Iterable<AggregateNumericMetric> oneHourAggregates = this.compressMeasurementData();
            this.calculateAutoBaselines(LookupUtil.getMeasurementBaselineManager());
            this.calculateOOBs(oneHourAggregates);
        }
        catch (Exception e) {
            LOG.error((Object)("Data Calc Job FAILED TO COMPLETE. Cause: " + e));
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Data Calc Job FINISHED [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<AggregateNumericMetric> compressMeasurementData() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Measurement data compression starting at " + new Date(timeStart)));
        try {
            StorageClientManager storageClientManager = LookupUtil.getStorageClientManager();
            MetricsServer metricsServer = storageClientManager.getMetricsServer();
            Iterable iterable = metricsServer.calculateAggregates();
            return iterable;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to compress measurement data. Cause: " + e), (Throwable)e);
            List<AggregateNumericMetric> list = Collections.emptyList();
            return list;
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Measurement data compression completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateAutoBaselines(MeasurementBaselineManagerLocal measurementBaselineManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Auto-calculation of baselines starting at " + new Date(timeStart)));
        try {
            measurementBaselineManager.calculateAutoBaselines();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to auto-calculate baselines. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Auto-calculation of baselines completed in [" + duration + "]ms"));
        }
    }

    public void calculateOOBs(Iterable<AggregateNumericMetric> oneHourAggregates) {
        LOG.info((Object)"Auto-calculation of OOBs starting");
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        MeasurementOOBManagerLocal manager = LookupUtil.getOOBManager();
        PurgeManagerLocal purgeManager = LookupUtil.getPurgeManager();
        SystemManagerLocal systemManager = LookupUtil.getSystemManager();
        long cutOff = System.currentTimeMillis() - 1800000L;
        long timeStart = System.currentTimeMillis();
        purgeManager.removeOutdatedOOBs(cutOff);
        systemManager.vacuum(overlord, new String[]{"RHQ_MEASUREMENT_OOB"});
        manager.computeOOBsForLastHour(overlord, oneHourAggregates);
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Auto-calculation of OOBs completed in [" + duration + "]ms"));
    }
}

