/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.purge.PurgeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.TimingVoodoo;

public class DataPurgeJob
extends AbstractStatefulJob {
    private static final Log LOG = LogFactory.getLog(DataPurgeJob.class);
    private static final long HOUR = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private final SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
    private final SystemManagerLocal systemManager = LookupUtil.getSystemManager();
    private final PurgeManagerLocal purgeManager = LookupUtil.getPurgeManager();
    private final OperationManagerLocal operationManager = LookupUtil.getOperationManager();
    private final AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
    private final AlertConditionManagerLocal alertConditionManager = LookupUtil.getAlertConditionManager();
    private final AlertNotificationManagerLocal alertNotificationManager = LookupUtil.getAlertNotificationManager();
    private final DriftManagerLocal driftManager = LookupUtil.getDriftManager();
    private final ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    public static void purgeNow() throws Exception {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        SimpleTrigger trigger = new SimpleTrigger("DataPurgeJobNow", DataPurgeJob.class.getName());
        trigger.setJobName(DataPurgeJob.class.getName());
        trigger.setJobGroup(DataPurgeJob.class.getName());
        scheduler.scheduleJob((Trigger)trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)"Data Purge Job STARTING");
        try {
            Subject overlord = this.subjectManager.getOverlord();
            SystemSettings systemSettings = this.systemManager.getSystemSettings(overlord);
            this.purgeEverything(systemSettings);
            this.performDatabaseMaintenance(systemSettings);
        }
        catch (Exception e) {
            LOG.error((Object)("Data Purge Job FAILED TO COMPLETE. Cause: " + e));
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Data Purge Job FINISHED [" + duration + "]ms"));
        }
    }

    private void purgeEverything(SystemSettings systemSettings) {
        this.purgeCallTimeData(systemSettings);
        this.purgeEventData(systemSettings);
        this.purgeAlertData(systemSettings);
        this.purgeUnusedAlertDefinitions();
        this.purgeOrphanedAlertConditions();
        this.purgeOrphanedAlertNotifications();
        this.purgeMeasurementTraitData(systemSettings);
        this.purgeAvailabilityData(systemSettings);
        this.purgeOrphanedDriftFiles(systemSettings);
        this.purgeOperationHistoryData(systemSettings);
        this.purgeOrphanedBundleResourceDeploymentHistory();
        this.purgePartitionEventsData(systemSettings);
        this.purgeResourceConfigHistory(systemSettings);
        this.removeResourceErrorDuplicates();
        this.removeStaleAvailabilityResourceErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeMeasurementTraitData(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Trait data purge starting at " + new Date(timeStart)));
        int traitsPurged = 0;
        try {
            long threshold;
            String traitPurgeThresholdStr = (String)systemSettings.get((Object)SystemSetting.TRAIT_PURGE_PERIOD);
            if (traitPurgeThresholdStr == null) {
                threshold = timeStart - 31536000000L;
                LOG.debug((Object)"No purge traits threshold found - will purge traits older than one year");
            } else {
                threshold = timeStart - Long.parseLong(traitPurgeThresholdStr);
            }
            LOG.info((Object)("Purging traits that are older than " + new Date(threshold)));
            traitsPurged = this.purgeManager.purgeTraits(threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge trait data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Traits data purged [" + traitsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOperationHistoryData(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        int purgeCount = 0;
        try {
            long purgeThreshold;
            String purgeThresholdStr = (String)systemSettings.get((Object)SystemSetting.OPERATION_HISTORY_PURGE_PERIOD);
            long l = purgeThreshold = purgeThresholdStr != null ? Long.parseLong(purgeThresholdStr) : 0L;
            if (purgeThreshold <= 0L) {
                LOG.info((Object)"Operation History threshold set to 0, skipping purge of operation history data.");
                return;
            }
            LOG.info((Object)("Operation History data purge starting at " + new Date(timeStart)));
            long threshold = timeStart - purgeThreshold;
            Date purgeBeforeTime = new Date(threshold);
            LOG.info((Object)("Purging operation history older than " + purgeBeforeTime));
            purgeCount = this.operationManager.purgeOperationHistory(purgeBeforeTime);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge operation history data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Operation history data purged [" + purgeCount + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAvailabilityData(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Availability data purge starting at " + new Date(timeStart)));
        int availsPurged = 0;
        try {
            long threshold;
            String availPurgeThresholdStr = (String)systemSettings.get((Object)SystemSetting.AVAILABILITY_PURGE_PERIOD);
            if (availPurgeThresholdStr == null) {
                threshold = timeStart - 31536000000L;
                LOG.debug((Object)"No purge avails threshold found - will purge availabilities older than one year");
            } else {
                threshold = timeStart - Long.parseLong(availPurgeThresholdStr);
            }
            LOG.info((Object)("Purging availablities that are older than " + new Date(threshold)));
            availsPurged = this.purgeManager.purgeAvailabilities(threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge availability data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Availability data purged [" + availsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeCallTimeData(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Measurement calltime data purge starting at " + new Date(timeStart)));
        int calltimePurged = 0;
        try {
            long threshold = timeStart - Long.parseLong((String)systemSettings.get((Object)SystemSetting.RT_DATA_PURGE_PERIOD));
            LOG.info((Object)("Purging calltime data that is older than " + new Date(threshold)));
            calltimePurged = this.purgeManager.purgeCallTimeData(threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge calltime data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Calltime purged [" + calltimePurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeEventData(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Event data purge starting at " + new Date(timeStart)));
        int eventsPurged = 0;
        try {
            long threshold = timeStart - Long.parseLong((String)systemSettings.get((Object)SystemSetting.EVENT_PURGE_PERIOD));
            LOG.info((Object)("Purging event data older than " + new Date(threshold)));
            eventsPurged = this.purgeManager.purgeEventData(threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge event data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Event data purged [" + eventsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAlertData(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert data purge starting at " + new Date(timeStart)));
        int alertsPurged = 0;
        try {
            long threshold = timeStart - Long.parseLong((String)systemSettings.get((Object)SystemSetting.ALERT_PURGE_PERIOD));
            LOG.info((Object)("Purging alert data older than " + new Date(threshold)));
            alertsPurged = this.purgeManager.deleteAlerts(0L, threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge alert data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Alert data purged [" + alertsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeUnusedAlertDefinitions() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert definition unused purge starting at " + new Date(timeStart)));
        int alertDefinitionsPurged = 0;
        try {
            alertDefinitionsPurged = this.alertDefinitionManager.purgeUnusedAlertDefinitions();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge alert definition data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Alert definitions purged [" + alertDefinitionsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOrphanedAlertConditions() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert condition orphan purge starting at " + new Date(timeStart)));
        int orphansPurged = 0;
        try {
            orphansPurged = this.alertConditionManager.purgeOrphanedAlertConditions();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge alert condition data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Purged [" + orphansPurged + "] orphan alert conditions - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOrphanedAlertNotifications() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert notification orphan purge starting at " + new Date(timeStart)));
        int orphansPurged = 0;
        try {
            orphansPurged = this.alertNotificationManager.purgeOrphanedAlertNotifications();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge alert notification data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Purged [" + orphansPurged + "] orphan alert notifications - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOrphanedDriftFiles(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Drift file orphan purge starting at " + new Date(timeStart)));
        int orphansPurged = 0;
        try {
            long threshold = timeStart - Long.parseLong((String)systemSettings.get((Object)SystemSetting.DRIFT_FILE_PURGE_PERIOD));
            LOG.info((Object)("Purging orphaned drift files older than " + new Date(threshold)));
            orphansPurged = this.driftManager.purgeOrphanedDriftFiles(this.subjectManager.getOverlord(), threshold);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge orphaned drift files. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Purged [" + orphansPurged + "] orphaned drift files - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOrphanedBundleResourceDeploymentHistory() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Orphaned bundle audit messages purge starting at " + new Date(timeStart)));
        int orphansPurged = 0;
        try {
            orphansPurged = this.purgeManager.purgeOrphanedBundleResourceDeploymentHistory();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge orphaned bundle audit messages. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Purged [" + orphansPurged + "] orphaned bundle audit messages - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgePartitionEventsData(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Partition event data purge starting at " + new Date(timeStart)));
        int eventsPurged = 0;
        try {
            long purgeThreshold;
            String purgeThresholdStr = (String)systemSettings.get((Object)SystemSetting.PARTITION_EVENT_PURGE_PERIOD);
            long l = purgeThreshold = purgeThresholdStr != null ? Long.parseLong(purgeThresholdStr) : 0L;
            if (purgeThreshold <= 0L) {
                LOG.info((Object)"Partition event threshold set to 0, skipping purge of operation history data.");
                return;
            }
            long deleteUpToTime = timeStart - purgeThreshold;
            LOG.info((Object)("Purging partition event data older than " + new Date(deleteUpToTime)));
            eventsPurged = this.purgeManager.purgePartitionEvents(deleteUpToTime);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge partition event data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Partition event data purged [" + eventsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeResourceConfigHistory(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Resource configuration history purge starting at " + new Date(timeStart)));
        int configurationsPurged = 0;
        try {
            long purgeThreshold;
            String purgeThresholdStr = (String)systemSettings.get((Object)SystemSetting.RESOURCE_CONFIG_HISTORY_PURGE_PERIOD);
            long l = purgeThreshold = purgeThresholdStr != null ? Long.parseLong(purgeThresholdStr) : 0L;
            if (purgeThreshold <= 0L) {
                LOG.info((Object)"Resource configuration history threshold set to 0, skipping purge of resource configuration history data.");
                return;
            }
            long deleteUpToTime = timeStart - purgeThreshold;
            LOG.info((Object)("Purging resource configuration history data older than " + new Date(deleteUpToTime)));
            configurationsPurged = this.purgeManager.purgeResourceConfigHistory(deleteUpToTime);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to purge resource configuration history data. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Resource configuration history purged [" + configurationsPurged + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResourceErrorDuplicates() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Resource error duplicates removal starting at " + new Date(timeStart)));
        int deleted = 0;
        try {
            deleted = this.resourceManager.removeResourceErrorDuplicates();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to remove resource error duplicates.", (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Resource error duplicates removed [" + deleted + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleAvailabilityResourceErrors() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Stale availability resource errors removal starting at " + new Date(timeStart)));
        int deleted = 0;
        try {
            deleted = this.resourceManager.removeStaleAvailabilityResourceErrors();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to remove stale availability resource errors.", (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Stale availability resource errors removed [" + deleted + "] - completed in [" + duration + "]ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDatabaseMaintenance(SystemSettings systemSettings) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Database maintenance starting at " + new Date(timeStart)));
        try {
            String dataMaintenance = (String)systemSettings.get((Object)SystemSetting.DATA_MAINTENANCE_PERIOD);
            if (dataMaintenance == null) {
                LOG.error((Object)"No data maintenance interval found - will not perform db maintenance");
                return;
            }
            long maintInterval = Long.parseLong(dataMaintenance);
            Calendar cal = Calendar.getInstance();
            if (cal.get(11) == 0) {
                LOG.info((Object)"Performing daily database maintenance");
                this.systemManager.vacuum(this.subjectManager.getOverlord());
                String reindexStr = (String)systemSettings.get((Object)SystemSetting.DATA_REINDEX_NIGHTLY);
                boolean reindexNightly = Boolean.valueOf(reindexStr);
                if (reindexNightly) {
                    LOG.info((Object)"Re-indexing data tables");
                    this.systemManager.reindex(this.subjectManager.getOverlord());
                } else {
                    LOG.info((Object)"Skipping re-indexing of data tables");
                }
            } else if (TimingVoodoo.roundDownTime(timeStart, HOUR) == TimingVoodoo.roundDownTime(timeStart, maintInterval)) {
                LOG.info((Object)"Performing hourly database maintenance");
                this.systemManager.analyze(this.subjectManager.getOverlord());
            } else {
                LOG.debug((Object)"Not performing any database maintenance now");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to perform database maintenance. Cause: " + e), (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Database maintenance completed in [" + duration + "]ms"));
        }
    }
}

