/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync;

import java.util.Collections;
import java.util.Set;
import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.sync.entity.SystemSettings;
import org.rhq.enterprise.server.sync.NoSingleEntity;
import org.rhq.enterprise.server.sync.Synchronizer;
import org.rhq.enterprise.server.sync.exporters.Exporter;
import org.rhq.enterprise.server.sync.exporters.SystemSettingsExporter;
import org.rhq.enterprise.server.sync.importers.Importer;
import org.rhq.enterprise.server.sync.importers.SystemSettingsImporter;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SystemSettingsSynchronizer
implements Synchronizer<NoSingleEntity, SystemSettings> {
    private Subject subject;
    private SystemManagerLocal systemManager;

    public SystemSettingsSynchronizer() {
        this(LookupUtil.getSystemManager());
    }

    public SystemSettingsSynchronizer(SystemManagerLocal systemManager) {
        this.systemManager = systemManager;
    }

    @Override
    public void initialize(Subject subject, EntityManager entityManager) {
        this.subject = subject;
    }

    @Override
    public Exporter<NoSingleEntity, SystemSettings> getExporter() {
        return new SystemSettingsExporter(this.subject, this.systemManager);
    }

    @Override
    public Importer<NoSingleEntity, SystemSettings> getImporter() {
        return new SystemSettingsImporter(this.subject, this.systemManager);
    }

    @Override
    public Set<ConsistencyValidator> getRequiredValidators() {
        return Collections.emptySet();
    }
}

