/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync;

import java.util.Set;
import org.rhq.core.domain.sync.ConsistencyValidatorFailureReport;
import org.rhq.enterprise.server.sync.SynchronizationException;

public class ValidationException
extends SynchronizationException {
    private static final long serialVersionUID = 1L;
    private Set<ConsistencyValidatorFailureReport> validationReports;

    public ValidationException(Set<ConsistencyValidatorFailureReport> validationReports) {
        this.validationReports = validationReports;
    }

    public ValidationException(String message, Set<ConsistencyValidatorFailureReport> validationReports) {
        super(message);
        this.validationReports = validationReports;
    }

    public ValidationException(String message, Throwable cause, Set<ConsistencyValidatorFailureReport> validationReports) {
        super(message, cause);
        this.validationReports = validationReports;
    }

    public ValidationException(Throwable cause, Set<ConsistencyValidatorFailureReport> validationReports) {
        super(cause);
        this.validationReports = validationReports;
    }

    public ValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(Throwable cause) {
        super(cause);
    }

    public Set<ConsistencyValidatorFailureReport> getValidationReports() {
        return this.validationReports;
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder(super.toString());
        if (this.validationReports != null && !this.validationReports.isEmpty()) {
            bld.append("\nReports of individual validators:\n");
            for (ConsistencyValidatorFailureReport r : this.validationReports) {
                bld.append("\n").append(r);
            }
        }
        return bld.toString();
    }
}

