/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.exporters;

import java.util.Collections;
import java.util.Map;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.sync.entity.SystemSettings;
import org.rhq.enterprise.server.sync.NoSingleEntity;
import org.rhq.enterprise.server.sync.exporters.Exporter;
import org.rhq.enterprise.server.sync.exporters.ExportingIterator;
import org.rhq.enterprise.server.sync.exporters.JAXBExportingIterator;
import org.rhq.enterprise.server.system.SystemManagerLocal;

public class SystemSettingsExporter
implements Exporter<NoSingleEntity, SystemSettings> {
    private Subject subject;
    private SystemManagerLocal systemManager;

    public SystemSettingsExporter(Subject subject, SystemManagerLocal systemManager) {
        this.subject = subject;
        this.systemManager = systemManager;
    }

    @Override
    public ExportingIterator<SystemSettings> getExportingIterator() {
        Map systemProps = this.systemManager.getObfuscatedSystemSettings(false).toMap();
        SystemSettings settings = new SystemSettings(systemProps);
        return new SystemSettingsExportingIterator(settings);
    }

    @Override
    public String getNotes() {
        return null;
    }

    private static class SystemSettingsExportingIterator
    extends JAXBExportingIterator<SystemSettings, SystemSettings> {
        public SystemSettingsExportingIterator(SystemSettings settings) {
            super(Collections.singleton(settings).iterator(), SystemSettings.class);
        }

        @Override
        protected SystemSettings convert(SystemSettings object) {
            return object;
        }

        @Override
        public String getNotes() {
            return null;
        }
    }
}

