/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.validators;

import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.sync.entity.SystemSettings;
import org.rhq.enterprise.server.sync.ValidationException;
import org.rhq.enterprise.server.sync.validators.EntityValidator;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SystemSettingsValidator
implements EntityValidator<SystemSettings> {
    private Subject subject;
    private SystemManagerLocal systemManager;

    public SystemSettingsValidator() {
        this(LookupUtil.getSystemManager());
    }

    public SystemSettingsValidator(SystemManagerLocal systemManager) {
        this.systemManager = systemManager;
    }

    @Override
    public void initialize(Subject subject, EntityManager entityManager) {
        this.subject = subject;
    }

    @Override
    public void validateExportedEntity(SystemSettings entity) throws ValidationException {
        try {
            this.systemManager.validateSystemConfiguration(this.subject, entity.toProperties());
        }
        catch (Exception e) {
            throw new ValidationException("The system settings failed to validate: " + e.getMessage(), e);
        }
    }
}

