/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.Collection;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.PhantomReadMaxAttemptsExceededException;

public class QueryUtility {
    private static final Log LOG = LogFactory.getLog(QueryUtility.class);
    private static String ESCAPE_CHARACTER = null;
    private static String ESCAPE_CLAUSE_CHARACTER = null;
    private static String ESCAPED_ESCAPE = null;
    private static String ESCAPED_PERCENT = null;
    private static String ESCAPED_UNDERSCORE = null;
    public static final int DEFAULT_PHANTOM_READ_MAX_ATTEMPTS = 10;
    public static final int DEFAULT_PHANTOM_READ_MIN_WAIT_TIME = 100;
    public static final int DEFAULT_PHANTOM_READ_MAX_WAIT_TIME = 1000;
    public static final int PHANTOM_READ_MAX_ATTEMPTS = QueryUtility.readIntFromSysProp("rhq.server.database.phantom-read.max-retries", 10, true);
    public static final int PHANTOM_READ_MIN_WAIT_TIME = QueryUtility.readIntFromSysProp("rhq.server.database.phantom-read.min-wait-time", 100, false);
    public static final int PHANTOM_READ_MAX_WAIT_TIME = QueryUtility.readIntFromSysProp("rhq.server.database.phantom-read.max-wait-time", 1000, false);
    private static final float INCREASE_COEFF = new PagedDataFetchSettings().getLagIncreaseCoefficient();

    private static int readIntFromSysProp(String propName, int defaultValue, boolean zeroAllowed) {
        String valueAsString = System.getProperty(propName, Integer.toString(defaultValue));
        int value = defaultValue;
        String errorMessage = "The '" + propName + "' property has an invalid value '" + valueAsString + "'. " + "It is expected to be a positive integer " + (zeroAllowed ? "or 0" : "") + ". It has been set instead to " + "the default value of '" + defaultValue + "'.";
        try {
            value = Integer.parseInt(valueAsString);
            if (zeroAllowed && value < 0 || value <= 0) {
                LOG.error((Object)errorMessage);
                value = defaultValue;
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)errorMessage, (Throwable)e);
        }
        return value;
    }

    public static <T> PageList<T> fetchPagedDataAndCount(Query dataQuery, Query countQuery, PageControl pageControl, PagedDataFetchSettings settings) throws PhantomReadMaxAttemptsExceededException {
        float coeff;
        PersistenceUtility.setDataPage((Query)dataQuery, (PageControl)pageControl);
        List data = dataQuery.getResultList();
        int count = (int)((Long)countQuery.getSingleResult()).longValue();
        int cnt = 0;
        float waitTime = settings == null ? (float)PHANTOM_READ_MIN_WAIT_TIME : (float)settings.getMinWaitTime();
        int maxAttempts = settings == null ? PHANTOM_READ_MAX_ATTEMPTS : settings.getMaxAttempts();
        long time = System.currentTimeMillis();
        float f = coeff = settings == null ? INCREASE_COEFF : settings.getLagIncreaseCoefficient();
        while (!pageControl.isConsistentWith((Collection)data, count) && ++cnt < maxAttempts) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Possible phantom read detected while running a query. The collection size = " + data.size() + ", count = " + count + ", pageControl = " + pageControl + ". Attempt number " + cnt + ". Will wait for " + (int)waitTime + "ms."), (Throwable)new Exception());
            }
            try {
                Thread.sleep((int)Math.ceil(waitTime));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            data = dataQuery.getResultList();
            count = (int)((Long)countQuery.getSingleResult()).longValue();
            waitTime *= coeff;
        }
        PageList ret = new PageList((Collection)data, count, pageControl);
        if (cnt == maxAttempts && settings != null && settings.isThrowOnMaxAttempts()) {
            time = System.currentTimeMillis() - time;
            throw new PhantomReadMaxAttemptsExceededException(maxAttempts, ret, time);
        }
        return ret;
    }

    public static String escapeSearchParameter(String value) {
        if (value == null || value.trim().equals("")) {
            return "";
        }
        return QueryUtility.doEscapeSearchParameter(value);
    }

    private static String doEscapeSearchParameter(String value) {
        QueryUtility.init();
        value = value.replace(ESCAPE_CHARACTER, ESCAPED_ESCAPE);
        value = value.replace("_", ESCAPED_UNDERSCORE);
        value = value.replace("%", ESCAPED_PERCENT);
        value = value.replace("'", "''");
        return value;
    }

    public static String formatSearchParameter(String value) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        return "%" + QueryUtility.doEscapeSearchParameter(value).toUpperCase() + "%";
    }

    public static String getEscapeClause() {
        QueryUtility.init();
        return " ESCAPE '" + ESCAPE_CLAUSE_CHARACTER + "' ";
    }

    public static String getEscapeClauseCharacter() {
        QueryUtility.init();
        return ESCAPE_CLAUSE_CHARACTER;
    }

    public static String getEscapeCharacter() {
        QueryUtility.init();
        return ESCAPE_CHARACTER;
    }

    private static void init() {
        if (null == ESCAPE_CLAUSE_CHARACTER) {
            ESCAPE_CLAUSE_CHARACTER = DatabaseTypeFactory.getDefaultDatabaseType().getEscapeCharacter();
            int len = ESCAPE_CLAUSE_CHARACTER.length();
            ESCAPE_CHARACTER = len > 1 ? ESCAPE_CLAUSE_CHARACTER.substring(len - 1) : ESCAPE_CLAUSE_CHARACTER;
            ESCAPED_ESCAPE = ESCAPE_CHARACTER + ESCAPE_CHARACTER;
            ESCAPED_UNDERSCORE = ESCAPE_CHARACTER + "_";
            ESCAPED_PERCENT = ESCAPE_CHARACTER + "%";
        }
    }

    public static class PagedDataFetchSettings {
        private boolean throwOnMaxAttempts = false;
        private int maxAttempts = PHANTOM_READ_MAX_ATTEMPTS;
        private int minWaitTime = PHANTOM_READ_MIN_WAIT_TIME;
        private int maxWaitTime = PHANTOM_READ_MAX_WAIT_TIME;
        private float increaseCoeff;

        public PagedDataFetchSettings() {
            this.recalculateIncreaseCoeff();
        }

        public float getLagIncreaseCoefficient() {
            return this.increaseCoeff;
        }

        public long getMinimumTotalWaitTime() {
            if (this.increaseCoeff != 1.0f) {
                return (long)((double)this.minWaitTime * (Math.pow(this.increaseCoeff, this.maxAttempts - 1) - 1.0) / (double)(this.increaseCoeff - 1.0f));
            }
            return this.minWaitTime * (this.maxAttempts - 1);
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(int maxAttempts) {
            if (maxAttempts < 0) {
                throw new IllegalArgumentException("Max attempts must be >= 0");
            }
            this.maxAttempts = maxAttempts;
            this.recalculateIncreaseCoeff();
        }

        public int getMaxWaitTime() {
            return this.maxWaitTime;
        }

        public void setMaxWaitTime(int maxWaitTime) {
            if (maxWaitTime <= 0) {
                throw new IllegalArgumentException("Max wait time must be > 0");
            }
            this.maxWaitTime = maxWaitTime;
            this.recalculateIncreaseCoeff();
        }

        public int getMinWaitTime() {
            return this.minWaitTime;
        }

        public void setMinWaitTime(int minWaitTime) {
            if (this.maxWaitTime <= 0) {
                throw new IllegalArgumentException("Min wait time must be > 0");
            }
            this.minWaitTime = minWaitTime;
            this.recalculateIncreaseCoeff();
        }

        public boolean isThrowOnMaxAttempts() {
            return this.throwOnMaxAttempts;
        }

        public void setThrowOnMaxAttempts(boolean throwOnMaxAttempts) {
            this.throwOnMaxAttempts = throwOnMaxAttempts;
        }

        private void recalculateIncreaseCoeff() {
            this.increaseCoeff = this.maxAttempts < 3 ? 1.0f : (float)Math.pow((double)this.maxWaitTime / (double)this.minWaitTime, 1.0 / (double)(this.maxAttempts - 2));
        }
    }
}

