/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.util.units.test;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.core.server.MeasurementParser;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.testng.annotations.Test;

@Test
public class MeasurementConverterTest
extends AbstractEJB3Test {
    private final double POSITIVE = 300.0;
    private final double NEGATIVE = -42.0;
    private final String[] WHITESPACE = new String[]{" ", "\f", "\n", "\r", "\t"};
    private ThreadLocal<Integer> precisionScalingTestCount = null;

    private void incrementPrecisionScalingTestCount() {
        if (this.precisionScalingTestCount == null) {
            this.precisionScalingTestCount = new ThreadLocal<Integer>(){

                @Override
                protected Integer initialValue() {
                    return 0;
                }
            };
        }
        this.precisionScalingTestCount.set(this.precisionScalingTestCount.get() + 1);
    }

    @Test(groups={"integration.ejb3"}, enabled=false)
    public void testPrecisionScaling() throws Exception {
        this.testPrecisionScaling(new double[]{1.41, 1.41, 1.41, 1.41, 1.41}, MeasurementUnits.NONE, new String[]{"1.41", "1.41", "1.41", "1.41", "1.41"}, MeasurementUnits.NONE);
        this.testPrecisionScaling(new double[]{1.41, 1.42, 1.43, 1.44, 1.45}, MeasurementUnits.NONE, new String[]{"1.41", "1.42", "1.43", "1.44", "1.45"}, MeasurementUnits.NONE);
        this.testPrecisionScaling(new double[]{1.4, 1.4, 1.5, 1.6, 1.7}, MeasurementUnits.NONE, new String[]{"1.4", "1.4", "1.5", "1.6", "1.7"}, MeasurementUnits.NONE);
        this.testPrecisionScaling(new double[]{128.0, 256.0, 512.0, 1024.0, 8192.0}, MeasurementUnits.BYTES, new String[]{"0.1KB", "0.2KB", "0.5KB", "1KB", "8KB"}, MeasurementUnits.KILOBYTES);
        this.testPrecisionScaling(new double[]{-128.0, -256.0, -512.0, -1024.0, -8192.0}, MeasurementUnits.BYTES, new String[]{"-0.1KB", "-0.2KB", "-0.5KB", "-1KB", "-8KB"}, MeasurementUnits.KILOBYTES);
        this.testPrecisionScaling(new double[]{0.0, 0.065, 1.0, 0.123456}, MeasurementUnits.PERCENTAGE, new String[]{"0%", "6.5%", "100%", "12.3%"}, MeasurementUnits.PERCENTAGE);
        this.testPrecisionScaling(new double[]{0.0621, 0.065, 0.062, 0.6202}, MeasurementUnits.PERCENTAGE, new String[]{"6.21%", "6.5%", "6.2%", "62.02%"}, MeasurementUnits.PERCENTAGE);
    }

    private void testPrecisionScaling(double[] values, MeasurementUnits units, String[] expectedResults, MeasurementUnits expectedUnits) {
        this.incrementPrecisionScalingTestCount();
        String[] results = MeasurementConverter.formatToSignificantPrecision((double[])values, (MeasurementUnits)units, (boolean)true);
        for (int i = 0; i < results.length; ++i) {
            String expected = expectedResults[i];
            String actual = results[i];
            if (expected.contains(".") && !Locale.getDefault().equals(Locale.US)) {
                Locale defaultLocale = Locale.getDefault();
                Locale.setDefault(Locale.US);
                MeasurementNumericValueAndUnits vu = MeasurementParser.parse((String)expected, (MeasurementUnits)expectedUnits);
                Locale.setDefault(defaultLocale);
                expected = MeasurementConverter.format((Double)vu.getValue(), (MeasurementUnits)expectedUnits, (boolean)false, null, (Integer)4);
            }
            assert (actual.equals(expected)) : "Test " + this.precisionScalingTestCount.get() + ": " + "Index " + i + ", " + "Expected " + expected + ", " + "Received " + actual + ", " + "Units " + units.getName();
        }
    }

    @Test(groups={"integration.ejb3"}, enabled=false)
    public void testConversionSuccess() throws Exception {
        String toBeTested;
        String original;
        for (MeasurementUnits units : MeasurementUnits.values()) {
            this.validateFormatConvert(300.0, units);
            this.validateFormatConvert(-42.0, units);
        }
        NumberFormat nf = DecimalFormat.getNumberInstance();
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(1);
        List<String> signVariations = this.getWhitespaceVariationsAroundSingleTokens("", "+");
        List<String> magnitudeVariations = this.getWhitespaceVariationsAroundSingleTokens(nf.format(300.0));
        for (MeasurementUnits units : MeasurementUnits.values()) {
            List<String> unitsVariations = this.getWhitespaceVariationsAroundSingleTokens(units.toString());
            for (String signVariation : signVariations) {
                for (String magnitudeVariation : magnitudeVariations) {
                    if (MeasurementUnits.Family.RELATIVE == units.getFamily()) {
                        magnitudeVariation = nf.format(MeasurementUnits.scaleUp((Double)nf.parse(magnitudeVariation.trim()).doubleValue(), (MeasurementUnits)units));
                    }
                    for (String unitVariation : unitsVariations) {
                        original = MeasurementConverter.format((Double)300.0, (MeasurementUnits)units, (boolean)false);
                        toBeTested = magnitudeVariation.trim() + unitVariation.trim();
                        assert (original.equals(toBeTested)) : "Error constructing whitespace string: Expected '" + original + "', " + "Received '" + toBeTested + "' " + "for units '" + units.name() + "'";
                        this.validateConvert(300.0, signVariation + magnitudeVariation + unitVariation, units);
                    }
                }
            }
        }
        signVariations = this.getWhitespaceVariationsAroundSingleTokens("-");
        for (MeasurementUnits units : MeasurementUnits.values()) {
            List<String> unitsVariations = this.getWhitespaceVariationsAroundSingleTokens(units.toString());
            for (String signVariation : signVariations) {
                for (String magnitudeVariation : magnitudeVariations) {
                    if (units == MeasurementUnits.PERCENTAGE) {
                        magnitudeVariation = nf.format(100.0 * nf.parse(magnitudeVariation.trim()).doubleValue());
                    }
                    for (String unitVariation : unitsVariations) {
                        original = MeasurementConverter.format((Double)-300.0, (MeasurementUnits)units, (boolean)false);
                        toBeTested = "-" + magnitudeVariation.trim() + unitVariation.trim();
                        assert (original.equals(toBeTested)) : "Error constructing whitespace string: Expected '" + original + "', " + "Received '" + toBeTested + "' " + "for units '" + units.name() + "'";
                        this.validateConvert(-300.0, signVariation + magnitudeVariation + unitVariation, units);
                    }
                }
            }
        }
    }

    @Test(groups={"integration.ejb3"})
    public void testScalingSuccess() throws Exception {
        this.validateScaleAndInverse(1024.0, MeasurementUnits.BYTES, 1.0, MeasurementUnits.KILOBYTES);
        this.validateScaleAndInverse(1048576.0, MeasurementUnits.BYTES, 1.0, MeasurementUnits.MEGABYTES);
        this.validateScaleAndInverse(1.073741824E9, MeasurementUnits.BYTES, 1.0, MeasurementUnits.GIGABYTES);
        this.validateScaleAndInverse(1.099511627776E12, MeasurementUnits.BYTES, 1.0, MeasurementUnits.TERABYTES);
        this.validateScaleAndInverse(1.125899906842624E15, MeasurementUnits.BYTES, 1.0, MeasurementUnits.PETABYTES);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.KILOBYTES, 1.0, MeasurementUnits.MEGABYTES);
        this.validateScaleAndInverse(1048576.0, MeasurementUnits.KILOBYTES, 1.0, MeasurementUnits.GIGABYTES);
        this.validateScaleAndInverse(1.073741824E9, MeasurementUnits.KILOBYTES, 1.0, MeasurementUnits.TERABYTES);
        this.validateScaleAndInverse(1.099511627776E12, MeasurementUnits.KILOBYTES, 1.0, MeasurementUnits.PETABYTES);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.MEGABYTES, 1.0, MeasurementUnits.GIGABYTES);
        this.validateScaleAndInverse(1048576.0, MeasurementUnits.MEGABYTES, 1.0, MeasurementUnits.TERABYTES);
        this.validateScaleAndInverse(1.073741824E9, MeasurementUnits.MEGABYTES, 1.0, MeasurementUnits.PETABYTES);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.GIGABYTES, 1.0, MeasurementUnits.TERABYTES);
        this.validateScaleAndInverse(1048576.0, MeasurementUnits.GIGABYTES, 1.0, MeasurementUnits.PETABYTES);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.TERABYTES, 1.0, MeasurementUnits.PETABYTES);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.BITS, 1.0, MeasurementUnits.KILOBITS);
        this.validateScaleAndInverse(1048576.0, MeasurementUnits.BITS, 1.0, MeasurementUnits.MEGABITS);
        this.validateScaleAndInverse(1.073741824E9, MeasurementUnits.BITS, 1.0, MeasurementUnits.GIGABITS);
        this.validateScaleAndInverse(1.099511627776E12, MeasurementUnits.BITS, 1.0, MeasurementUnits.TERABITS);
        this.validateScaleAndInverse(1.125899906842624E15, MeasurementUnits.BITS, 1.0, MeasurementUnits.PETABITS);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.KILOBITS, 1.0, MeasurementUnits.MEGABITS);
        this.validateScaleAndInverse(1048576.0, MeasurementUnits.KILOBITS, 1.0, MeasurementUnits.GIGABITS);
        this.validateScaleAndInverse(1.073741824E9, MeasurementUnits.KILOBITS, 1.0, MeasurementUnits.TERABITS);
        this.validateScaleAndInverse(1.099511627776E12, MeasurementUnits.KILOBITS, 1.0, MeasurementUnits.PETABITS);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.MEGABITS, 1.0, MeasurementUnits.GIGABITS);
        this.validateScaleAndInverse(1048576.0, MeasurementUnits.MEGABITS, 1.0, MeasurementUnits.TERABITS);
        this.validateScaleAndInverse(1.073741824E9, MeasurementUnits.MEGABITS, 1.0, MeasurementUnits.PETABITS);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.GIGABITS, 1.0, MeasurementUnits.TERABITS);
        this.validateScaleAndInverse(1048576.0, MeasurementUnits.GIGABITS, 1.0, MeasurementUnits.PETABITS);
        this.validateScaleAndInverse(1024.0, MeasurementUnits.TERABITS, 1.0, MeasurementUnits.PETABITS);
        this.validateScaleAndInverse(1000.0, MeasurementUnits.EPOCH_MILLISECONDS, 1.0, MeasurementUnits.EPOCH_SECONDS);
        this.validateScaleAndInverse(1000.0, MeasurementUnits.MILLISECONDS, 1.0, MeasurementUnits.SECONDS);
        this.validateScaleAndInverse(60000.0, MeasurementUnits.MILLISECONDS, 1.0, MeasurementUnits.MINUTES);
        this.validateScaleAndInverse(3600000.0, MeasurementUnits.MILLISECONDS, 1.0, MeasurementUnits.HOURS);
        this.validateScaleAndInverse(8.64E7, MeasurementUnits.MILLISECONDS, 1.0, MeasurementUnits.DAYS);
        this.validateScaleAndInverse(60.0, MeasurementUnits.SECONDS, 1.0, MeasurementUnits.MINUTES);
        this.validateScaleAndInverse(3600.0, MeasurementUnits.SECONDS, 1.0, MeasurementUnits.HOURS);
        this.validateScaleAndInverse(86400.0, MeasurementUnits.SECONDS, 1.0, MeasurementUnits.DAYS);
        this.validateScaleAndInverse(60.0, MeasurementUnits.MINUTES, 1.0, MeasurementUnits.HOURS);
        this.validateScaleAndInverse(1440.0, MeasurementUnits.MINUTES, 1.0, MeasurementUnits.DAYS);
        this.validateScaleAndInverse(24.0, MeasurementUnits.HOURS, 1.0, MeasurementUnits.DAYS);
    }

    private void validateScaleAndInverse(double fromValue, MeasurementUnits fromUnits, double toValue, MeasurementUnits toUnits) {
        this.validateScale(fromValue, fromUnits, toValue, toUnits);
        this.validateScale(toValue, toUnits, fromValue, fromUnits);
    }

    private void validateScale(double fromValue, MeasurementUnits fromUnits, double toValue, MeasurementUnits toUnits) {
        block3: {
            MeasurementNumericValueAndUnits valueAndUnits = new MeasurementNumericValueAndUnits(Double.valueOf(fromValue), fromUnits);
            try {
                double derived = MeasurementConverter.scale((MeasurementNumericValueAndUnits)valueAndUnits, (MeasurementUnits)toUnits);
                assert (Math.abs(toValue - derived) < 1.0E-9) : "Scale conversion error: From value '" + fromValue + "', " + "with units of '" + fromUnits.name() + "', " + "displayed as '" + fromUnits + "', " + "To value '" + toValue + "', " + "with units of '" + toUnits.name() + "', " + "displayed as '" + toUnits + "', " + "Received value '" + derived + "'";
            }
            catch (MeasurementConversionException mce) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("Unexpected MeasurementConversionException: From value '" + fromValue + "', " + "with units of '" + fromUnits.name() + "', " + "displayed as '" + fromUnits + "', " + "To value '" + toValue + "', " + "with units of '" + toUnits.name() + "', " + "displayed as '" + toUnits));
            }
        }
    }

    private void validateFormatConvert(double value, MeasurementUnits units) {
        this.validateFormatConvert(value, value, units);
    }

    private void validateFormatConvert(double passedValue, double expectedValue, MeasurementUnits units) {
        block3: {
            try {
                String intermediate = MeasurementConverter.format((Double)passedValue, (MeasurementUnits)units, (boolean)false);
                MeasurementNumericValueAndUnits results = MeasurementParser.parse((String)intermediate, (MeasurementUnits)units);
                assert (Math.abs(results.getValue() - expectedValue) < 1.0E-9 && results.getUnits() == units) : "double input was '" + passedValue + "', " + "units input was '" + units.name() + "', " + "intermediate string was '" + intermediate + "', " + "Expected value '" + expectedValue + "', " + "with units of '" + units.name() + "', " + "displayed as '" + units + "', " + "Received value '" + results.getValue() + "', " + "with units of '" + results.getUnits().getName() + "', " + "displayed as '" + results.getUnits() + "'";
            }
            catch (MeasurementConversionException mce) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("Error during conversion: " + mce.getMessage()));
            }
        }
    }

    private void validateConvert(double value, String intermediate, MeasurementUnits units) {
        this.validateConvert(value, value, intermediate, units);
    }

    private void validateConvert(double passedValue, double expectedValue, String intermediate, MeasurementUnits units) {
        block3: {
            try {
                MeasurementNumericValueAndUnits results = MeasurementParser.parse((String)intermediate, (MeasurementUnits)units);
                assert (Math.abs(results.getValue() - expectedValue) < 1.0E-9 && results.getUnits() == units) : "double input was '" + passedValue + "', " + "units input was '" + units.name() + "', " + "intermediate string was '" + intermediate + "', " + "Expected value '" + expectedValue + "', " + "with units of '" + units.name() + "', " + "displayed as '" + units + "', " + "Received value '" + results.getValue() + "', " + "with units of '" + results.getUnits().getName() + "', " + "displayed as '" + results.getUnits() + "'";
            }
            catch (MeasurementConversionException mce) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("Error during conversion: " + mce.getMessage()));
            }
        }
    }

    private List<String> getWhitespaceVariationsAroundSingleTokens(String ... tokens) {
        ArrayList<String> variations = new ArrayList<String>();
        for (String token : tokens) {
            for (String white : this.WHITESPACE) {
                variations.add(token);
                variations.add(token + white + white);
            }
        }
        return variations;
    }
}

