/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import org.rhq.enterprise.server.alert.engine.model.AlertConditionOperator;
import org.rhq.enterprise.server.alert.engine.model.MeasurementRangeNumericCacheElement;
import org.testng.annotations.Test;

@Test
public class MeasurementRangeNumericCacheElementTest {
    private final Double lo = 20.0;
    private final Double hi = 50.0;
    private final Double inside = 30.0;
    private final Double outsideLo = 1.0;
    private final Double outsideHi = 111.0;

    public void testInsideExclusive() {
        MeasurementRangeNumericCacheElement ele = this.createCacheElement(AlertConditionOperator.LESS_THAN);
        assert (ele.matches(this.inside, new Object[0]));
        assert (!ele.matches(this.outsideLo, new Object[0]));
        assert (!ele.matches(this.outsideHi, new Object[0]));
        assert (!ele.matches(this.lo, new Object[0]));
        assert (!ele.matches(this.hi, new Object[0]));
    }

    public void testOutsideExclusive() {
        MeasurementRangeNumericCacheElement ele = this.createCacheElement(AlertConditionOperator.GREATER_THAN);
        assert (!ele.matches(this.inside, new Object[0]));
        assert (ele.matches(this.outsideLo, new Object[0]));
        assert (ele.matches(this.outsideHi, new Object[0]));
        assert (ele.matches(this.lo, new Object[0]));
        assert (ele.matches(this.hi, new Object[0]));
    }

    public void testInsideInclusive() {
        MeasurementRangeNumericCacheElement ele = this.createCacheElement(AlertConditionOperator.LESS_THAN_OR_EQUAL_TO);
        assert (ele.matches(this.inside, new Object[0]));
        assert (!ele.matches(this.outsideLo, new Object[0]));
        assert (!ele.matches(this.outsideHi, new Object[0]));
        assert (ele.matches(this.lo, new Object[0]));
        assert (ele.matches(this.hi, new Object[0]));
    }

    public void testOutsideInclusive() {
        MeasurementRangeNumericCacheElement ele = this.createCacheElement(AlertConditionOperator.GREATER_THAN_OR_EQUAL_TO);
        assert (!ele.matches(this.inside, new Object[0]));
        assert (ele.matches(this.outsideLo, new Object[0]));
        assert (ele.matches(this.outsideHi, new Object[0]));
        assert (!ele.matches(this.lo, new Object[0]));
        assert (!ele.matches(this.hi, new Object[0]));
    }

    public void testUnsupportedComparator() {
        try {
            this.createCacheElement(AlertConditionOperator.EQUALS);
            assert (false) : "should not be able to support EQUALS";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private MeasurementRangeNumericCacheElement createCacheElement(AlertConditionOperator op) {
        return new MeasurementRangeNumericCacheElement(op, this.lo, this.hi, 0);
    }
}

