/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.test;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.JPAUtils;
import org.rhq.test.TransactionCallbackWithContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class AlertConditionTest
extends UpdatePluginMetadataTestBase {
    private static final String RHQ_SERVER_NAME_PROPERTY = "rhq.server.high-availability.name";
    private static final String RHQ_SERVER_NAME_PROPERTY_VALUE = "AlertConditionTestServer";
    private Resource resource;
    private Server server;

    @Override
    protected String getSubsystemDirectory() {
        return "alerts";
    }

    @AfterMethod(alwaysRun=true)
    public void removePersistedResource() throws Exception {
        if (this.resource != null) {
            this.deleteNewResource(this.resource);
            this.resource = null;
        }
        this.deleteServerIdentity();
    }

    @BeforeClass(alwaysRun=true)
    public void setSysProp() {
        System.setProperty(RHQ_SERVER_NAME_PROPERTY, RHQ_SERVER_NAME_PROPERTY_VALUE);
    }

    @AfterClass(alwaysRun=true)
    public void unsetSysProp() {
        System.setProperty(RHQ_SERVER_NAME_PROPERTY, "");
    }

    public void testBZ735262_InsideRangeCondition() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        this.createAlertDefinitionWithOneInsideRangeCondition(metricDef, this.resource.getId());
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(60L), request, Double.valueOf(20.0)));
        report.addData(new MeasurementDataNumeric(this.getTimestamp(30L), request, Double.valueOf(70.0)));
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 0) : "no alerts should have fired: " + alerts;
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(15L), request, Double.valueOf(50.0)));
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
    }

    public void testBZ735262_OutsideRangeCondition() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        this.createAlertDefinitionWithOneOutsideRangeCondition(metricDef, this.resource.getId());
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(60L), request, Double.valueOf(50.0)));
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 0) : "no alerts should have fired: " + alerts;
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(15L), request, Double.valueOf(20.0)));
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
    }

    public void testBZ736685_DeleteConditionLogButNoAlert() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        AlertDefinition alertDef = this.createAlertDefinitionWithTwoConditionsALL(metricDef, this.resource.getId());
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(60L), request, Double.valueOf(20.0)));
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 0) : "no alerts should have fired: " + alerts;
        int condId = 0;
        for (AlertCondition cond : alertDef.getConditions()) {
            if (!cond.getComparator().equals("<")) continue;
            condId = cond.getId();
            break;
        }
        assert (condId > 0) : "failed to get the condition ID - something is wrong with test setup";
        AlertCondition conditionWithLogs = this.getAlertConditionWithLogs(condId);
        Set logs = conditionWithLogs.getConditionLogs();
        assert (logs != null && logs.size() > 0) : "missing condition log - we should have one that was generated";
        AlertConditionLog log = (AlertConditionLog)logs.iterator().next();
        assert (log.getAlert() == null) : "condition should not have fired an alert: " + logs;
        int resourceId = this.resource.getId();
        this.deleteNewResource(this.resource);
        this.resource = null;
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        PageList defs = alertDefManager.findAlertDefinitions(this.getOverlord(), resourceId, PageControl.getUnlimitedInstance());
        assert (defs.isEmpty()) : "failed to delete the alert definition - are condition logs still around?";
    }

    private PageList<Alert> getAlerts(int resourceId) {
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        AlertCriteria alertCriteria = new AlertCriteria();
        alertCriteria.addFilterResourceIds(new Integer[]{resourceId});
        PageList alerts = alertManager.findAlertsByCriteria(this.getOverlord(), alertCriteria);
        return alerts;
    }

    private AlertCondition getAlertConditionWithLogs(final int conditionId) {
        return (AlertCondition)JPAUtils.executeInTransaction((TransactionCallbackWithContext)new TransactionCallbackWithContext<AlertCondition>(){

            public AlertCondition execute(TransactionManager tm, EntityManager em) throws Exception {
                AlertCondition cond = (AlertCondition)em.find(AlertCondition.class, (Object)conditionId);
                cond.getConditionLogs().size();
                return cond;
            }
        });
    }

    private Resource loadResourceWithSchedules(int resourceId) {
        ResourceCriteria resourceCriteria = new ResourceCriteria();
        resourceCriteria.addFilterId(Integer.valueOf(resourceId));
        resourceCriteria.fetchSchedules(true);
        Resource resourceWithSchedules = this.getResource(resourceCriteria);
        assert (resourceWithSchedules != null) : "could not obtain resource from DB";
        assert (resourceWithSchedules.getSchedules() != null && resourceWithSchedules.getSchedules().size() == 1) : "missing schedule";
        return resourceWithSchedules;
    }

    private AlertDefinition createAlertDefinitionWithTwoConditionsALL(MeasurementDefinition metricDef, int resourceId) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(2);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.THRESHOLD);
        cond1.setName(metricDef.getDisplayName());
        cond1.setComparator(">");
        cond1.setThreshold(Double.valueOf(40.0));
        cond1.setOption(null);
        cond1.setMeasurementDefinition(metricDef);
        conditions.add(cond1);
        AlertCondition cond2 = new AlertCondition();
        cond2.setCategory(AlertConditionCategory.THRESHOLD);
        cond2.setName(metricDef.getDisplayName());
        cond2.setComparator("<");
        cond2.setThreshold(Double.valueOf(60.0));
        cond2.setOption(null);
        cond2.setMeasurementDefinition(metricDef);
        conditions.add(cond2);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("two condition ALL alert");
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        int defId = alertDefManager.createAlertDefinition(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId));
        alertDefinition = alertDefManager.getAlertDefinition(this.getOverlord(), defId);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private AlertDefinition createAlertDefinitionWithOneInsideRangeCondition(MeasurementDefinition metricDef, int resourceId) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(1);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.RANGE);
        cond1.setName(metricDef.getDisplayName());
        cond1.setThreshold(Double.valueOf(40.0));
        cond1.setOption(Double.valueOf(60.0).toString());
        cond1.setComparator("<");
        cond1.setMeasurementDefinition(metricDef);
        conditions.add(cond1);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("one inside-range condition alert");
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        int defId = alertDefManager.createAlertDefinition(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId));
        alertDefinition = alertDefManager.getAlertDefinition(this.getOverlord(), defId);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private AlertDefinition createAlertDefinitionWithOneOutsideRangeCondition(MeasurementDefinition metricDef, int resourceId) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(1);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.RANGE);
        cond1.setName(metricDef.getDisplayName());
        cond1.setThreshold(Double.valueOf(40.0));
        cond1.setOption(Double.valueOf(60.0).toString());
        cond1.setComparator(">");
        cond1.setMeasurementDefinition(metricDef);
        conditions.add(cond1);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("one outside-range condition alert");
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        int defId = alertDefManager.createAlertDefinition(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId));
        alertDefinition = alertDefManager.getAlertDefinition(this.getOverlord(), defId);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private MeasurementDefinition createResourceWithMetricSchedule() throws Exception {
        this.registerPlugin("type-with-metric.xml");
        ResourceType resourceType = this.getResourceType("TypeWithMetrics");
        assert (resourceType != null) : "failed to deploy resource type";
        assert (resourceType.getMetricDefinitions() != null) : "failed to create metric defs";
        assert (resourceType.getMetricDefinitions().size() == 1) : "do not have the expected number of metric defs";
        final MeasurementDefinition metricDef = (MeasurementDefinition)resourceType.getMetricDefinitions().iterator().next();
        this.resource = this.persistNewResource(resourceType.getName());
        assert (this.resource != null && this.resource.getId() > 0) : "failed to create test resource";
        JPAUtils.executeInTransaction((TransactionCallbackWithContext)new TransactionCallbackWithContext<Object>(){

            public Object execute(TransactionManager tm, EntityManager em) throws Exception {
                MeasurementSchedule schedule = new MeasurementSchedule(metricDef, AlertConditionTest.this.resource);
                em.persist((Object)schedule);
                return null;
            }
        });
        this.createServerIdentity();
        return metricDef;
    }

    private long getTimestamp(long secondsAgo) {
        return System.currentTimeMillis() - secondsAgo * 1000L;
    }

    private void reloadAllAlertConditionCaches() {
        LookupUtil.getAlertConditionCacheManager().reloadAllCaches();
    }

    private void createServerIdentity() {
        this.server = new Server();
        this.server.setName(RHQ_SERVER_NAME_PROPERTY_VALUE);
        this.server.setAddress("localhost");
        this.server.setPort(7080);
        this.server.setSecurePort(7443);
        this.server.setComputePower(1);
        this.server.setOperationMode(Server.OperationMode.MAINTENANCE);
        int serverId = LookupUtil.getServerManager().create(this.server);
        assert (serverId > 0) : "could not create our server identity in the DB";
        try {
            Agent agent = this.getAgent(AlertConditionTest.getEntityManager());
            agent.setServer(this.server);
            LookupUtil.getAgentManager().updateAgent(agent);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    private void deleteServerIdentity() throws Exception {
        if (this.server != null) {
            this.cleanupAgent();
            LookupUtil.getCloudManager().deleteServer(Integer.valueOf(this.server.getId()));
            this.server = null;
        }
    }
}

