/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.alert.AlertManagerBean;
import org.testng.annotations.Test;

@Test
public class AlertManagerBeanTest {
    private String pretty;

    public void testPrettyPrintAVAILABILITY() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.AVAILABILITY, null, null, null, AvailabilityType.UP.name(), null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Availability goes UP".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Avail goes UP".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.AVAILABILITY, null, null, null, AvailabilityType.DOWN.name(), null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Availability goes DOWN".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Avail goes DOWN".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintTHRESHOLD() {
        MeasurementDefinition md = this.createDynamicMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.THRESHOLD, md.getDisplayName(), ">", 12.5, null, md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop > 12.5B".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop > 12.5B".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintTHRESHOLD_Calltime() {
        MeasurementDefinition md = this.createCalltimeMeasurementDefinition();
        String regex = "some.*(reg)?ex$";
        AlertCondition condition = this.createCondition(AlertConditionCategory.THRESHOLD, regex, ">", 12.5, "MAX", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop MAX > 12.5B with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop MAX > 12.5B matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.THRESHOLD, null, ">", 12.5, "MAX", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop MAX > 12.5B".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop MAX > 12.5B".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintBASELINE() {
        MeasurementDefinition md = this.createDynamicMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.BASELINE, md.getDisplayName(), ">", 0.1, "mean", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop > 10.0% of Baseline Mean Value".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop > 10.0% bl mean".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.BASELINE, md.getDisplayName(), ">", 0.1, "min", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop > 10.0% of Baseline Minimum Value".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop > 10.0% bl min".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.BASELINE, md.getDisplayName(), ">", 0.1, "max", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop > 10.0% of Baseline Maximum Value".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop > 10.0% bl max".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintCHANGE() {
        MeasurementDefinition md = this.createDynamicMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.CHANGE, md.getDisplayName(), null, null, null, md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop Value Changed".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop Val Chg".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintCHANGE_Calltime() {
        MeasurementDefinition md = this.createCalltimeMeasurementDefinition();
        String regex = "some.*(reg)?ex$";
        AlertCondition condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "LO", 0.1, "MIN", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop MIN shrinks by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop MIN shrinks by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "CH", 0.1, "MIN", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop MIN changes by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop MIN changes by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "HI", 0.1, "MIN", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop MIN grows by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop MIN grows by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "LO", 0.1, "MAX", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop MAX shrinks by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop MAX shrinks by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "CH", 0.1, "MAX", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop MAX changes by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop MAX changes by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "HI", 0.1, "MAX", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop MAX grows by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop MAX grows by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "LO", 0.1, "AVG", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop AVG shrinks by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop AVG shrinks by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "CH", 0.1, "AVG", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop AVG changes by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop AVG changes by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, regex, "HI", 0.1, "AVG", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop AVG grows by at least 10.0% with calltime destination matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop AVG grows by 10.0% matching \"some.*(reg)?ex$\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, null, "LO", 0.1, "AVG", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop AVG shrinks by at least 10.0%".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop AVG shrinks by 10.0%".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, null, "CH", 0.1, "AVG", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop AVG changes by at least 10.0%".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop AVG changes by 10.0%".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CHANGE, null, "HI", 0.1, "AVG", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Calltime Metric CT Prop AVG grows by at least 10.0%".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("CT Prop AVG grows by 10.0%".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintTRAIT() {
        MeasurementDefinition md = this.createTraitMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.TRAIT, md.getDisplayName(), null, null, null, md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Blah Trait Value Changed".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Blah Trait Val Chg".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintCONTROL() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.CONTROL, "opNameHere", null, null, OperationRequestStatus.FAILURE.name(), null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Operation [opNameHere] has status=[FAILURE]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Op [opNameHere]=FAILURE".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.CONTROL, "opNameHere", null, null, OperationRequestStatus.SUCCESS.name(), null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Operation [opNameHere] has status=[SUCCESS]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Op [opNameHere]=SUCCESS".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintEVENT() {
        String regex = "some.*(reg)?ex$";
        AlertCondition condition = this.createCondition(AlertConditionCategory.EVENT, EventSeverity.WARN.name(), null, null, regex, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert (("Event With Severity [WARN] Matching Expression \"" + regex + "\"").equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert (("[WARN] Event Matching \"" + regex + "\"").equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.EVENT, EventSeverity.WARN.name(), null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Event With Severity [WARN]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("[WARN] Event".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintRESOURCECONFIG() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.RESOURCE_CONFIG, null, null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Resource Configuration Changed".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Res Config Chg".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintDRIFT() {
        AlertCondition condition = this.createCondition(AlertConditionCategory.DRIFT, "?riftName", null, null, "fil.*", null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Drift detected for files that match \"fil.*\" and for drift definition [?riftName]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Drift matching \"fil.*\", config=[?riftName]".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.DRIFT, null, null, null, "fil.*", null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Drift detected for files that match \"fil.*\"".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Drift matching \"fil.*\"".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.DRIFT, "?riftName", null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Drift detected for drift definition [?riftName]".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Drift! config=[?riftName]".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.DRIFT, null, null, null, null, null);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Drift Detected".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Drift!".equals(this.pretty)) : this.pretty;
    }

    public void testPrettyPrintRANGE() {
        MeasurementDefinition md = this.createDynamicMeasurementDefinition();
        AlertCondition condition = this.createCondition(AlertConditionCategory.RANGE, md.getDisplayName(), "<=", 1.0, "22.2", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop Value is Between 1.0B and 22.2B, Inclusive".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop Between 1.0B - 22.2B, incl".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.RANGE, md.getDisplayName(), ">=", 1.0, "22.2", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop Value is Outside 1.0B and 22.2B, Inclusive".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop Outside 1.0B - 22.2B, incl".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.RANGE, md.getDisplayName(), "<", 1.0, "22.2", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop Value is Between 1.0B and 22.2B, Exclusive".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop Between 1.0B - 22.2B, excl".equals(this.pretty)) : this.pretty;
        condition = this.createCondition(AlertConditionCategory.RANGE, md.getDisplayName(), ">", 1.0, "22.2", md);
        this.pretty = this.getPrettyAlertConditionString(condition);
        assert ("Foo Prop Value is Outside 1.0B and 22.2B, Exclusive".equals(this.pretty)) : this.pretty;
        this.pretty = this.getShortPrettyAlertConditionString(condition);
        assert ("Foo Prop Outside 1.0B - 22.2B, excl".equals(this.pretty)) : this.pretty;
    }

    private String getPrettyAlertConditionString(AlertCondition condition) {
        AlertManagerBean pojo = new AlertManagerBean();
        String s = this.extractCondition(pojo.prettyPrintAlertConditions(this.createAlert(condition), false));
        System.out.println("long===>" + s);
        return s;
    }

    private String getShortPrettyAlertConditionString(AlertCondition condition) {
        AlertManagerBean pojo = new AlertManagerBean();
        String s = this.extractCondition(pojo.prettyPrintAlertConditions(this.createAlert(condition), true));
        System.out.println("short-->" + s);
        return s;
    }

    private MeasurementDefinition createDynamicMeasurementDefinition() {
        ResourceType resourceType = new ResourceType("testType", "testPlugin", ResourceCategory.PLATFORM, null);
        MeasurementDefinition md = new MeasurementDefinition(resourceType, "fooMetric");
        md.setDataType(DataType.MEASUREMENT);
        md.setDisplayName("Foo Prop");
        md.setMeasurementType(NumericType.DYNAMIC);
        md.setRawNumericType(NumericType.DYNAMIC);
        md.setUnits(MeasurementUnits.BYTES);
        return md;
    }

    private MeasurementDefinition createCalltimeMeasurementDefinition() {
        ResourceType resourceType = new ResourceType("testType", "testPlugin", ResourceCategory.PLATFORM, null);
        MeasurementDefinition md = new MeasurementDefinition(resourceType, "ctMetric");
        md.setDataType(DataType.CALLTIME);
        md.setDisplayName("CT Prop");
        md.setMeasurementType(NumericType.DYNAMIC);
        md.setRawNumericType(NumericType.DYNAMIC);
        md.setUnits(MeasurementUnits.BYTES);
        md.setDestinationType("/wot gorilla");
        return md;
    }

    private MeasurementDefinition createTraitMeasurementDefinition() {
        ResourceType resourceType = new ResourceType("testType", "testPlugin", ResourceCategory.PLATFORM, null);
        MeasurementDefinition md = new MeasurementDefinition(resourceType, "traitMetric");
        md.setDataType(DataType.TRAIT);
        md.setDisplayName("Blah Trait");
        md.setUnits(MeasurementUnits.BYTES);
        return md;
    }

    private Alert createAlert(AlertCondition condition) {
        Alert alert = new Alert();
        AlertConditionLog conditionLog = new AlertConditionLog(condition, System.currentTimeMillis());
        alert.addConditionLog(conditionLog);
        return alert;
    }

    private AlertCondition createCondition(AlertConditionCategory category, String name, String comparator, Double threshold, String option, MeasurementDefinition measDef) {
        AlertCondition condition = new AlertCondition();
        condition.setCategory(category);
        condition.setName(name);
        condition.setComparator(comparator);
        condition.setThreshold(threshold);
        condition.setOption(option);
        condition.setMeasurementDefinition(measDef);
        return condition;
    }

    private String extractCondition(String prettyString) {
        Pattern pattern = Pattern.compile(" - Cond(?:ition)? 1: (.*)\n");
        Matcher matcher = pattern.matcher(prettyString);
        assert (matcher.find()) : "could not find the condition string";
        return matcher.group(1);
    }
}

