/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.test;

import java.sql.Connection;
import java.util.List;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.operation.DatabaseOperation;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.xml.sax.InputSource;

@Test(enabled=false)
public class DeleteAlertsTest
extends AbstractEJB3Test {
    private AlertManagerLocal alertManager;
    private Subject superuser;
    private Resource newResource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.alertManager = LookupUtil.getAlertManager();
        this.superuser = LookupUtil.getSubjectManager().getOverlord();
        Connection connection = null;
        try {
            connection = DeleteAlertsTest.getConnection();
            DatabaseConnection dbUnitConnection = new DatabaseConnection(connection);
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)dbUnitConnection, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        this.newResource = (Resource)DeleteAlertsTest.getEntityManager().find(Resource.class, (Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        if ("true".equals(System.getProperty("clean.db"))) {
            Connection connection = null;
            try {
                connection = DeleteAlertsTest.getConnection();
                DatabaseConnection dbUnitConnection = new DatabaseConnection(connection);
                DatabaseOperation.DELETE.execute((IDatabaseConnection)dbUnitConnection, this.getDataSet());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    IDataSet getDataSet() throws Exception {
        FlatXmlProducer xmlProducer = new FlatXmlProducer(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("AlertManagerBeanTest.xml")));
        xmlProducer.setColumnSensing(true);
        return new FlatXmlDataSet(xmlProducer);
    }

    public void deleteAlertsForResource() {
        assert (1 == this.alertManager.deleteAlertsByContext(this.superuser, EntityContext.forResource((int)this.newResource.getId())));
    }

    public void deleteAlertsForResourceTemplate() {
        int resourceTypeId = 1;
        int deletedCount = this.alertManager.deleteAlertsByContext(this.superuser, EntityContext.forTemplate((int)resourceTypeId));
        List alertConditionLogs = DeleteAlertsTest.getEntityManager().createQuery("from AlertConditionLog log where log.id = :id").setParameter("id", (Object)2).getResultList();
        List notificationLogs = DeleteAlertsTest.getEntityManager().createQuery("from AlertNotificationLog log where log.id = :id").setParameter("id", (Object)2).getResultList();
        DeleteAlertsTest.assertEquals((String)"Failed to delete alerts by template", (int)1, (int)deletedCount);
        DeleteAlertsTest.assertEquals((String)"Failed to delete alert condition logs when deleting alerts by template", (int)0, (int)alertConditionLogs.size());
        DeleteAlertsTest.assertEquals((String)"Failed to delete alert notification logs when deleting alerts by template", (int)0, (int)notificationLogs.size());
    }

    public void testAlertDeleteInRange() {
        assert (2 == this.alertManager.deleteAlerts(0L, System.currentTimeMillis() + 600000L));
    }
}

