/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.security.auth.login.LoginException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class SubjectManagerBeanTest
extends AbstractEJB3Test {
    private SubjectManagerLocal subjectManager;
    private AuthorizationManagerLocal authorizationManager;
    private RoleManagerLocal roleManager;

    @BeforeClass
    public void beforeClass() {
        this.subjectManager = LookupUtil.getSubjectManager();
        this.authorizationManager = LookupUtil.getAuthorizationManager();
        this.roleManager = LookupUtil.getRoleManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod
    public void purgeAllSessions() {
        ArrayList<String> usernames = new ArrayList<String>();
        usernames.add("admin");
        usernames.add("rhqadmin");
        usernames.add("new_user");
        SessionManager session_manager = SessionManager.getInstance();
        while (usernames.size() > 0) {
            try {
                String doomed_user = (String)usernames.get(0);
                session_manager.invalidate(doomed_user);
            }
            finally {
                usernames.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserConfiguration() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject superuser = this.subjectManager.getOverlord();
            Subject new_user = new Subject("dummy-user", true, false);
            new_user = this.subjectManager.createSubject(superuser, new_user);
            assert (new_user.getUserConfiguration() == null) : "There should not be any configuration yet";
            Configuration config = new Configuration();
            new_user.setUserConfiguration(config);
            assert (new_user.getUserConfiguration() != null) : "An empty configuration should have been set";
            assert (new_user.getUserConfiguration().getProperties().size() == 0) : "An empty config should have been set";
            assert (new_user.getUserConfiguration().getId() == 0) : "Configuration wasn't persisted - should not have an ID";
            new_user = this.subjectManager.updateSubject(superuser, new_user);
            config = new_user.getUserConfiguration();
            assert (config != null) : "An empty configuration should have been persisted";
            assert (config.getProperties().size() == 0) : "An empty config should have been persisted";
            assert (config.getId() != 0) : "Configuration was persisted - should have an ID";
            config.put((Property)new PropertySimple("firstname", (Object)"firstvalue"));
            config.put((Property)new PropertySimple("secondname", (Object)"secondvalue"));
            assert (new_user.getUserConfiguration() != null) : "A full configuration should have been set";
            assert (new_user.getUserConfiguration().getProperties().size() == 2) : "A full config should have been set";
            new_user = this.createSession(new_user);
            new_user = this.subjectManager.updateSubject(new_user, new_user);
            config = new_user.getUserConfiguration();
            assert (config != null) : "A full configuration should have been persisted";
            assert (config.getProperties().size() == 2) : "A full config should have been persisted";
            assert (config.getId() != 0) : "Configuration was persisted - should have an ID";
            assert (config.getSimple("firstname").getStringValue().equals("firstvalue")) : "Configuration wasn't persisted properly";
            assert (config.getSimple("secondname").getStringValue().equals("secondvalue")) : "Configuration wasn't persisted properly!";
            Subject loaded = this.subjectManager.loadUserConfiguration(Integer.valueOf(new_user.getId()));
            config = loaded.getUserConfiguration();
            assert (config != null) : "A full configuration should have been persisted";
            assert (config.getProperties().size() == 2) : "A full config should have been persisted";
            assert (config.getId() != 0) : "Configuration was persisted - should have an ID";
            assert (config.getSimple("firstname").getStringValue().equals("firstvalue")) : "Configuration wasn't persisted properly";
            assert (config.getSimple("secondname").getStringValue().equals("secondvalue")) : "Configuration wasn't persisted properly!";
            new_user.setUserConfiguration(null);
            assert (new_user.getUserConfiguration() == null) : "There should not be any configuration anymore";
            new_user = this.subjectManager.updateSubject(superuser, new_user);
            assert (new_user.getUserConfiguration() == null) : "An empty configuration should have been persisted";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTryToDisableSuperUsers() throws Exception {
        Subject rhqadmin;
        Subject superuser;
        this.getTransactionManager().begin();
        try {
            superuser = this.subjectManager.getOverlord();
            rhqadmin = this.subjectManager.getSubjectByName("rhqadmin");
            rhqadmin = this.createSession(rhqadmin);
            try {
                superuser.setFactive(false);
                this.subjectManager.updateSubject(rhqadmin, superuser);
                assert (false) : "You should not be able to disable the superuser";
            }
            catch (PermissionException se) {
                superuser.setFactive(true);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        try {
            try {
                rhqadmin.setFactive(false);
                this.subjectManager.updateSubject(superuser, rhqadmin);
                assert (false) : "You should not be able to delete the rhqadmin user";
            }
            catch (PermissionException se) {
                rhqadmin.setFactive(true);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTryToDeleteSuperUsers() throws Exception {
        Subject rhqadmin;
        Subject superuser;
        this.getTransactionManager().begin();
        try {
            superuser = this.subjectManager.getOverlord();
            superuser = this.createSession(superuser);
            rhqadmin = this.subjectManager.getSubjectByName("rhqadmin");
            rhqadmin = this.createSession(rhqadmin);
            try {
                this.subjectManager.deleteUsers(superuser, new int[]{rhqadmin.getId()});
                assert (false) : "You should not be able to delete the rhqadmin user";
            }
            catch (PermissionException se) {
                // empty catch block
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        try {
            try {
                this.subjectManager.deleteUsers(rhqadmin, new int[]{superuser.getId()});
                assert (false) : "You should not be able to delete the superuser";
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        try {
            this.subjectManager.changePassword(rhqadmin, rhqadmin.getName(), "change-me");
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubjects() throws Exception {
        Subject subject;
        SubjectManagerLocal subjectManager;
        Subject rhqadmin;
        Subject superuser;
        Subject new_user;
        block36: {
            new_user = null;
            this.getTransactionManager().begin();
            ArrayList<Permission> all_global_perms = new ArrayList<Permission>();
            all_global_perms.add(Permission.MANAGE_SECURITY);
            all_global_perms.add(Permission.MANAGE_INVENTORY);
            all_global_perms.add(Permission.MANAGE_SETTINGS);
            superuser = this.subjectManager.getSubjectById(1);
            assert (superuser.getId() == 1);
            assert (superuser.getName().equals("admin"));
            assert (this.authorizationManager.getExplicitGlobalPermissions(superuser).containsAll(all_global_perms));
            rhqadmin = this.subjectManager.getSubjectByName("rhqadmin");
            assert (rhqadmin.getId() == 2);
            assert (rhqadmin.getName().equals("rhqadmin"));
            assert (this.authorizationManager.getExplicitGlobalPermissions(rhqadmin).containsAll(all_global_perms));
            rhqadmin = this.createSession(rhqadmin);
            Collection all_users_with_principals = this.subjectManager.findAllUsersWithPrincipals();
            assert (!all_users_with_principals.contains(superuser.getName()));
            assert (all_users_with_principals.contains(rhqadmin.getName()));
            assert (!this.subjectManager.isUserWithPrincipal(superuser.getName()));
            assert (this.subjectManager.isUserWithPrincipal(rhqadmin.getName()));
            subjectManager = LookupUtil.getSubjectManager();
            subject = null;
            try {
                subject = subjectManager.loginUnauthenticated("rhqadmin");
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block36;
                throw new AssertionError((Object)"There must be at least rhqadmin user");
            }
        }
        SubjectCriteria c = new SubjectCriteria();
        c.addFilterFsystem(Boolean.valueOf(false));
        c.addSortName(PageOrdering.ASC);
        PageList all_subjects = subjectManager.findSubjectsByCriteria(subject, c);
        assert (all_subjects.size() >= 1) : "There must be at least rhqadmin user";
        assert (!all_subjects.contains((Object)superuser)) : "The superuser should not have been returned in the list";
        assert (all_subjects.contains((Object)rhqadmin)) : "Missing user [" + rhqadmin + "] from: " + all_subjects;
        new_user = new Subject();
        new_user.setFsystem(false);
        new_user.setFactive(true);
        new_user.setName("dummy-user");
        new_user.setFirstName("my-firstname");
        new_user.setLastName("my-lastname");
        new_user.setEmailAddress("email@address.com");
        new_user.setPhoneNumber("1-800-555-1212");
        new_user.setSmsAddress("sms address");
        new_user.setDepartment("my-department");
        new_user = subjectManager.createSubject(rhqadmin, new_user);
        new_user = this.createSession(new_user);
        assert (!subjectManager.isUserWithPrincipal(new_user.getName()));
        subjectManager.createPrincipal(subjectManager.getOverlord(), new_user.getName(), "my-password");
        assert (subjectManager.isUserWithPrincipal(new_user.getName()));
        assert (new_user.getId() != 0);
        Subject login_new_user = subjectManager.loginUnauthenticated(new_user.getName());
        assert (login_new_user.equals((Object)new_user));
        new_user = login_new_user;
        subjectManager.changePassword(new_user, new_user.getName(), "my-new-password");
        subjectManager.changePassword(rhqadmin, new_user.getName(), "my-new-password");
        this.getTransactionManager().commit();
        this.getTransactionManager().begin();
        try {
            subjectManager.changePassword(new_user, rhqadmin.getName(), "not-allowed");
            assert (false) : "The new user does not have permission to change another's password";
        }
        catch (PermissionException se) {
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        assert (this.authorizationManager.getExplicitGlobalPermissions(new_user).size() == 0);
        try {
            subjectManager.deleteUsers(new_user, new int[]{new_user.getId()});
            assert (false) : "The new user should not have had the permission to delete itself";
        }
        catch (PermissionException e) {
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        assert (subjectManager.getSubjectByName(new_user.getName()).equals((Object)new_user));
        assert (subjectManager.isUserWithPrincipal(new_user.getName()));
        subjectManager.deleteUsers(rhqadmin, new int[]{new_user.getId()});
        assert (subjectManager.getSubjectByName(new_user.getName()) == null);
        assert (!subjectManager.isUserWithPrincipal(new_user.getName()));
        this.getTransactionManager().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSuperUser() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject superuser1 = this.subjectManager.getOverlord();
            assert (superuser1.getId() == 1);
            Subject superuser2 = this.subjectManager.getOverlord();
            assert (superuser2.getId() == 1);
            assert (superuser1.equals((Object)superuser2));
            assert (superuser1.getSessionId().equals(superuser2.getSessionId()));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoginUnauthenticated() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject subject1 = this.subjectManager.loginUnauthenticated("rhqadmin");
            int session1 = subject1.getSessionId();
            Thread.sleep(500L);
            Subject subject2 = this.subjectManager.loginUnauthenticated("rhqadmin");
            int session2 = subject2.getSessionId();
            assert (session1 != session2) : "The same sessionId should never be assigned when logging in twice";
            assert (subject1.equals((Object)subject2));
            Subject s = this.subjectManager.getSubjectByNameAndSessionId("rhqadmin", subject1.getSessionId().intValue());
            assert (s.getSessionId() == session1);
            s = this.subjectManager.getSubjectByNameAndSessionId("rhqadmin", subject2.getSessionId().intValue());
            assert (s.getSessionId() == session2);
            this.subjectManager.logout(session1);
            try {
                s = this.subjectManager.getSubjectByNameAndSessionId("rhqadmin", subject1.getSessionId().intValue());
                assert (false) : "Session should be invalid";
            }
            catch (SessionNotFoundException ok) {
                // empty catch block
            }
            s = this.subjectManager.getSubjectByNameAndSessionId("rhqadmin", subject2.getSessionId().intValue());
            assert (s.getSessionId() == session2);
            this.subjectManager.logout(session1);
            this.subjectManager.logout(session2);
            try {
                s = this.subjectManager.getSubjectByNameAndSessionId("rhqadmin", subject2.getSessionId().intValue());
                SubjectManagerBeanTest.fail((String)"Session should be invalid");
            }
            catch (SessionNotFoundException e) {
                // empty catch block
            }
            try {
                this.subjectManager.loginUnauthenticated("rhqadminX");
                assert (false) : "Should not have logged in - provided a bad username";
            }
            catch (LoginException ok) {
                // empty catch block
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteUser() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject overlord = this.subjectManager.getOverlord();
            Subject new_user = new Subject("dummy-user", true, false);
            new_user = this.subjectManager.createSubject(overlord, new_user);
            Role new_role = new Role("dummy-role");
            RoleManagerLocal roleManager = LookupUtil.getRoleManager();
            new_role = roleManager.createRole(overlord, new_role);
            int[] subjectIds = new int[]{new_user.getId()};
            roleManager.addSubjectsToRole(overlord, new_role.getId(), subjectIds);
            assert (new_role.getSubjects().contains(new_user)) : "New_role does not contain new_user";
            int count = new_role.getSubjects().size();
            this.subjectManager.deleteUsers(overlord, subjectIds);
            assert (new_role.getSubjects().size() == count - 1) : "User was not deleted from new_role";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewUsersPermission_subjectWithViewUsersRoleCanViewOtherUsers() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject overlord = this.subjectManager.getOverlord();
            Subject rhqadmin = this.subjectManager.getSubjectByName("rhqadmin");
            Role roleWithViewUsersPerm = new Role("role" + UUID.randomUUID());
            roleWithViewUsersPerm.addPermission(Permission.VIEW_USERS);
            roleWithViewUsersPerm = this.roleManager.createRole(overlord, roleWithViewUsersPerm);
            Subject subjectWithViewUsersRole = new Subject("subject" + UUID.randomUUID(), true, false);
            subjectWithViewUsersRole.addRole(roleWithViewUsersPerm);
            subjectWithViewUsersRole = this.subjectManager.createSubject(overlord, subjectWithViewUsersRole, "password");
            subjectWithViewUsersRole = this.subjectManager.loginUnauthenticated(subjectWithViewUsersRole.getName());
            Subject anotherSubject = new Subject("subject" + UUID.randomUUID(), true, false);
            anotherSubject = this.subjectManager.createSubject(overlord, anotherSubject, "password");
            PageList subjects = this.subjectManager.findSubjectsByCriteria(subjectWithViewUsersRole, new SubjectCriteria());
            HashSet subjectSet = new HashSet(subjects);
            SubjectManagerBeanTest.assertTrue((boolean)subjectSet.contains(subjectWithViewUsersRole));
            SubjectManagerBeanTest.assertTrue((boolean)subjectSet.contains(anotherSubject));
            SubjectManagerBeanTest.assertTrue((boolean)subjectSet.contains(rhqadmin));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewUsersPermission_rhqadminCanViewOtherUsers() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject overlord = this.subjectManager.getOverlord();
            Subject rhqadmin = this.subjectManager.getSubjectByName("rhqadmin");
            rhqadmin = this.subjectManager.loginUnauthenticated(rhqadmin.getName());
            Subject anotherSubject = new Subject("subject" + UUID.randomUUID(), true, false);
            anotherSubject = this.subjectManager.createSubject(overlord, anotherSubject, "password");
            PageList subjects = this.subjectManager.findSubjectsByCriteria(rhqadmin, new SubjectCriteria());
            HashSet subjectSet = new HashSet(subjects);
            SubjectManagerBeanTest.assertTrue((boolean)subjectSet.contains(anotherSubject));
            SubjectManagerBeanTest.assertTrue((boolean)subjectSet.contains(rhqadmin));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewUsersPermission_subjectWithNonViewUsersRoleCannotViewOtherUsers() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject overlord = this.subjectManager.getOverlord();
            Role roleWithoutViewUsersPerm = new Role("role" + UUID.randomUUID());
            roleWithoutViewUsersPerm = this.roleManager.createRole(overlord, roleWithoutViewUsersPerm);
            Subject subjectWithNonViewUsersRole = new Subject("subject" + UUID.randomUUID(), true, false);
            subjectWithNonViewUsersRole.addRole(roleWithoutViewUsersPerm);
            subjectWithNonViewUsersRole = this.subjectManager.createSubject(overlord, subjectWithNonViewUsersRole, "password");
            subjectWithNonViewUsersRole = this.subjectManager.loginUnauthenticated(subjectWithNonViewUsersRole.getName());
            Subject anotherSubject = new Subject("subject" + UUID.randomUUID(), true, false);
            anotherSubject = this.subjectManager.createSubject(overlord, anotherSubject, "password");
            PageList subjects = this.subjectManager.findSubjectsByCriteria(subjectWithNonViewUsersRole, new SubjectCriteria());
            HashSet subjectSet = new HashSet(subjects);
            SubjectManagerBeanTest.assertEquals((int)1, (int)subjectSet.size());
            SubjectManagerBeanTest.assertTrue((boolean)subjectSet.contains(subjectWithNonViewUsersRole));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewUsersPermission_subjectWithNoRolesCannotViewOtherUsers() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject overlord = this.subjectManager.getOverlord();
            Subject subjectWithNoRoles = new Subject("subject" + UUID.randomUUID(), true, false);
            subjectWithNoRoles = this.subjectManager.createSubject(overlord, subjectWithNoRoles, "password");
            subjectWithNoRoles = this.subjectManager.loginUnauthenticated(subjectWithNoRoles.getName());
            Subject anotherSubject = new Subject("subject" + UUID.randomUUID(), true, false);
            anotherSubject = this.subjectManager.createSubject(overlord, anotherSubject, "password");
            PageList subjects = this.subjectManager.findSubjectsByCriteria(subjectWithNoRoles, new SubjectCriteria());
            HashSet subjectSet = new HashSet(subjects);
            SubjectManagerBeanTest.assertEquals((int)1, (int)subjectSet.size());
            SubjectManagerBeanTest.assertTrue((boolean)subjectSet.contains(subjectWithNoRoles));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }
}

