/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.authz.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class AuthorizationManagerBeanTest
extends AbstractEJB3Test {
    private AuthorizationManagerLocal authorizationManager;

    @BeforeMethod
    private void init() {
        try {
            this.authorizationManager = LookupUtil.getAuthorizationManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testGlobalPermissions() throws Exception {
        Role testRole2;
        Role testRole1;
        Subject testSubject;
        this.getTransactionManager().begin();
        EntityManager em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            Set<Permission> globalPermissions = SessionTestHelper.getAllGlobalPerms();
            testRole1.getPermissions().addAll(globalPermissions);
            em.merge((Object)testRole1);
            em.flush();
            Set globalResults = this.authorizationManager.getExplicitGlobalPermissions(testSubject);
            assert (SessionTestHelper.samePermissions(globalPermissions, globalResults)) : "Failed to get 1-subject, 1-role global permissions";
            for (Permission permission : globalPermissions) {
                assert (this.authorizationManager.hasGlobalPermission(testSubject, permission)) : "Failed to get global permission " + permission.toString();
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testRole2 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            Set<Permission> globalPermissions = SessionTestHelper.getAllGlobalPerms();
            testRole1.getPermissions().addAll(globalPermissions);
            testRole2.getPermissions().addAll(globalPermissions);
            em.merge((Object)testRole1);
            em.merge((Object)testRole2);
            em.flush();
            Set globalResults = this.authorizationManager.getExplicitGlobalPermissions(testSubject);
            assert (SessionTestHelper.samePermissions(globalPermissions, globalResults)) : "Failed to get 1-subject, 2-role distinct global permissions";
            for (Permission permission : globalPermissions) {
                assert (this.authorizationManager.hasGlobalPermission(testSubject, permission)) : "Failed to get global permission " + permission.toString();
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testRole2 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            testRole1.getPermissions().add(Permission.CONTROL);
            testRole2.getPermissions().add(Permission.CONFIGURE_WRITE);
            em.merge((Object)testRole1);
            em.merge((Object)testRole2);
            em.flush();
            EnumSet<Permission> noPermissions = EnumSet.noneOf(Permission.class);
            Set noResults = this.authorizationManager.getExplicitGlobalPermissions(testSubject);
            assert (SessionTestHelper.samePermissions(noPermissions, noResults)) : "Failed by getting resource permissions as global permissions";
            Set<Permission> globalPermissions = SessionTestHelper.getAllGlobalPerms();
            for (Permission permission : globalPermissions) {
                assert (!this.authorizationManager.hasGlobalPermission(testSubject, permission)) : "Failed by  a resource permission as a global permission " + permission.toString();
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testGroupPermissions() throws Exception {
        EnumSet<Permission> totalMixedPermissions;
        EnumSet<Permission> otherMixedPermissions;
        EnumSet<Permission> someMixedPermissions;
        ResourceGroup testGroup1;
        Role testRole2;
        ResourceGroup testGroup12;
        Role testRole1;
        Subject testSubject;
        this.getTransactionManager().begin();
        EntityManager em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testGroup12 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            EnumSet<Permission> someMixedPermissions2 = EnumSet.of(Permission.CONFIGURE_WRITE, Permission.CONTROL, Permission.MANAGE_SECURITY);
            testRole1.getPermissions().addAll(someMixedPermissions2);
            em.merge((Object)testRole1);
            em.flush();
            Set someMixedResults = this.authorizationManager.getExplicitGroupPermissions(testSubject, testGroup12.getId());
            assert (SessionTestHelper.samePermissions(someMixedPermissions2, someMixedResults)) : "Failed to get all 1-role, 1-group permissions";
            for (Permission permission : someMixedPermissions2) {
                assert (this.authorizationManager.hasGroupPermission(testSubject, permission, testGroup12.getId())) : "Failed to get single single 1-role, 1-group permission " + permission.toString();
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testGroup12 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            Role testRole22 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            ResourceGroup testGroup2 = SessionTestHelper.createNewMixedGroupForRole(em, testRole22, "testGroup2", false);
            EnumSet<Permission> someMixedPermissions3 = EnumSet.of(Permission.MANAGE_INVENTORY, Permission.MANAGE_CONTENT, Permission.DELETE_RESOURCE);
            testRole1.getPermissions().addAll(someMixedPermissions3);
            em.merge((Object)testRole1);
            em.flush();
            EnumSet<Permission> otherMixedPermissions2 = EnumSet.of(Permission.CONFIGURE_WRITE, Permission.MANAGE_INVENTORY, Permission.MANAGE_SECURITY);
            testRole22.getPermissions().addAll(otherMixedPermissions2);
            em.merge((Object)testRole22);
            em.flush();
            Set someMixedResults = this.authorizationManager.getExplicitGroupPermissions(testSubject, testGroup12.getId());
            assert (SessionTestHelper.samePermissions(someMixedPermissions3, someMixedResults)) : "Failed to get all 2-role, 2-group permissions";
            for (Permission permission : someMixedPermissions3) {
                assert (this.authorizationManager.hasGroupPermission(testSubject, permission, testGroup12.getId())) : "Failed to get single single 1-role, 1-group permission " + permission.toString();
            }
            Set otherMixedResults = this.authorizationManager.getExplicitGroupPermissions(testSubject, testGroup2.getId());
            assert (SessionTestHelper.samePermissions(otherMixedPermissions2, otherMixedResults)) : "Failed to get all 2-role, 2-group permissions";
            for (Permission permission : otherMixedPermissions2) {
                assert (this.authorizationManager.hasGroupPermission(testSubject, permission, testGroup2.getId())) : "Failed to get single single 1-role, 1-group permission " + permission.toString();
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testRole2 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            testGroup1 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            testRole2.getResourceGroups().add(testGroup1);
            testGroup1.addRole(testRole2);
            em.merge((Object)testRole2);
            em.merge((Object)testGroup1);
            em.flush();
            someMixedPermissions = EnumSet.of(Permission.CONFIGURE_WRITE, Permission.CONTROL, Permission.MANAGE_SECURITY);
            testRole1.getPermissions().addAll(someMixedPermissions);
            em.merge((Object)testRole1);
            em.flush();
            otherMixedPermissions = EnumSet.of(Permission.MANAGE_INVENTORY, Permission.MANAGE_CONTENT, Permission.DELETE_RESOURCE);
            testRole2.getPermissions().addAll(otherMixedPermissions);
            em.merge((Object)testRole2);
            em.flush();
            totalMixedPermissions = EnumSet.noneOf(Permission.class);
            totalMixedPermissions.addAll(someMixedPermissions);
            totalMixedPermissions.addAll(otherMixedPermissions);
            Set totalMixedResults = this.authorizationManager.getExplicitGroupPermissions(testSubject, testGroup1.getId());
            assert (SessionTestHelper.samePermissions(totalMixedPermissions, totalMixedResults)) : "Failed to get all 1-role, 2-group permissions";
            for (Permission permission : totalMixedPermissions) {
                assert (this.authorizationManager.hasGroupPermission(testSubject, permission, testGroup1.getId())) : "Failed to get single single 1-role, 2-group permission " + permission.toString();
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testRole2 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            testGroup1 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            testRole2.getResourceGroups().add(testGroup1);
            testGroup1.addRole(testRole2);
            em.merge((Object)testRole2);
            em.merge((Object)testGroup1);
            em.flush();
            someMixedPermissions = EnumSet.of(Permission.CONFIGURE_WRITE, Permission.CONTROL, Permission.MANAGE_SECURITY);
            testRole1.getPermissions().addAll(someMixedPermissions);
            em.merge((Object)testRole1);
            em.flush();
            otherMixedPermissions = EnumSet.of(Permission.MANAGE_INVENTORY, Permission.MANAGE_CONTENT, Permission.DELETE_RESOURCE);
            testRole2.getPermissions().addAll(otherMixedPermissions);
            em.merge((Object)testRole2);
            em.flush();
            testRole2.getPermissions().addAll(someMixedPermissions);
            em.merge((Object)testRole2);
            em.flush();
            totalMixedPermissions = EnumSet.noneOf(Permission.class);
            totalMixedPermissions.addAll(someMixedPermissions);
            totalMixedPermissions.addAll(otherMixedPermissions);
            Set totalMixedDistinctResults = this.authorizationManager.getExplicitGroupPermissions(testSubject, testGroup1.getId());
            assert (SessionTestHelper.samePermissions(totalMixedPermissions, totalMixedDistinctResults)) : "Failed to get all 1-role, 2-group distinct permissions";
            for (Permission permission : totalMixedPermissions) {
                assert (this.authorizationManager.hasGroupPermission(testSubject, permission, testGroup1.getId())) : "Failed to get single single 1-role, 2-group distinct permission " + permission.toString();
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCanViewResourcesWhenSubjectIsInRole() throws Exception {
        this.getTransactionManager().begin();
        EntityManager entityMgr = AuthorizationManagerBeanTest.getEntityManager();
        try {
            Subject subject = SessionTestHelper.createNewSubject(entityMgr, "testSubject");
            Role roleWithSubject = SessionTestHelper.createNewRoleForSubject(entityMgr, subject, "role with subject");
            roleWithSubject.addPermission(Permission.VIEW_RESOURCE);
            ResourceGroup group = SessionTestHelper.createNewCompatibleGroupForRole(entityMgr, roleWithSubject, "accessible group");
            Resource r1 = SessionTestHelper.createNewResourceForGroup(entityMgr, group, "r1");
            Resource r2 = SessionTestHelper.createNewResourceForGroup(entityMgr, group, "r2");
            entityMgr.flush();
            List<Integer> resourceIds = Arrays.asList(r1.getId(), r2.getId());
            AuthorizationManagerBeanTest.assertTrue((String)"The subject should have permission to view the resources", (boolean)this.authorizationManager.canViewResources(subject, resourceIds));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCanViewResourceWhenSubjectIsInMultipleRolesAndResourcesInMultipleGroups() throws Exception {
        this.getTransactionManager().begin();
        EntityManager entityMgr = AuthorizationManagerBeanTest.getEntityManager();
        try {
            Subject subject = SessionTestHelper.createNewSubject(entityMgr, "testSubject");
            Role role1 = SessionTestHelper.createNewRoleForSubject(entityMgr, subject, "role1");
            role1.addPermission(Permission.VIEW_RESOURCE);
            Role role2 = SessionTestHelper.createNewRoleForSubject(entityMgr, subject, "role2");
            role2.addPermission(Permission.VIEW_RESOURCE);
            ResourceGroup group1 = SessionTestHelper.createNewCompatibleGroupForRole(entityMgr, role1, "group 1");
            ResourceGroup group2 = SessionTestHelper.createNewCompatibleGroupForRole(entityMgr, role2, "group 2");
            Resource r1 = SessionTestHelper.createNewResourceForGroup(entityMgr, group1, "r1");
            Resource r2 = SessionTestHelper.createNewResourceForGroup(entityMgr, group2, "r2");
            entityMgr.flush();
            List<Integer> resourceIds = Arrays.asList(r1.getId(), r2.getId());
            AuthorizationManagerBeanTest.assertTrue((String)"The subject should have permission to view the resources in different groups since the subject is in roles for those groups", (boolean)this.authorizationManager.canViewResources(subject, resourceIds));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCanViewResourcesWhenSubjectIsNotInRole() throws Exception {
        this.getTransactionManager().begin();
        EntityManager entityMgr = AuthorizationManagerBeanTest.getEntityManager();
        try {
            Subject subject = SessionTestHelper.createNewSubject(entityMgr, "testSubject");
            Subject subjectNotInRole = SessionTestHelper.createNewSubject(entityMgr, "subjectNotInRole");
            Role roleWithSubject = SessionTestHelper.createNewRoleForSubject(entityMgr, subject, "role with subject");
            roleWithSubject.addPermission(Permission.VIEW_RESOURCE);
            ResourceGroup group = SessionTestHelper.createNewCompatibleGroupForRole(entityMgr, roleWithSubject, "accessible group");
            Resource r1 = SessionTestHelper.createNewResourceForGroup(entityMgr, group, "r1");
            Resource r2 = SessionTestHelper.createNewResourceForGroup(entityMgr, group, "r2");
            entityMgr.flush();
            List<Integer> resourceIds = Arrays.asList(r1.getId(), r2.getId());
            AuthorizationManagerBeanTest.assertFalse((String)"The subject should not have permission to view the resources", (boolean)this.authorizationManager.canViewResources(subjectNotInRole, resourceIds));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testResourcePermissions() throws Exception {
        Collection<Integer> allResources;
        Set allPermissionsResults;
        EnumSet<Permission> allPermissions;
        EnumSet<Permission> otherPermissions;
        ResourceGroup testGroup2;
        Collection<Integer> allResources2;
        EnumSet<Permission> otherPermissions2;
        EnumSet<Permission> somePermissions;
        Role testRole2;
        Resource resource3;
        Resource resource2;
        Resource resource1;
        ResourceGroup testGroup1;
        Role testRole1;
        Subject testSubject;
        this.getTransactionManager().begin();
        EntityManager em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testGroup1 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            resource1 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource1");
            resource2 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource2");
            resource3 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource3");
            EnumSet<Permission> allPermissions2 = EnumSet.allOf(Permission.class);
            testRole1.getPermissions().addAll(allPermissions2);
            em.merge((Object)testRole1);
            em.flush();
            Set allPermissionsResults2 = this.authorizationManager.getExplicitResourcePermissions(testSubject, resource1.getId());
            assert (SessionTestHelper.samePermissions(allPermissions2, allPermissionsResults2)) : "Failed to get all 1-role, 1-group, 1-resource permissions";
            for (Permission permission : allPermissions2) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, resource1.getId())) : "Failed to get single 1-role, 1-group, 1-resource permission";
            }
            Collection<Integer> allResources3 = SessionTestHelper.getResourceList(resource1, resource2, resource3);
            for (Permission permission : allPermissions2) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, allResources3)) : "Failed to get every positive 1-role, 1-group, resource-list permission";
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testGroup1 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            resource1 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource1");
            resource2 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource2");
            resource3 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource3");
            testRole2 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            testRole2.getResourceGroups().add(testGroup1);
            testGroup1.addRole(testRole2);
            em.merge((Object)testRole2);
            em.merge((Object)testGroup1);
            em.flush();
            somePermissions = EnumSet.of(Permission.CONFIGURE_WRITE);
            otherPermissions2 = EnumSet.of(Permission.CONTROL);
            testRole1.getPermissions().addAll(somePermissions);
            testRole2.getPermissions().addAll(otherPermissions2);
            em.merge((Object)testRole1);
            em.merge((Object)testRole2);
            em.flush();
            EnumSet<Permission> allPermissions3 = EnumSet.noneOf(Permission.class);
            allPermissions3.addAll(somePermissions);
            allPermissions3.addAll(otherPermissions2);
            Set allPermissionsResults3 = this.authorizationManager.getExplicitResourcePermissions(testSubject, resource1.getId());
            assert (SessionTestHelper.samePermissions(allPermissions3, allPermissionsResults3)) : "Failed to get all 2-role, 1-group, 1-resource permissions";
            for (Permission permission : allPermissions3) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, resource1.getId())) : "Failed to get single 2-role, 1-group, 1-resource permission";
            }
            allResources2 = SessionTestHelper.getResourceList(resource1, resource2, resource3);
            for (Permission permission : allPermissions3) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, allResources2)) : "Failed to get every positive 2-role, 1-group, resource-list permission";
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testGroup1 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            resource1 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource1");
            resource2 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource2");
            resource3 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource3");
            testRole2 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            testGroup2 = SessionTestHelper.createNewMixedGroupForRole(em, testRole2, "testGroup2", false);
            testGroup2.addExplicitResource(resource1);
            resource1.getExplicitGroups().add(testGroup2);
            testGroup2.addImplicitResource(resource1);
            resource1.getImplicitGroups().add(testGroup2);
            em.merge((Object)testGroup2);
            em.merge((Object)resource1);
            em.flush();
            EnumSet<Permission> sharedPermissions = EnumSet.of(Permission.MANAGE_CONTENT);
            otherPermissions = EnumSet.of(Permission.MANAGE_SECURITY);
            testRole1.getPermissions().addAll(sharedPermissions);
            testRole2.getPermissions().addAll(otherPermissions);
            em.merge((Object)testRole1);
            em.merge((Object)testRole2);
            em.flush();
            allPermissions = EnumSet.noneOf(Permission.class);
            allPermissions.addAll(sharedPermissions);
            allPermissions.addAll(otherPermissions);
            allPermissionsResults = this.authorizationManager.getExplicitResourcePermissions(testSubject, resource1.getId());
            assert (SessionTestHelper.samePermissions(allPermissions, allPermissionsResults)) : "Failed to get all 2-role, 2-group, 1-resource permissions";
            for (Permission permission : allPermissions) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, resource1.getId())) : "Failed to get single 2-role, 2-group, 1-resource permission";
            }
            allResources = SessionTestHelper.getResourceList(resource1, resource2, resource3);
            for (Permission permission : sharedPermissions) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, allResources)) : "Failed to get every positive 2-role, 2-group, resource-list permission";
            }
            for (Permission permission : otherPermissions) {
                assert (!this.authorizationManager.hasResourcePermission(testSubject, permission, allResources)) : "Failed to get every negative 2-role, 2-group, resource-list permission";
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testGroup1 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            resource1 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource1");
            resource2 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource2");
            resource3 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource3");
            ResourceGroup testGroup22 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup2", false);
            testGroup22.addExplicitResource(resource1);
            resource1.getExplicitGroups().add(testGroup22);
            testGroup22.addImplicitResource(resource1);
            resource1.getImplicitGroups().add(testGroup22);
            em.merge((Object)testGroup22);
            em.merge((Object)resource1);
            em.flush();
            EnumSet<Permission> sharedPermissions = EnumSet.of(Permission.MANAGE_SETTINGS, Permission.MANAGE_ALERTS);
            testRole1.getPermissions().addAll(sharedPermissions);
            em.merge((Object)testRole1);
            em.flush();
            Set somePermissionsResults = this.authorizationManager.getExplicitResourcePermissions(testSubject, resource1.getId());
            assert (SessionTestHelper.samePermissions(sharedPermissions, somePermissionsResults)) : "Failed to get all 1-role, 2-group, 1-resource permissions";
            for (Permission permission : sharedPermissions) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, resource1.getId())) : "Failed to get single 1-role, 2-group, 1-resource permission";
            }
            Collection<Integer> allResources4 = SessionTestHelper.getResourceList(resource1, resource2, resource3);
            for (Permission permission : sharedPermissions) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, allResources4)) : "Failed to get every positive 1-role, 2-group, resource-list permission";
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            testGroup1 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            resource1 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource1");
            resource2 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource2");
            resource3 = SessionTestHelper.createNewResourceForGroup(em, testGroup1, "testResource3");
            testRole2 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            testGroup2 = SessionTestHelper.createNewMixedGroupForRole(em, testRole2, "testGroup2", false);
            testGroup2.addRole(testRole1);
            testRole1.getResourceGroups().add(testGroup2);
            testGroup1.addRole(testRole2);
            testRole2.getResourceGroups().add(testGroup1);
            testGroup2.addExplicitResource(resource1);
            resource1.getExplicitGroups().add(testGroup2);
            testGroup2.addImplicitResource(resource1);
            resource1.getImplicitGroups().add(testGroup2);
            em.merge((Object)testGroup1);
            em.merge((Object)testGroup2);
            em.merge((Object)testRole1);
            em.merge((Object)testRole2);
            em.merge((Object)resource1);
            em.flush();
            EnumSet<Permission> somePermissions2 = EnumSet.of(Permission.CONFIGURE_WRITE, Permission.CONTROL, Permission.MANAGE_INVENTORY);
            otherPermissions = EnumSet.of(Permission.CONTROL, Permission.MANAGE_SECURITY, Permission.MANAGE_INVENTORY);
            testRole1.getPermissions().addAll(somePermissions2);
            testRole2.getPermissions().addAll(otherPermissions);
            em.merge((Object)testRole1);
            em.merge((Object)testRole2);
            em.flush();
            allPermissions = EnumSet.noneOf(Permission.class);
            allPermissions.addAll(somePermissions2);
            allPermissions.addAll(otherPermissions);
            allPermissionsResults = this.authorizationManager.getExplicitResourcePermissions(testSubject, resource1.getId());
            assert (SessionTestHelper.samePermissions(allPermissions, allPermissionsResults)) : "Failed to get all 2-role crossed 2-group, 1-resource distinct permissions";
            for (Permission permission : allPermissions) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, resource1.getId())) : "Failed to get single 2-role crossed 2-group, 1-resource distinct permission";
            }
            allResources = SessionTestHelper.getResourceList(resource1, resource2, resource3);
            for (Permission permission : allPermissions) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, allResources)) : "Failed to get every positive 2-role crossed 2-group, resource-list permission";
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().begin();
        em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            testRole1 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole1");
            Role testRole22 = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole2");
            ResourceGroup testGroup12 = SessionTestHelper.createNewMixedGroupForRole(em, testRole1, "testGroup1", false);
            ResourceGroup testGroup23 = SessionTestHelper.createNewMixedGroupForRole(em, testRole22, "testGroup2", false);
            Resource resource12 = SessionTestHelper.createNewResourceForGroup(em, testGroup12, "testResource1");
            Resource resource22 = SessionTestHelper.createNewResourceForGroup(em, testGroup23, "testResource2");
            somePermissions = EnumSet.of(Permission.MANAGE_ALERTS, Permission.MANAGE_SETTINGS);
            otherPermissions2 = EnumSet.of(Permission.MANAGE_ALERTS, Permission.MANAGE_CONTENT);
            testRole1.getPermissions().addAll(somePermissions);
            testRole22.getPermissions().addAll(otherPermissions2);
            em.merge((Object)testRole1);
            em.merge((Object)testRole22);
            em.flush();
            EnumSet<Permission> intersection = EnumSet.copyOf(somePermissions);
            intersection.retainAll(otherPermissions2);
            EnumSet<Permission> symmetricDifference = EnumSet.copyOf(somePermissions);
            symmetricDifference.addAll(otherPermissions2);
            symmetricDifference.removeAll(intersection);
            allResources2 = SessionTestHelper.getResourceList(resource12, resource22);
            for (Permission permission : intersection) {
                assert (this.authorizationManager.hasResourcePermission(testSubject, permission, allResources2)) : "Failed to get every positive 2-role independent 2-group, resource-list permission";
            }
            for (Permission permission : symmetricDifference) {
                assert (!this.authorizationManager.hasResourcePermission(testSubject, permission, allResources2)) : "Failed to get every negative 2-role independent 2-group, resource-list permission";
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testSetPermission() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = AuthorizationManagerBeanTest.getEntityManager();
        try {
            Subject testSubject = SessionTestHelper.createNewSubject(em, "testSubject");
            Role testRole = SessionTestHelper.createNewRoleForSubject(em, testSubject, "testRole");
            RoleManagerLocal roleManager = LookupUtil.getRoleManager();
            Subject superuser = LookupUtil.getSubjectManager().getOverlord();
            Set<Permission> globalPermissions = SessionTestHelper.getAllGlobalPerms();
            roleManager.setPermissions(superuser, Integer.valueOf(testRole.getId()), globalPermissions);
            em.refresh((Object)testRole);
            assert (SessionTestHelper.samePermissions(testRole.getPermissions(), globalPermissions)) : "Failed to set global permissions";
            Set<Permission> resourcePermissions = SessionTestHelper.getAllResourcePerms();
            roleManager.setPermissions(superuser, Integer.valueOf(testRole.getId()), resourcePermissions);
            em.refresh((Object)testRole);
            assert (SessionTestHelper.samePermissions(testRole.getPermissions(), resourcePermissions)) : "Failed to set resource permissions";
            EnumSet<Permission> noPermissions = EnumSet.noneOf(Permission.class);
            roleManager.setPermissions(superuser, Integer.valueOf(testRole.getId()), noPermissions);
            em.refresh((Object)testRole);
            assert (SessionTestHelper.samePermissions(testRole.getPermissions(), noPermissions)) : "Failed to set empty list of permissions";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }
}

