/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.authz.test;

import java.util.ArrayList;
import java.util.Collection;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.group.LdapGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class RoleManagerBeanTest
extends AbstractEJB3Test {
    private SubjectManagerLocal subjectManager;
    private RoleManagerLocal roleManager;
    private LdapGroupManagerLocal ldapManager;

    @BeforeClass
    public void beforeClass() {
        this.roleManager = LookupUtil.getRoleManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.ldapManager = LookupUtil.getLdapGroupManager();
    }

    public void testGetAllRoles() {
        assert (this.roleManager.findRoles(PageControl.getUnlimitedInstance()).size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSubjectRoles() throws Exception {
        this.getTransactionManager().begin();
        try {
            PageList roles = this.roleManager.findRolesBySubject(this.subjectManager.getOverlord().getId(), PageControl.getUnlimitedInstance());
            assert (roles.size() == 1);
            Role role = (Role)roles.get(0);
            assert (role.getName().equals("Super User Role")) : "Superuser should have only the super user role: " + role;
            assert (role.getPermissions().contains(Permission.MANAGE_SECURITY));
            assert (role.getPermissions().contains(Permission.MANAGE_INVENTORY));
            assert (role.getPermissions().contains(Permission.MANAGE_SETTINGS));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRoleSubjects() throws Exception {
        this.getTransactionManager().begin();
        try {
            PageList roles = this.roleManager.findRolesBySubject(this.subjectManager.getOverlord().getId(), PageControl.getUnlimitedInstance());
            for (Role role : roles) {
                PageList subjects = this.roleManager.findSubjectsByRole(Integer.valueOf(role.getId()), PageControl.getUnlimitedInstance());
                if (!role.getName().equals("Super User Role")) continue;
                assert (subjects.size() >= 1) : "At least rhqadmin must have super user role: " + subjects;
                for (Subject s : subjects) {
                    if (s.getId() == 1 || s.getName().equals("admin")) assert (false) : "getRoleSubjects() is not supposed to return the superuser" + s;
                }
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRolesByIds() throws Exception {
        this.getTransactionManager().begin();
        try {
            PageList all_roles = this.roleManager.findRoles(PageControl.getUnlimitedInstance());
            ArrayList<Integer> role_id_list = new ArrayList<Integer>(all_roles.size());
            for (Role role : all_roles) {
                role_id_list.add(role.getId());
            }
            PageList roles = this.roleManager.findRolesByIds(role_id_list.toArray(new Integer[0]), PageControl.getUnlimitedInstance());
            assert (roles.size() == all_roles.size());
            assert (roles.containsAll((Collection)all_roles));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAvailableRolesForSubject() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject superuser = this.subjectManager.getOverlord();
            superuser = this.createSession(superuser);
            Subject subject = new Subject();
            subject.setName("dummy-subject");
            subject = this.subjectManager.createSubject(superuser, subject);
            subject = this.createSession(subject);
            Role new_role = new Role("dummy-role");
            Role new_role2 = new Role("dummy-role2");
            new_role = this.roleManager.createRole(superuser, new_role);
            new_role2 = this.roleManager.createRole(superuser, new_role2);
            PageList all_roles = this.roleManager.findRoles(PageControl.getUnlimitedInstance());
            assert (all_roles.size() >= 3) : "There should at least be the two dummy roles and the super user role";
            PageList roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[0], PageControl.getUnlimitedInstance());
            assert (roles.size() == all_roles.size()) : "All roles should be available for this subject";
            assert (roles.containsAll((Collection)all_roles));
            roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[]{new_role.getId()}, PageControl.getUnlimitedInstance());
            assert (roles.size() + 1 == all_roles.size()) : "All roles but one should be available for this subject";
            assert (!roles.contains((Object)new_role));
            roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[]{new_role.getId(), new_role2.getId()}, PageControl.getUnlimitedInstance());
            assert (roles.size() + 2 == all_roles.size()) : "All roles but two should be available for this subject";
            assert (!roles.contains((Object)new_role));
            assert (!roles.contains((Object)new_role2));
            this.roleManager.addRolesToSubject(superuser, subject.getId(), new int[]{new_role.getId()});
            roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[0], PageControl.getUnlimitedInstance());
            assert (roles.size() + 1 == all_roles.size()) : "All but one role should be available for this subject";
            assert (!roles.contains((Object)new_role)) : "We already assigned this new role to the subject - it isn't available";
            roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[]{new_role2.getId()}, PageControl.getUnlimitedInstance());
            assert (roles.size() + 2 == all_roles.size()) : "One is already assigned and one is excluded so all but two roles should be available for this subject";
            assert (!roles.contains((Object)new_role)) : "We already assigned this new role to the subject - it isn't available";
            assert (!roles.contains((Object)new_role2)) : "We excluded this new role - it isn't available";
            try {
                roles = this.roleManager.findAvailableRolesForSubject(subject, Integer.valueOf(subject.getId()), new Integer[0], PageControl.getUnlimitedInstance());
            }
            catch (PermissionException s) {
                // empty catch block
            }
        }
        finally {
            try {
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRoles() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject newSubject1 = new Subject();
            newSubject1.setName("role-manager-subject");
            newSubject1.setFsystem(false);
            Subject newSubject2 = new Subject();
            newSubject2.setName("secondary-role-manager");
            newSubject2.setFsystem(false);
            Role role = new Role("role-manager-role");
            role.setFsystem(Boolean.valueOf(false));
            role.addSubject(newSubject1);
            Subject superuser = this.subjectManager.getOverlord();
            this.subjectManager.createSubject(superuser, newSubject1);
            newSubject1 = this.createSession(newSubject1);
            this.subjectManager.createSubject(superuser, newSubject2);
            newSubject2 = this.createSession(newSubject2);
            RoleManagerBeanTest.assertEquals((String)"Role should not be created or assigned yet", (int)0, (int)this.roleManager.findRolesBySubject(newSubject1.getId(), PageControl.getUnlimitedInstance()).size());
            role = this.roleManager.createRole(superuser, role);
            RoleManagerBeanTest.assertEquals((String)"Role should be assigned at the time the role is created", (int)1, (int)this.roleManager.findRolesBySubject(newSubject1.getId(), PageControl.getUnlimitedInstance()).size());
            this.roleManager.addRolesToSubject(superuser, newSubject2.getId(), new int[]{role.getId()});
            RoleManagerBeanTest.assertEquals((String)"Role should be assigned", (int)1, (int)this.roleManager.findRolesBySubject(newSubject2.getId(), PageControl.getUnlimitedInstance()).size());
            this.roleManager.removeRolesFromSubject(superuser, newSubject1.getId(), new int[]{role.getId()});
            RoleManagerBeanTest.assertEquals((String)"Role should have been unassigned", (int)0, (int)this.roleManager.findRolesBySubject(newSubject1.getId(), PageControl.getUnlimitedInstance()).size());
            this.roleManager.deleteRoles(superuser, new int[]{role.getId()});
            RoleManagerBeanTest.assertFalse((String)"Roles should have been deleted", (boolean)this.roleManager.findRoles(PageControl.getUnlimitedInstance()).contains((Object)role));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLdapGroups() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject superuser = this.subjectManager.getOverlord();
            superuser = this.createSession(superuser);
            Role role = new Role("role-manager-role");
            role.setFsystem(Boolean.valueOf(false));
            role = this.roleManager.createRole(superuser, role);
            LdapGroup group = new LdapGroup();
            group.setName("Foo");
            role.addLdapGroup(group);
            assert (this.ldapManager.findLdapGroupsByRole(role.getId(), PageControl.getUnlimitedInstance()).size() == 1) : "Ldap Group Foo Should be assigned";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }
}

