/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.hibernate.LazyInitializationException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.BundleCriteria;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleFileCriteria;
import org.rhq.core.domain.criteria.BundleResourceDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleVersionCriteria;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.enterprise.server.bundle.BundleDistributionInfo;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.bundle.TestBundleServerPluginService;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestAgentClient;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class BundleManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean TESTS_ENABLED = true;
    private static final String TEST_PREFIX = "bundletest";
    private static final String TEST_BUNDLE_DESTBASEDIR_PROP = "bundletest.destBaseDirProp";
    private static final String TEST_BUNDLE_DESTBASEDIR_PROP_VALUE = "bundletest/destBaseDir";
    private static final String TEST_DESTBASEDIR_NAME = "bundletest.destBaseDirName";
    private BundleManagerLocal bundleManager;
    private ResourceManagerLocal resourceManager;
    private static final boolean ENABLED = true;
    private static final boolean DISABLED = false;
    private TestBundleServerPluginService ps;
    private MasterServerPluginContainer pc;
    private Subject overlord;
    TestServerCommunicationsService agentServiceContainer;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.agentServiceContainer = this.prepareForTestAgents();
        this.agentServiceContainer.bundleService = new TestAgentClient(null, this.agentServiceContainer);
        this.ps = new TestBundleServerPluginService();
        this.prepareCustomServerPluginService(this.ps);
        this.bundleManager = LookupUtil.getBundleManager();
        this.resourceManager = LookupUtil.getResourceManager();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.ps.startMasterPluginContainer();
        this.cleanupDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        this.unprepareForTestAgents();
        try {
            this.ps = null;
            this.cleanupDatabase();
        }
        finally {
            this.unprepareServerPluginService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDatabase() {
        EntityManager em = null;
        try {
            this.getTransactionManager().begin();
            em = BundleManagerBeanTest.getEntityManager();
            Query q = em.createQuery("SELECT bv FROM BundleVersion bv WHERE bv.name LIKE 'bundletest%'");
            List doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(BundleVersion.class, (Object)((BundleVersion)removeMe).getId()));
            }
            em.flush();
            q = em.createQuery("SELECT bf FROM BundleFile bf WHERE bf.packageVersion.generalPackage.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(BundleFile.class, (Object)((BundleFile)removeMe).getId()));
            }
            q = em.createQuery("SELECT brdh FROM BundleResourceDeploymentHistory brdh WHERE brdh.resourceDeployment.bundleDeployment.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(BundleResourceDeploymentHistory.class, (Object)((BundleResourceDeploymentHistory)removeMe).getId()));
            }
            q = em.createQuery("SELECT brd FROM BundleResourceDeployment brd WHERE brd.bundleDeployment.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(BundleResourceDeployment.class, (Object)((BundleResourceDeployment)removeMe).getId()));
            }
            q = em.createQuery("SELECT bd FROM BundleDeployment bd WHERE bd.description LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(BundleDeployment.class, (Object)((BundleDeployment)removeMe).getId()));
            }
            q = em.createQuery("SELECT b FROM Bundle b WHERE b.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(Bundle.class, (Object)((Bundle)removeMe).getId()));
            }
            em.flush();
            q = em.createQuery("SELECT pv FROM PackageVersion pv WHERE pv.generalPackage.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(PackageVersion.class, (Object)((PackageVersion)removeMe).getId()));
            }
            q = em.createQuery("SELECT p FROM Package p WHERE p.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(Package.class, (Object)((Package)removeMe).getId()));
            }
            q = em.createQuery("SELECT pt FROM PackageType pt WHERE pt.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(PackageType.class, (Object)((PackageType)removeMe).getId()));
            }
            q = em.createQuery("SELECT bd FROM BundleDestination bd WHERE bd.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(BundleDestination.class, (Object)((BundleDestination)removeMe).getId()));
            }
            q = em.createQuery("SELECT r FROM Repo r WHERE r.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(Repo.class, (Object)((Repo)removeMe).getId()));
            }
            q = em.createQuery("SELECT rg FROM ResourceGroup rg WHERE rg.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(ResourceGroup.class, (Object)((ResourceGroup)removeMe).getId()));
            }
            q = em.createQuery("SELECT rt FROM ResourceType rt WHERE rt.deleted = false and rt.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(ResourceType.class, (Object)((ResourceType)removeMe).getId()));
            }
            em.flush();
            q = em.createQuery("SELECT bt FROM BundleType bt WHERE bt.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(BundleType.class, (Object)((BundleType)removeMe).getId()));
            }
            q = em.createQuery("SELECT a FROM Agent a WHERE a.name LIKE 'bundletest%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(Agent.class, (Object)((Agent)removeMe).getId()));
            }
            this.getTransactionManager().commit();
            em.close();
            em = null;
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT CLEAN UP TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (null != em) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testCreateBundleVersionFromDistributionFile() throws Exception {
        File tmpDir = FileUtil.createTempDirectory((String)"createBundleFromDistro", (String)".dir", null);
        try {
            BundleVersion[] bvs;
            String bundleFile1 = "bundletest_subdir1/bundle-file-1.txt";
            String bundleFile2 = "bundletest_subdir2/bundle-file-2.txt";
            String bundleFile3 = "bundletest_bundle-file-3.txt";
            this.writeFile(new File(tmpDir, bundleFile1), "first bundle file found inside bundle distro");
            this.writeFile(new File(tmpDir, bundleFile2), "second bundle file found inside bundle distro");
            this.writeFile(new File(tmpDir, bundleFile3), "third bundle file found inside bundle distro");
            String bundleName = "bundletest-create-from-distro";
            String bundleVersion = "1.2.3";
            String bundleDescription = "test bundle desc";
            DeploymentProperties bundleMetadata = new DeploymentProperties(0, bundleName, bundleVersion, bundleDescription);
            ConfigurationDefinition configDef = new ConfigurationDefinition("foo", null);
            int propDefaultValue1 = 998877;
            String propDefaultValue4 = "this.is.the.default";
            String propName1 = "prop1requiredWithDefault";
            String propName2 = "prop2";
            String propName3 = "prop3requiredWithNoDefault";
            String propName4 = "prop4notRequiredWithDefault";
            String propDesc1 = "prop1desc";
            String propDesc2 = "prop2desc";
            String propDesc3 = "prop3desc";
            String propDesc4 = "prop4desc";
            PropertyDefinitionSimple propdef1requiredWithDefault = new PropertyDefinitionSimple(propName1, propDesc1, true, PropertySimpleType.INTEGER);
            PropertyDefinitionSimple propdef2 = new PropertyDefinitionSimple(propName2, propDesc2, false, PropertySimpleType.STRING);
            PropertyDefinitionSimple propdef3requiredWithNoDefault = new PropertyDefinitionSimple(propName3, propDesc3, true, PropertySimpleType.STRING);
            PropertyDefinitionSimple propdef4notRequiredWithDefault = new PropertyDefinitionSimple(propName4, propDesc4, false, PropertySimpleType.STRING);
            propdef1requiredWithDefault.setDefaultValue(String.valueOf(propDefaultValue1));
            propdef4notRequiredWithDefault.setDefaultValue(propDefaultValue4);
            configDef.put((PropertyDefinition)propdef1requiredWithDefault);
            configDef.put((PropertyDefinition)propdef2);
            configDef.put((PropertyDefinition)propdef3requiredWithNoDefault);
            configDef.put((PropertyDefinition)propdef4notRequiredWithDefault);
            HashMap<String, File> bundleFiles = new HashMap<String, File>(3);
            bundleFiles.put(bundleFile1, new File(tmpDir, bundleFile1));
            bundleFiles.put(bundleFile2, new File(tmpDir, bundleFile2));
            bundleFiles.put(bundleFile3, new File(tmpDir, bundleFile3));
            File bundleDistroFile = tmpDir;
            String recipe = "mock recipe";
            BundleType bt1 = this.createBundleType("one");
            this.ps.parseRecipe_returnValue = new RecipeParseResults(bundleMetadata, configDef, new HashSet(bundleFiles.keySet()));
            this.ps.processBundleDistributionFile_returnValue = new BundleDistributionInfo(recipe, this.ps.parseRecipe_returnValue, bundleFiles);
            this.ps.processBundleDistributionFile_returnValue.setBundleTypeName(bt1.getName());
            BundleVersion bv1 = this.bundleManager.createBundleVersionViaURL(this.overlord, bundleDistroFile.toURI().toURL().toString());
            BundleVersionCriteria criteria = new BundleVersionCriteria();
            criteria.addFilterId(Integer.valueOf(bv1.getId()));
            criteria.fetchBundle(true);
            criteria.fetchConfigurationDefinition(true);
            criteria.fetchBundleFiles(true);
            criteria.fetchTags(true);
            BundleVersion bv2 = (BundleVersion)this.bundleManager.findBundleVersionsByCriteria(this.overlord, criteria).get(0);
            List bv2BundleFiles = bv2.getBundleFiles();
            BundleFileCriteria bfCriteria = new BundleFileCriteria();
            bfCriteria.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
            bfCriteria.fetchPackageVersion(true);
            PageList bfs = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfCriteria);
            bv2BundleFiles.clear();
            bv2BundleFiles.addAll(bfs);
            bv2.setBundleDeployments(new ArrayList());
            for (BundleVersion bv : bvs = new BundleVersion[]{bv1, bv2}) {
                assert (bv.getId() > 0) : bv;
                assert (bv.getBundle().getName().equals(bundleName)) : bv;
                assert (bv.getBundle().getDescription().equals(bundleDescription)) : bv;
                assert (bv.getDescription().equals(bundleDescription)) : "the bundle version desc should be the same as the bundle desc";
                assert (bv.getVersion().equals(bundleVersion)) : bv;
                assert (bv.getBundleFiles().size() == 3) : bv;
                ArrayList<String> bundleFileNames = new ArrayList<String>(3);
                for (BundleFile bf : bv.getBundleFiles()) {
                    bundleFileNames.add(bf.getPackageVersion().getFileName());
                }
                assert (bundleFileNames.contains(bundleFile1)) : bv;
                assert (bundleFileNames.contains(bundleFile2)) : bv;
                assert (bundleFileNames.contains(bundleFile3)) : bv;
                assert (bv.getBundleDeployments().isEmpty()) : bv;
                assert (bv.getConfigurationDefinition().getPropertyDefinitions().size() == 4);
                assert (bv.getConfigurationDefinition().get(propName1) != null);
                assert (bv.getConfigurationDefinition().get(propName1).getDescription().equals(propDesc1));
                assert (bv.getConfigurationDefinition().get(propName1).isRequired());
                assert (bv.getConfigurationDefinition().getPropertyDefinitionSimple(propName1).getType() == PropertySimpleType.INTEGER);
                assert (bv.getConfigurationDefinition().get(propName2) != null);
                assert (bv.getConfigurationDefinition().get(propName2).getDescription().equals(propDesc2));
                assert (!bv.getConfigurationDefinition().get(propName2).isRequired());
                assert (bv.getConfigurationDefinition().getPropertyDefinitionSimple(propName2).getType() == PropertySimpleType.STRING);
                assert (bv.getConfigurationDefinition().get(propName3) != null);
                assert (bv.getConfigurationDefinition().get(propName3).getDescription().equals(propDesc3));
                assert (bv.getConfigurationDefinition().get(propName3).isRequired());
                assert (bv.getConfigurationDefinition().getPropertyDefinitionSimple(propName3).getType() == PropertySimpleType.STRING);
                assert (bv.getConfigurationDefinition().get(propName4) != null);
                assert (bv.getConfigurationDefinition().get(propName4).getDescription().equals(propDesc4));
                assert (!bv.getConfigurationDefinition().get(propName4).isRequired());
                assert (bv.getConfigurationDefinition().getPropertyDefinitionSimple(propName4).getType() == PropertySimpleType.STRING);
                assert (bv.getRecipe().equals(recipe));
                ConfigurationTemplate defaultTemplate = bv.getConfigurationDefinition().getDefaultTemplate();
                Configuration defaultConfig = defaultTemplate.getConfiguration();
                assert (defaultConfig.getProperties().size() == 3);
                PropertySimple prop1 = defaultConfig.getSimple(propName1);
                PropertySimple prop2 = defaultConfig.getSimple(propName2);
                PropertySimple prop3 = defaultConfig.getSimple(propName3);
                PropertySimple prop4 = defaultConfig.getSimple(propName4);
                assert (prop1 != null);
                assert (prop2 == null) : "prop2 was not required and has no default, it should not be in the default template config";
                assert (prop3 != null);
                assert (prop4 != null);
                assert (prop1.getIntegerValue() != null);
                assert (prop1.getIntegerValue() == propDefaultValue1);
                assert (prop3.getStringValue() == null) : "prop3 was required but had no default, its template value should have been null";
                assert (prop4.getStringValue().equals(propDefaultValue4));
            }
        }
        finally {
            FileUtil.purge((File)tmpDir, (boolean)true);
        }
    }

    @Test(enabled=true)
    public void testGetBundleTypes() throws Exception {
        BundleType bt1 = this.createBundleType("one");
        BundleType bt2 = this.createBundleType("two");
        List bts = this.bundleManager.getAllBundleTypes(this.overlord);
        assert (bts.size() >= 2) : "should have at least 2 bundle types";
        ArrayList<String> btNames = new ArrayList<String>();
        for (BundleType bundleType : bts) {
            btNames.add(bundleType.getName());
        }
        assert (btNames.contains(bt1.getName()));
        assert (btNames.contains(bt2.getName()));
    }

    @Test(enabled=true)
    public void testCreateBundle() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
    }

    @Test(enabled=true)
    public void testCreateBundleVersion() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        BundleManagerBeanTest.assertEquals((String)"1.0", (String)bv1.getVersion());
        assert (0 == bv1.getVersionOrder());
        BundleVersion bv2 = this.createBundleVersion(b1.getName() + "-2", null, b1);
        BundleManagerBeanTest.assertNotNull((Object)bv2);
        BundleManagerBeanTest.assertEquals((String)"1.1", (String)bv2.getVersion());
        assert (1 == bv2.getVersionOrder());
    }

    @Test(enabled=true)
    public void testDeleteBundle() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        BundleManagerBeanTest.assertEquals((String)"1.0", (String)bv1.getVersion());
        BundleVersion bv2 = this.createBundleVersion(b1.getName() + "-2", null, b1);
        BundleManagerBeanTest.assertNotNull((Object)bv2);
        BundleManagerBeanTest.assertEquals((String)"1.1", (String)bv2.getVersion());
        this.bundleManager.addBundleFileViaByteArray(this.overlord, bv2.getId(), "testDeleteBundle", "1.0", new Architecture("noarch"), "content".getBytes());
        BundleFileCriteria bfCriteria = new BundleFileCriteria();
        bfCriteria.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
        bfCriteria.fetchPackageVersion(true);
        PageList files = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfCriteria);
        assert (files.size() == 1) : files;
        assert (((BundleFile)files.get(0)).getPackageVersion().getGeneralPackage().getName().equals("testDeleteBundle")) : files;
        this.bundleManager.deleteBundle(this.overlord, b1.getId());
        BundleCriteria bCriteria = new BundleCriteria();
        bCriteria.addFilterId(Integer.valueOf(b1.getId()));
        PageList bResults = this.bundleManager.findBundlesByCriteria(this.overlord, bCriteria);
        assert (bResults.size() == 0);
    }

    @Test(enabled=true)
    public void testDeleteBundleVersion() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        BundleManagerBeanTest.assertEquals((String)"1.0", (String)bv1.getVersion());
        BundleVersion bv2 = this.createBundleVersion(b1.getName() + "-2", null, b1);
        BundleManagerBeanTest.assertNotNull((Object)bv2);
        BundleManagerBeanTest.assertEquals((String)"1.1", (String)bv2.getVersion());
        this.bundleManager.addBundleFileViaByteArray(this.overlord, bv2.getId(), "testDeleteBundleVersion", "1.0", new Architecture("noarch"), "content".getBytes());
        BundleFileCriteria bfCriteria = new BundleFileCriteria();
        bfCriteria.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
        bfCriteria.fetchPackageVersion(true);
        PageList files = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfCriteria);
        assert (files.size() == 1) : files;
        assert (((BundleFile)files.get(0)).getPackageVersion().getGeneralPackage().getName().equals("testDeleteBundleVersion")) : files;
        BundleVersionCriteria bvCriteria = new BundleVersionCriteria();
        BundleCriteria bCriteria = new BundleCriteria();
        this.bundleManager.deleteBundleVersion(this.overlord, bv2.getId(), true);
        bvCriteria.addFilterId(Integer.valueOf(bv2.getId()));
        PageList bvResults = this.bundleManager.findBundleVersionsByCriteria(this.overlord, bvCriteria);
        assert (bvResults.size() == 0);
        bCriteria.addFilterId(Integer.valueOf(b1.getId()));
        PageList bResults = this.bundleManager.findBundlesByCriteria(this.overlord, bCriteria);
        assert (bResults.size() == 1) : "Should not have deleted bundle yet, 1 version still exists";
        this.bundleManager.deleteBundleVersion(this.overlord, bv1.getId(), true);
        bvCriteria.addFilterId(Integer.valueOf(bv1.getId()));
        bvResults = this.bundleManager.findBundleVersionsByCriteria(this.overlord, bvCriteria);
        assert (bvResults.size() == 0);
        bCriteria.addFilterId(Integer.valueOf(b1.getId()));
        bResults = this.bundleManager.findBundlesByCriteria(this.overlord, bCriteria);
        assert (bResults.size() == 0) : "Should have deleted bundle since no versions exists anymore";
    }

    @Test(enabled=true)
    public void testCreateBundleVersionOrdering() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleCriteria criteria = new BundleCriteria();
        criteria.addSortName(PageOrdering.ASC);
        PageList results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion() == null);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 0L);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", "1.0", b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        BundleManagerBeanTest.assertEquals((String)"1.0", (String)bv1.getVersion());
        assert (0 == bv1.getVersionOrder());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("1.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 1L);
        BundleVersion bv2 = this.createBundleVersion(b1.getName() + "-2", "2.0", b1);
        BundleManagerBeanTest.assertNotNull((Object)bv2);
        BundleManagerBeanTest.assertEquals((String)"2.0", (String)bv2.getVersion());
        assert (1 == bv2.getVersionOrder());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 2L);
        BundleVersion bv3 = this.createBundleVersion(b1.getName() + "-3", "1.5", b1);
        BundleManagerBeanTest.assertNotNull((Object)bv3);
        BundleManagerBeanTest.assertEquals((String)"1.5", (String)bv3.getVersion());
        assert (1 == bv3.getVersionOrder());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 3L);
        BundleVersionCriteria c = new BundleVersionCriteria();
        PageList bvs = null;
        c.addFilterId(Integer.valueOf(bv1.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)1, (int)bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 0);
        c.addFilterId(Integer.valueOf(bv2.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)1, (int)bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 2);
        c.addFilterId(Integer.valueOf(bv3.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)1, (int)bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 1);
        BundleVersion bv4 = this.createBundleVersion(b1.getName() + "-4", "0.5", b1);
        BundleManagerBeanTest.assertNotNull((Object)bv4);
        BundleManagerBeanTest.assertEquals((String)"0.5", (String)bv4.getVersion());
        c.addFilterId(Integer.valueOf(bv4.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)1, (int)bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 0);
        c.addFilterId(Integer.valueOf(bv1.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)1, (int)bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 1);
        c.addFilterId(Integer.valueOf(bv3.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)1, (int)bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 2);
        c.addFilterId(Integer.valueOf(bv2.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)1, (int)bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 3);
        Bundle b2 = this.createBundle("two");
        BundleManagerBeanTest.assertNotNull((Object)b2);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 4L);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion() == null);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 0L);
        BundleVersion b2_bv1 = this.createBundleVersion(b2.getName() + "-5", "9.1", b2);
        BundleManagerBeanTest.assertNotNull((Object)b2_bv1);
        BundleManagerBeanTest.assertEquals((String)"9.1", (String)b2_bv1.getVersion());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 4L);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion().equals("9.1"));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 1L);
        criteria.addSortName(PageOrdering.DESC);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 4L);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("9.1"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 1L);
        criteria.addSortName(PageOrdering.ASC);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 4L);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion().equals("9.1"));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 1L);
    }

    @Test(enabled=true)
    public void testAddBundleFiles() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        BundleFile bf1 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-bundlefile-1", "1.0", null, "Test Bundle File # 1".getBytes());
        BundleFile bf2 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-bundlefile-2", "1.0", null, "Test Bundle File # 2".getBytes());
    }

    @Test(enabled=true)
    public void testAddBundleFilesToDifferentBundles() throws Exception {
        BundleType bt = this.createBundleType("one");
        Bundle b1 = this.createBundle("one", bt);
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        BundleFile b1f1 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-file1", "1.0", null, "Bundle #1 File # 1".getBytes());
        Bundle b2 = this.createBundle("two", bt);
        BundleManagerBeanTest.assertNotNull((Object)b2);
        BundleVersion bv2 = this.createBundleVersion(b2.getName(), "1.0", b2);
        BundleManagerBeanTest.assertNotNull((Object)bv2);
        BundleFile b2f1 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv2.getId(), "bundletest-file1", "1.0", null, "Bundle #2 File # 1".getBytes());
        BundleFileCriteria bfc = new BundleFileCriteria();
        bfc.addFilterBundleVersionId(Integer.valueOf(bv1.getId()));
        PageList bundleFiles = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfc);
        assert (bundleFiles.size() == 1) : bundleFiles;
        assert (((BundleFile)bundleFiles.get(0)).getId() == b1f1.getId()) : bundleFiles;
        bfc = new BundleFileCriteria();
        bfc.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
        bundleFiles = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfc);
        assert (bundleFiles.size() == 1) : bundleFiles;
        assert (((BundleFile)bundleFiles.get(0)).getId() == b2f1.getId()) : bundleFiles;
        assert (b1f1.getId() != b2f1.getId()) : "should have been different bundle files";
        assert (b1f1.getPackageVersion().getId() != b2f1.getPackageVersion().getId()) : "should be different PV";
        assert (b1f1.getPackageVersion().getGeneralPackage().getId() != b2f1.getPackageVersion().getGeneralPackage().getId()) : "package IDs should be different";
        assert (!b1f1.getPackageVersion().getGeneralPackage().equals((Object)b2f1.getPackageVersion().getGeneralPackage())) : "should be different packages";
    }

    @Test(enabled=true)
    public void testCreateBundleDeployment() throws Exception {
        BundleDeployment bd1;
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        ResourceGroup platformResourceGroup = this.createTestResourceGroup();
        BundleManagerBeanTest.assertNotNull((Object)platformResourceGroup);
        BundleDestination dest1 = this.createDestination(b1, "one", "/test", platformResourceGroup);
        BundleManagerBeanTest.assertNotNull((Object)dest1);
        Configuration config = new Configuration();
        try {
            bd1 = this.createDeployment("one", bv1, dest1, config);
            BundleManagerBeanTest.fail((String)"Bad config was accepted");
        }
        catch (Exception e) {
            // empty catch block
        }
        config.put((Property)new PropertySimple("bundletest.property", (Object)"bundletest.property value"));
        bd1 = this.createDeployment("one", bv1, dest1, config);
        BundleManagerBeanTest.assertNotNull((Object)bd1);
    }

    @Test(enabled=true)
    public void testDeployBundle() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("bundletest.property", (Object)"bundletest.property value"));
        ResourceGroup platformResourceGroup = this.createTestResourceGroup();
        BundleManagerBeanTest.assertNotNull((Object)platformResourceGroup);
        BundleDestination dest1 = this.createDestination(b1, "one", "/test", platformResourceGroup);
        BundleManagerBeanTest.assertNotNull((Object)dest1);
        BundleDeployment bd1 = this.createDeployment("one", bv1, dest1, config);
        BundleManagerBeanTest.assertNotNull((Object)bd1);
        BundleManagerBeanTest.assertEquals((Object)BundleDeploymentStatus.PENDING, (Object)bd1.getStatus());
        BundleDeployment bd1d = this.bundleManager.scheduleBundleDeployment(this.overlord, bd1.getId(), false);
        BundleManagerBeanTest.assertNotNull((Object)bd1d);
        BundleManagerBeanTest.assertEquals((int)bd1.getId(), (int)bd1d.getId());
        BundleDeploymentCriteria bdc = new BundleDeploymentCriteria();
        bdc.addFilterId(Integer.valueOf(bd1d.getId()));
        bdc.fetchBundleVersion(true);
        bdc.fetchDestination(true);
        bdc.fetchResourceDeployments(true);
        bdc.fetchTags(true);
        PageList bds = this.bundleManager.findBundleDeploymentsByCriteria(this.overlord, bdc);
        BundleManagerBeanTest.assertEquals((int)1, (int)bds.size());
        bd1d = (BundleDeployment)bds.get(0);
        BundleManagerBeanTest.assertEquals((Object)platformResourceGroup, (Object)bd1d.getDestination().getGroup());
        BundleManagerBeanTest.assertEquals((int)dest1.getId(), (int)bd1d.getDestination().getId());
        BundleResourceDeploymentCriteria c = new BundleResourceDeploymentCriteria();
        c.addFilterBundleDeploymentId(Integer.valueOf(bd1d.getId()));
        c.fetchBundleDeployment(true);
        c.fetchHistories(true);
        c.fetchResource(true);
        PageList brds = this.bundleManager.findBundleResourceDeploymentsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertEquals((int)1, (int)brds.size());
        BundleManagerBeanTest.assertEquals((int)1, (int)bd1d.getResourceDeployments().size());
        BundleManagerBeanTest.assertEquals((int)((BundleResourceDeployment)bd1d.getResourceDeployments().get(0)).getId(), (int)((BundleResourceDeployment)brds.get(0)).getId());
        BundleResourceDeployment brd = (BundleResourceDeployment)brds.get(0);
        BundleManagerBeanTest.assertNotNull((Object)brd.getBundleResourceDeploymentHistories());
        int size = brd.getBundleResourceDeploymentHistories().size();
        BundleManagerBeanTest.assertTrue((size > 0 ? 1 : 0) != 0);
        String auditMessage = "BundleTest-Message";
        this.bundleManager.addBundleResourceDeploymentHistory(this.overlord, brd.getId(), new BundleResourceDeploymentHistory(this.overlord.getName(), auditMessage, auditMessage, BundleResourceDeploymentHistory.Category.DEPLOY_STEP, BundleResourceDeploymentHistory.Status.SUCCESS, auditMessage, auditMessage));
        brds = this.bundleManager.findBundleResourceDeploymentsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertEquals((int)1, (int)brds.size());
        BundleManagerBeanTest.assertEquals((int)brd.getId(), (int)((BundleResourceDeployment)brds.get(0)).getId());
        brd = (BundleResourceDeployment)brds.get(0);
        BundleManagerBeanTest.assertNotNull((Object)brd.getBundleResourceDeploymentHistories());
        BundleManagerBeanTest.assertTrue((size + 1 == brd.getBundleResourceDeploymentHistories().size() ? 1 : 0) != 0);
        BundleResourceDeploymentHistory newHistory = null;
        for (BundleResourceDeploymentHistory h : brd.getBundleResourceDeploymentHistories()) {
            if (!auditMessage.equals(h.getMessage())) continue;
            newHistory = h;
            break;
        }
        BundleManagerBeanTest.assertNotNull(newHistory);
        BundleManagerBeanTest.assertEquals((String)auditMessage, (String)newHistory.getAction());
        BundleManagerBeanTest.assertEquals((Object)BundleResourceDeploymentHistory.Status.SUCCESS, (Object)newHistory.getStatus());
    }

    @Test(enabled=true)
    public void testGetBundleFilenames() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleManagerBeanTest.assertNotNull((Object)b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        BundleManagerBeanTest.assertNotNull((Object)bv1);
        Set filenames = this.bundleManager.getBundleVersionFilenames(this.overlord, bv1.getId(), true);
        BundleManagerBeanTest.assertNotNull((Object)filenames);
        BundleManagerBeanTest.assertEquals((int)2, (int)filenames.size());
        BundleFile bf1 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-bundlefile-1", "1.0", null, "Test Bundle File # 1".getBytes());
        filenames = this.bundleManager.getBundleVersionFilenames(this.overlord, bv1.getId(), true);
        BundleManagerBeanTest.assertNotNull((Object)filenames);
        BundleManagerBeanTest.assertEquals((int)1, (int)filenames.size());
        BundleFile bf2 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-bundlefile-2", "1.0", null, "Test Bundle File # 2".getBytes());
        filenames = this.bundleManager.getBundleVersionFilenames(this.overlord, bv1.getId(), true);
        BundleManagerBeanTest.assertNotNull((Object)filenames);
        BundleManagerBeanTest.assertEquals((int)0, (int)filenames.size());
    }

    @Test(enabled=true)
    public void testFindBundlesByCriteria() throws Exception {
        Bundle b1 = this.createBundle("one");
        Bundle b2 = this.createBundle("two");
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        BundleVersion bv2 = this.createBundleVersion(b2.getName(), "1.0", b2);
        BundleCriteria c = new BundleCriteria();
        PageList bundles = null;
        Bundle b = null;
        String name = null;
        c.addFilterName(TEST_PREFIX);
        bundles = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bundles);
        BundleManagerBeanTest.assertEquals((int)2, (int)bundles.size());
        b = (Bundle)bundles.get(0);
        name = "one";
        BundleManagerBeanTest.assertNotNull((Object)b);
        BundleManagerBeanTest.assertTrue((String)b.getBundleType().getName(), (boolean)b.getName().contains(name));
        BundleManagerBeanTest.assertTrue((String)b.getBundleType().getName(), (boolean)b.getBundleType().getName().contains(name));
        try {
            b.getBundleVersions().isEmpty();
            BundleManagerBeanTest.fail((String)"Should have thrown LazyInitializationException");
        }
        catch (LazyInitializationException e) {
        }
        catch (Exception e) {
            BundleManagerBeanTest.fail((String)"Should have thrown LazyInitializationException");
        }
        b = (Bundle)bundles.get(1);
        name = "two";
        BundleManagerBeanTest.assertNotNull((Object)b);
        BundleManagerBeanTest.assertTrue((String)b.getBundleType().getName(), (boolean)b.getName().contains(name));
        BundleManagerBeanTest.assertTrue((String)b.getBundleType().getName(), (boolean)b.getBundleType().getName().contains(name));
        c.addFilterId(Integer.valueOf(b.getId()));
        c.addFilterName(b.getName());
        c.addFilterBundleTypeName(b.getName());
        c.fetchBundleVersions(true);
        c.fetchRepo(true);
        bundles = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bundles);
        BundleManagerBeanTest.assertEquals((int)1, (int)bundles.size());
        b = (Bundle)bundles.get(0);
        BundleManagerBeanTest.assertTrue((String)b.getBundleType().getName(), (boolean)b.getName().contains(name));
        BundleManagerBeanTest.assertTrue((String)b.getBundleType().getName(), (boolean)b.getBundleType().getName().contains(name));
        BundleManagerBeanTest.assertNotNull((Object)b.getBundleVersions());
        BundleManagerBeanTest.assertEquals((int)1, (int)b.getBundleVersions().size());
        BundleVersion bv = (BundleVersion)b.getBundleVersions().get(0);
        BundleManagerBeanTest.assertEquals((Object)bv2, (Object)bv);
        BundleManagerBeanTest.assertEquals((Object)b, (Object)bv.getBundle());
        Repo r = b.getRepo();
        BundleManagerBeanTest.assertNotNull((Object)r);
        BundleManagerBeanTest.assertEquals((String)b.getName(), (String)r.getName());
    }

    @Test(enabled=true)
    public void testFindBundleVersionsByCriteria() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        BundleVersion bv2 = this.createBundleVersion(b1.getName(), "2.0", b1);
        BundleVersion bv3 = this.createBundleVersion(b1.getName(), "2.1", b1);
        BundleVersionCriteria c = new BundleVersionCriteria();
        PageList bvs = null;
        BundleVersion bvOut = null;
        c.addFilterName(TEST_PREFIX);
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)3, (int)bvs.size());
        BundleManagerBeanTest.assertFalse((boolean)((BundleVersion)bvs.get(0)).equals(bvs.get(1)));
        BundleManagerBeanTest.assertFalse((boolean)((BundleVersion)bvs.get(0)).equals(bvs.get(2)));
        BundleManagerBeanTest.assertFalse((boolean)((BundleVersion)bvs.get(1)).equals(bvs.get(2)));
        BundleManagerBeanTest.assertTrue((boolean)((BundleVersion)bvs.get(0)).equals(bvs.get(0)));
        BundleManagerBeanTest.assertTrue((((BundleVersion)bvs.get(0)).equals((Object)bv2) || ((BundleVersion)bvs.get(1)).equals((Object)bv2) || ((BundleVersion)bvs.get(2)).equals((Object)bv2) ? 1 : 0) != 0);
        BundleVersion bvIn = (BundleVersion)bvs.get(1);
        c.addFilterId(Integer.valueOf(bvIn.getId()));
        c.addFilterName(bvIn.getName());
        c.addFilterBundleName("one");
        c.addFilterVersion(bvIn.getVersion());
        c.fetchBundle(true);
        c.fetchBundleDeployments(true);
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        BundleManagerBeanTest.assertNotNull((Object)bvs);
        BundleManagerBeanTest.assertEquals((int)1, (int)bvs.size());
        bvOut = (BundleVersion)bvs.get(0);
        BundleManagerBeanTest.assertEquals((Object)bvIn, (Object)bvOut);
        BundleManagerBeanTest.assertEquals((Object)bvOut.getBundle(), (Object)b1);
        BundleManagerBeanTest.assertNotNull((Object)bvOut.getBundleDeployments());
        BundleManagerBeanTest.assertTrue((boolean)bvOut.getBundleDeployments().isEmpty());
    }

    private BundleType createBundleType(String name) throws Exception {
        String fullName = "bundletest-type-" + name;
        ResourceType rt = this.createResourceTypeForBundleType(name);
        BundleType bt = this.bundleManager.createBundleType(this.overlord, fullName, rt.getId());
        assert (bt.getId() > 0);
        assert (bt.getName().endsWith(fullName));
        return bt;
    }

    private Bundle createBundle(String name) throws Exception {
        BundleType bt = this.createBundleType(name);
        return this.createBundle(name, bt);
    }

    private Bundle createBundle(String name, BundleType bt) throws Exception {
        String fullName = "bundletest-bundle-" + name;
        Bundle b = this.bundleManager.createBundle(this.overlord, fullName, fullName + "-desc", bt.getId());
        assert (b.getId() > 0);
        assert (b.getName().endsWith(fullName));
        return b;
    }

    private BundleVersion createBundleVersion(String name, String version, Bundle bundle) throws Exception {
        String fullName = "bundletest-bundleversion-" + version + "-" + name;
        String recipe = "deploy -f bundletest.zip -d @@ test.path @@";
        BundleVersion bv = this.bundleManager.createBundleVersion(this.overlord, bundle.getId(), fullName, fullName + "-desc", version, "deploy -f bundletest.zip -d @@ test.path @@");
        assert (bv.getId() > 0);
        assert (bv.getName().endsWith(fullName));
        return bv;
    }

    private BundleDestination createDestination(Bundle bundle, String name, String deployDir, ResourceGroup group) throws Exception {
        String fullName = "bundletest-bundledestination-" + name;
        BundleDestination bd = this.bundleManager.createBundleDestination(this.overlord, bundle.getId(), fullName, fullName, TEST_DESTBASEDIR_NAME, deployDir, Integer.valueOf(group.getId()));
        assert (bd.getId() > 0);
        assert (bd.getName().endsWith(fullName));
        assert (bd.getDestinationBaseDirectoryName().equals(TEST_DESTBASEDIR_NAME));
        return bd;
    }

    private BundleDeployment createDeployment(String name, BundleVersion bv, BundleDestination dest, Configuration config) throws Exception {
        String fullName = "bundletest-bundledeployment-" + name;
        BundleDeployment bd = this.bundleManager.createBundleDeployment(this.overlord, bv.getId(), dest.getId(), fullName, config);
        assert (bd.getId() > 0);
        assert (bd.getDescription().endsWith(fullName));
        return bd;
    }

    private ResourceType createResourceTypeForBundleType(String name) throws Exception {
        String fullName = "bundletest-resourcetype-" + name;
        ResourceType rt = new ResourceType(fullName, "BundleManagerBeanTest", ResourceCategory.PLATFORM, null);
        TransactionManager txMgr = this.getTransactionManager();
        txMgr.begin();
        EntityManager em = BundleManagerBeanTest.getEntityManager();
        em.persist((Object)rt);
        em.close();
        txMgr.commit();
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceGroup createTestResourceGroup() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = BundleManagerBeanTest.getEntityManager();
        ResourceGroup resourceGroup = null;
        Resource resource = null;
        try {
            ResourceType resourceType = new ResourceType("bundletest-platform-" + System.currentTimeMillis(), "test", ResourceCategory.PLATFORM, null);
            ConfigurationDefinition pcDef = new ConfigurationDefinition("bundletest-testdef", "bundle test");
            PropertyDefinitionSimple propDef = new PropertyDefinitionSimple(TEST_BUNDLE_DESTBASEDIR_PROP, "", true, PropertySimpleType.STRING);
            propDef.setDisplayName(TEST_BUNDLE_DESTBASEDIR_PROP);
            pcDef.put((PropertyDefinition)propDef);
            em.persist((Object)pcDef);
            ResourceTypeBundleConfiguration rtbc = new ResourceTypeBundleConfiguration(new Configuration());
            rtbc.addBundleDestinationBaseDirectory(TEST_DESTBASEDIR_NAME, ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration.name(), TEST_BUNDLE_DESTBASEDIR_PROP, null);
            resourceType.setResourceTypeBundleConfiguration(rtbc);
            resourceType.setPluginConfigurationDefinition(pcDef);
            em.persist((Object)resourceType);
            rtbc = resourceType.getResourceTypeBundleConfiguration();
            assert (rtbc != null);
            assert (rtbc.getBundleDestinationBaseDirectories().size() == 1);
            ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory bdbd = (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory)rtbc.getBundleDestinationBaseDirectories().iterator().next();
            assert (bdbd.getName().equals(TEST_DESTBASEDIR_NAME));
            assert (bdbd.getValueContext() == ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration);
            assert (bdbd.getValueName().equals(TEST_BUNDLE_DESTBASEDIR_PROP));
            Agent agent = new Agent("bundletest-testagent", "testaddress", 1, "", "testtoken");
            em.persist((Object)agent);
            em.flush();
            Configuration rc = new Configuration();
            rc.put((Property)new PropertySimple(TEST_BUNDLE_DESTBASEDIR_PROP, (Object)TEST_BUNDLE_DESTBASEDIR_PROP_VALUE));
            em.persist((Object)rc);
            resource = new Resource("reskey" + System.currentTimeMillis(), "bundletest-resname", resourceType);
            resource.setUuid("" + System.currentTimeMillis());
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            resource.setAgent(agent);
            resource.setResourceConfiguration(rc);
            em.persist((Object)resource);
            resourceGroup = new ResourceGroup("bundletest-group-" + System.currentTimeMillis());
            resourceGroup.addExplicitResource(resource);
            resourceGroup.setResourceType(resourceType);
            em.persist((Object)resourceGroup);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT PREPARE TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        finally {
            em.close();
        }
        return resourceGroup;
    }

    private String readFile(File file) throws Exception {
        return new String(StreamUtil.slurp((InputStream)new FileInputStream(file)));
    }

    private void writeFile(File file, String content) throws Exception {
        file.getParentFile().mkdirs();
        StreamUtil.copy((InputStream)new ByteArrayInputStream(content.getBytes()), (OutputStream)new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createZip(File destDir, String zipName, String[] entryNames, String[] contents) throws Exception {
        FileOutputStream stream = null;
        ZipOutputStream out = null;
        try {
            destDir.mkdirs();
            File zipFile = new File(destDir, zipName);
            stream = new FileOutputStream(zipFile);
            out = new ZipOutputStream(stream);
            assert (contents.length == entryNames.length);
            for (int i = 0; i < contents.length; ++i) {
                ZipEntry zipAdd = new ZipEntry(entryNames[i]);
                zipAdd.setTime(System.currentTimeMillis());
                out.putNextEntry(zipAdd);
                out.write(contents[i].getBytes());
            }
            File file = zipFile;
            return file;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }
}

