/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.AffinityGroup;
import org.rhq.core.domain.cloud.PartitionEvent;
import org.rhq.core.domain.cloud.PartitionEventType;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.cloud.AffinityGroupManagerLocal;
import org.rhq.enterprise.server.cloud.CloudManagerLocal;
import org.rhq.enterprise.server.cloud.FailoverListManagerLocal;
import org.rhq.enterprise.server.cloud.PartitionEventManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class FailoverListManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = true;
    private FailoverListManagerLocal failoverListManager;
    private AgentManagerLocal agentManager;
    private PartitionEventManagerLocal partitionEventManager;
    private CloudManagerLocal cloudManager;
    private AffinityGroupManagerLocal affinityGroupManager;
    private Subject overlord;
    private List<Server> servers;
    private List<Agent> agents;
    private AffinityGroup ag;
    private PartitionEvent partitionEvent;
    private List<Agent> newAgents;

    @BeforeClass
    public void beforeClass() {
        this.agentManager = LookupUtil.getAgentManager();
        this.failoverListManager = LookupUtil.getFailoverListManager();
        this.partitionEventManager = LookupUtil.getPartitionEventManager();
        this.cloudManager = LookupUtil.getCloudManager();
        this.affinityGroupManager = LookupUtil.getAffinityGroupManager();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.servers = new ArrayList<Server>();
        this.agents = new ArrayList<Agent>();
        this.newAgents = new ArrayList<Agent>();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.servers.clear();
        this.agents.clear();
        this.newAgents.clear();
        this.prepareForTestAgents();
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        try {
            this.getTransactionManager().begin();
            this.partitionEventManager.deletePartitionEvents(this.overlord, new Integer[]{this.partitionEvent.getId()});
            try {
                for (Server server : this.servers) {
                    this.cloudManager.updateServerMode(new Integer[]{server.getId()}, Server.OperationMode.DOWN);
                    this.cloudManager.deleteServer(Integer.valueOf(server.getId()));
                }
                for (Agent agent : this.agents) {
                    this.agentManager.deleteAgent(agent);
                }
                this.affinityGroupManager.delete(this.overlord, new Integer[]{this.ag.getId()});
                if (null != this.newAgents) {
                    for (Agent agent : this.newAgents) {
                        this.agentManager.deleteAgent(agent);
                    }
                }
                PageList events = this.partitionEventManager.getPartitionEvents(this.overlord, null, null, "flm", PageControl.getUnlimitedInstance());
                Integer[] eventIds = new Integer[events.size()];
                int size = events.size();
                for (int i = 0; i < size; ++i) {
                    eventIds[i] = ((PartitionEvent)events.get(i)).getId();
                }
                this.partitionEventManager.deletePartitionEvents(this.overlord, eventIds);
            }
            catch (Exception e) {
                System.out.println(e);
                throw e;
            }
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println(e);
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.unprepareForTestAgents();
        }
    }

    private void setupTest(int numServers, int numAgents) throws Exception {
        Server server = new Server();
        this.getTransactionManager().begin();
        EntityManager em = FailoverListManagerBeanTest.getEntityManager();
        try {
            int i;
            for (i = 0; i < numServers; ++i) {
                server = new Server();
                server.setName("Server-flm-" + i);
                server.setAddress("" + i);
                server.setPort(i);
                server.setSecurePort(i);
                server.setOperationMode(Server.OperationMode.NORMAL);
                em.persist((Object)server);
                this.servers.add(server);
            }
            for (i = 0; i < numAgents; ++i) {
                Agent agent = new Agent("Agent-flm-" + i, "" + i, 1, "endpoint", "token" + i);
                em.persist((Object)agent);
                this.agents.add(agent);
            }
            this.ag = new AffinityGroup("AG-flm-1");
            em.persist((Object)this.ag);
            this.partitionEvent = new PartitionEvent("FLM-TEST", PartitionEventType.SYSTEM_INITIATED_PARTITION, "Test-flm-detail", PartitionEvent.ExecutionStatus.IMMEDIATE);
            em.persist((Object)this.partitionEvent);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println(e);
                this.getTransactionManager().rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw e;
        }
        finally {
            em.close();
        }
    }

    private void setupNewAgents(int numNewAgents) throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = FailoverListManagerBeanTest.getEntityManager();
        try {
            for (int i = 0; i < numNewAgents; ++i) {
                Agent agent = new Agent("Agent-flm-NEW" + i, "NEW-" + i, 1, "endpoint", "token-NEW-" + i);
                em.persist((Object)agent);
                this.newAgents.add(agent);
            }
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println(e);
                this.getTransactionManager().rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw e;
        }
        finally {
            em.close();
        }
    }

    private boolean validateBalance(Map<Agent, FailoverListComposite> result, int numServers, int numAgents) {
        this.validateBasic(result, numServers, numAgents);
        for (int i = 0; i < numServers; ++i) {
            HashMap<String, Integer> distributionMap = new HashMap<String, Integer>(numServers);
            for (Agent agent : result.keySet()) {
                int n;
                FailoverListComposite flc = result.get(agent);
                FailoverListComposite.ServerEntry server = flc.get(i);
                Integer count = (Integer)distributionMap.get(server.address);
                String string = server.address;
                if (null == count) {
                    n = 1;
                } else {
                    count = count + 1;
                    n = count;
                }
                distributionMap.put(string, n);
            }
            for (Integer agentsOnServer : distributionMap.values()) {
                double div = (double)numAgents / (double)numServers;
                int ceil = (int)Math.ceil(div);
                int floor = (int)Math.floor(div);
                assert (agentsOnServer <= ceil);
                assert (agentsOnServer >= floor);
            }
        }
        return true;
    }

    private void validateAffinity(Map<Agent, FailoverListComposite> result, int numServers, int numAgents, int numAffinityServers, int numAffinityAgents) {
        this.validateBasic(result, numServers, numAgents);
        for (int level = 0; level < numServers; ++level) {
            HashMap<Integer, Integer> distributionMap = new HashMap<Integer, Integer>(numServers);
            for (Agent agent : result.keySet()) {
                int n;
                FailoverListComposite flc = result.get(agent);
                FailoverListComposite.ServerEntry server = flc.get(level);
                Integer agentId = Integer.valueOf(agent.getAddress());
                Integer serverId = Integer.valueOf(server.address);
                if (level < numAffinityServers && agentId < numAffinityAgents) assert (serverId < numAffinityServers);
                Integer count = (Integer)distributionMap.get(serverId);
                if (null == count) {
                    n = 1;
                } else {
                    count = count + 1;
                    n = count;
                }
                distributionMap.put(serverId, n);
            }
            for (Integer serverId : distributionMap.keySet()) {
                Integer agentsOnServer = (Integer)distributionMap.get(serverId);
                if (level < numAffinityServers) continue;
                double div = serverId < numAffinityServers ? (double)(numAgents - numAffinityAgents) / (double)numAffinityServers : (double)numAffinityAgents / (double)(numServers - numAffinityServers);
                int ceil = (int)Math.ceil(div);
                int floor = (int)Math.floor(div);
                assert (agentsOnServer <= ceil);
                assert (agentsOnServer >= floor);
            }
        }
    }

    private void validateBasic(Map<Agent, FailoverListComposite> result, int numServers, int numAgents) {
        for (Agent agent : result.keySet()) {
            assert (result.get(agent).size() == numServers);
        }
        for (Agent agent : result.keySet()) {
            HashSet<String> names = new HashSet<String>(numServers);
            FailoverListComposite flc = result.get(agent);
            for (int i = 0; i < numServers; ++i) {
                FailoverListComposite.ServerEntry server = flc.get(i);
                assert (names.add(server.address));
            }
        }
    }

    @Test(enabled=true)
    public void testGetForAllAgents1_0() throws Exception {
        this.setupTest(1, 0);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 1, 0));
    }

    @Test(enabled=true)
    public void testGetForAllAgents1_1() throws Exception {
        this.setupTest(1, 1);
        long start = System.currentTimeMillis();
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        System.out.println("Elapsed 1/0 = " + (System.currentTimeMillis() - start) + "ms");
        assert (null != result);
        assert (this.validateBalance(result, 1, 1));
    }

    @Test(enabled=true)
    public void testGetForAllAgents1_2() throws Exception {
        this.setupTest(1, 2);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 1, 2));
    }

    @Test(enabled=true)
    public void testGetForAllAgents1_5() throws Exception {
        this.setupTest(1, 5);
        long start = System.currentTimeMillis();
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        System.out.println("Elapsed 1/5 = " + (System.currentTimeMillis() - start) + "ms");
        assert (null != result);
        assert (this.validateBalance(result, 1, 5));
    }

    @Test(enabled=true)
    public void testGetForAllAgents2_0() throws Exception {
        this.setupTest(2, 0);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 2, 0));
    }

    @Test(enabled=true)
    public void testGetForAllAgents2_1() throws Exception {
        this.setupTest(2, 1);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 2, 1));
    }

    @Test(enabled=true)
    public void testGetForAllAgents2_2() throws Exception {
        this.setupTest(2, 2);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 2, 2));
    }

    @Test(enabled=true)
    public void testGetForAllAgents2_3() throws Exception {
        this.setupTest(2, 3);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 2, 3));
    }

    @Test(enabled=true)
    public void testGetForAllAgents2_9() throws Exception {
        this.setupTest(2, 9);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 2, 9));
    }

    @Test(enabled=true)
    public void testGetForAllAgents2_10() throws Exception {
        this.setupTest(2, 10);
        long start = System.currentTimeMillis();
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        System.out.println("Elapsed 2/10 = " + (System.currentTimeMillis() - start) + "ms");
        assert (null != result);
        assert (this.validateBalance(result, 2, 10));
    }

    @Test(enabled=true)
    public void testGetForAllAgents2_15() throws Exception {
        this.setupTest(2, 15);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 2, 15));
    }

    @Test(enabled=true)
    public void testGetForAllAgents3_2() throws Exception {
        this.setupTest(3, 2);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 3, 2));
    }

    @Test(enabled=true)
    public void testGetForAllAgents3_3() throws Exception {
        this.setupTest(3, 3);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 3, 3));
    }

    @Test(enabled=true)
    public void testGetForAllAgents3_4() throws Exception {
        this.setupTest(3, 4);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 3, 4));
    }

    @Test(enabled=true)
    public void testGetForAllAgents5_10() throws Exception {
        this.setupTest(5, 10);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 5, 10));
    }

    @Test(enabled=true)
    public void testGetForAllAgents5_25() throws Exception {
        this.setupTest(5, 25);
        long start = System.currentTimeMillis();
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        System.out.println("Elapsed 2/10 = " + (System.currentTimeMillis() - start) + "ms");
        assert (null != result);
        assert (this.validateBalance(result, 5, 25));
    }

    @Test(enabled=true)
    public void testGetForAllAgents5_42() throws Exception {
        this.setupTest(5, 42);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        assert (this.validateBalance(result, 5, 42));
    }

    @Test(enabled=true)
    public void testGetForAllAgents20_1000() throws Exception {
        this.setupTest(20, 1000);
        long start = System.currentTimeMillis();
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        System.out.println("Elapsed 20/1000 = " + (System.currentTimeMillis() - start) + "ms");
        assert (null != result);
        assert (this.validateBalance(result, 20, 1000));
        start = System.currentTimeMillis();
        this.setupNewAgents(1);
        this.failoverListManager.getForSingleAgent(this.partitionEvent, this.newAgents.get(0).getName());
        System.out.println("Elapsed 1 NEW 20/1000 = " + (System.currentTimeMillis() - start) + "ms");
    }

    @Test(enabled=true)
    public void testGetForAllAgents2_10_affinity_1_10() throws Exception {
        this.setupTest(2, 10);
        this.servers.get(0).setAffinityGroup(this.ag);
        for (Agent agent : this.agents) {
            agent.setAffinityGroup(this.ag);
        }
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        this.validateAffinity(result, 2, 10, 1, 10);
    }

    @Test(enabled=true)
    public void testGetForAllAgents4_20_affinity_2_10() throws Exception {
        this.setupTest(4, 20);
        this.servers.get(0).setAffinityGroup(this.ag);
        this.servers.get(1).setAffinityGroup(this.ag);
        for (int i = 0; i < 10; ++i) {
            this.agents.get(i).setAffinityGroup(this.ag);
        }
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        this.validateAffinity(result, 4, 20, 2, 10);
    }

    @Test(enabled=true)
    public void testGetForAllAgents3_20_affinity_2_10() throws Exception {
        this.setupTest(3, 20);
        this.servers.get(0).setAffinityGroup(this.ag);
        this.servers.get(1).setAffinityGroup(this.ag);
        for (int i = 0; i < 10; ++i) {
            this.agents.get(i).setAffinityGroup(this.ag);
        }
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        this.validateAffinity(result, 3, 20, 2, 10);
    }

    @Test(enabled=true)
    public void testGetForAllAgents3_20_preferred_20() throws Exception {
        int i;
        this.setupTest(3, 20);
        for (i = 0; i < 10; ++i) {
            this.agents.get(i).setServer(this.servers.get(0));
        }
        for (i = 10; i < 20; ++i) {
            this.agents.get(i).setServer(this.servers.get(1));
        }
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        this.validateBalance(result, 3, 20);
    }

    @Test(enabled=true)
    public void testGetForSingleAgent_existing() throws Exception {
        this.setupTest(2, 4);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        for (Agent agent : result.keySet()) {
            FailoverListComposite flc1 = (FailoverListComposite)result.get(agent);
            FailoverListComposite flc2 = this.failoverListManager.getForSingleAgent(this.partitionEvent, agent.getName());
            assert (flc1.size() == flc2.size());
            int size = flc1.size();
            for (int i = 0; i < size; ++i) {
                assert (flc1.get(i).equals((Object)flc2.get(i)));
            }
        }
    }

    @Test(enabled=true)
    public void testGetForSingleAgent_new_1() throws Exception {
        this.setupTest(2, 4);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        this.setupNewAgents(3);
        ArrayList<FailoverListComposite> serverLists = new ArrayList<FailoverListComposite>(3);
        for (int i = 0; i < 3; ++i) {
            serverLists.add(this.failoverListManager.getForSingleAgent(this.partitionEvent, this.newAgents.get(i).getName()));
            assert (null != serverLists.get(i));
            assert (((FailoverListComposite)serverLists.get(i)).size() == this.servers.size());
        }
        assert (!((FailoverListComposite)serverLists.get(0)).equals(serverLists.get(1)));
        assert (((FailoverListComposite)serverLists.get(0)).equals(serverLists.get(2)));
        assert (!((FailoverListComposite)serverLists.get(1)).equals(serverLists.get(2)));
    }

    @Test(enabled=true)
    public void testGetForSingleAgent_new_2() throws Exception {
        this.setupTest(3, 6);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        this.setupNewAgents(3);
        ArrayList<FailoverListComposite> serverLists = new ArrayList<FailoverListComposite>(3);
        for (int i = 0; i < 3; ++i) {
            serverLists.add(this.failoverListManager.getForSingleAgent(this.partitionEvent, this.newAgents.get(i).getName()));
            assert (null != serverLists.get(i));
            assert (((FailoverListComposite)serverLists.get(i)).size() == this.servers.size());
        }
        assert (!((FailoverListComposite)serverLists.get(0)).equals(serverLists.get(1)));
        assert (!((FailoverListComposite)serverLists.get(0)).equals(serverLists.get(2))) : ((Object)serverLists).toString();
        assert (!((FailoverListComposite)serverLists.get(1)).equals(serverLists.get(2)));
    }

    @Test(enabled=true)
    public void testGetForSingleAgent_new_3() throws Exception {
        this.setupTest(1, 0);
        Map result = this.failoverListManager.refresh(this.partitionEvent, this.servers, this.agents);
        assert (null != result);
        this.setupNewAgents(3);
        ArrayList<FailoverListComposite> serverLists = new ArrayList<FailoverListComposite>(3);
        for (int i = 0; i < 3; ++i) {
            serverLists.add(this.failoverListManager.getForSingleAgent(this.partitionEvent, this.newAgents.get(i).getName()));
            assert (null != serverLists.get(i));
            assert (((FailoverListComposite)serverLists.get(i)).size() == this.servers.size());
        }
        assert (((FailoverListComposite)serverLists.get(0)).equals(serverLists.get(1)));
        assert (((FailoverListComposite)serverLists.get(0)).equals(serverLists.get(2)));
        assert (((FailoverListComposite)serverLists.get(1)).equals(serverLists.get(2)));
    }
}

