/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.communications.command.annotation.Asynchronous;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.group.GroupPluginConfigurationUpdate;
import org.rhq.core.domain.criteria.ResourceConfigurationUpdateCriteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class ConfigurationManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = true;
    private ConfigurationManagerLocal configurationManager;
    private ResourceManagerLocal resourceManager;
    private Resource newResource1;
    private Resource newResource2;
    private ResourceGroup compatibleGroup;
    private PageControl configUpdatesPageControl;
    private Agent agent;
    private Subject overlord;

    @BeforeClass
    public void beforeClass() {
        this.configUpdatesPageControl = PageControl.getUnlimitedInstance();
        this.configUpdatesPageControl.addDefaultOrderingField("cu.createdTime", PageOrdering.ASC);
        this.configurationManager = LookupUtil.getConfigurationManager();
        this.resourceManager = LookupUtil.getResourceManager();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.prepareScheduler();
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        TestServices testServices = new TestServices();
        agentServiceContainer.configurationService = testServices;
        agentServiceContainer.discoveryService = testServices;
        this.getTransactionManager().begin();
        EntityManager em = ConfigurationManagerBeanTest.getEntityManager();
        try {
            this.compatibleGroup = SessionTestHelper.createNewCompatibleGroupForRole(em, null, "compat");
            this.newResource1 = SessionTestHelper.createNewResourceForGroup(em, this.compatibleGroup, "res" + System.currentTimeMillis());
            this.newResource2 = SessionTestHelper.createNewResourceForGroup(em, this.compatibleGroup, "res" + System.currentTimeMillis());
            this.newResource1.addChildResource(this.newResource2);
            this.agent = SessionTestHelper.createNewAgent(em, "agent-" + ((Object)((Object)this)).getClass().getSimpleName());
            this.newResource1.setAgent(this.agent);
            this.newResource2.setAgent(this.agent);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println(e);
                this.getTransactionManager().rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw e;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        try {
            List deletedIds = this.resourceManager.uninventoryResource(this.overlord, this.newResource1.getId());
            for (Integer deletedResourceId : deletedIds) {
                this.resourceManager.uninventoryResourceAsyncWork(this.overlord, deletedResourceId.intValue());
            }
        }
        catch (Exception e) {
            System.out.println(e);
            throw e;
        }
        try {
            this.getTransactionManager().begin();
            EntityManager em = ConfigurationManagerBeanTest.getEntityManager();
            try {
                ResourceGroup group = (ResourceGroup)em.find(ResourceGroup.class, (Object)this.compatibleGroup.getId());
                em.remove((Object)group);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println(e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                em.close();
            }
            this.getTransactionManager().begin();
            em = ConfigurationManagerBeanTest.getEntityManager();
            try {
                ResourceType type = (ResourceType)em.find(ResourceType.class, (Object)this.newResource1.getResourceType().getId());
                em.remove((Object)type);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println(e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                em.close();
            }
        }
        finally {
            this.unprepareScheduler();
            this.unprepareForTestAgents();
        }
    }

    @Test(enabled=true)
    public void testLatestConfiguration() throws Exception {
        int resourceId = this.newResource1.getId();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration configuration1 = new Configuration();
        configuration1.put((Property)new PropertySimple("myboolean", (Object)"true"));
        Configuration configuration2 = new Configuration();
        configuration2.put((Property)new PropertySimple("myboolean", (Object)"false"));
        configuration2.put((Property)new PropertySimple("mysleep", (Object)"7000"));
        this.configurationManager.updateResourceConfiguration(overlord, resourceId, configuration1);
        Thread.sleep(2000L);
        ResourceConfigurationUpdate history1 = this.configurationManager.getLatestResourceConfigurationUpdate(overlord, resourceId);
        assert (history1 != null);
        PropertySimple myprop = history1.getConfiguration().getSimple("myboolean");
        assert (myprop != null);
        assert ("true".equals(myprop.getStringValue()));
        ResourceConfigurationUpdate history2 = null;
        boolean inProgress = false;
        boolean inProgressTested = false;
        this.configurationManager.updateResourceConfiguration(overlord, resourceId, configuration2);
        do {
            history2 = this.configurationManager.getLatestResourceConfigurationUpdate(overlord, resourceId);
            inProgress = this.configurationManager.isResourceConfigurationUpdateInProgress(overlord, resourceId);
            if (inProgress) {
                assert (history2 != null);
                assert (history2.getId() == history1.getId());
                myprop = history2.getConfiguration().getSimple("myboolean");
                assert (myprop != null);
                assert ("true".equals(myprop.getStringValue()));
                myprop = history2.getConfiguration().getSimple("mysleep");
                assert (myprop == null);
                inProgressTested = true;
                continue;
            }
            history2 = this.configurationManager.getLatestResourceConfigurationUpdate(overlord, resourceId);
            assert (history2 != null);
            assert (history2.getId() != history1.getId());
            myprop = history2.getConfiguration().getSimple("myboolean");
            assert (myprop != null);
            assert ("false".equals(myprop.getStringValue()));
            myprop = history2.getConfiguration().getSimple("mysleep");
            assert (myprop.getLongValue() != null);
            assert (myprop.getLongValue() == 7000L);
        } while (inProgress);
        ConfigurationManagerBeanTest.assertTrue((boolean)inProgressTested);
    }

    @Test(enabled=true)
    public void testDeleteType() throws Exception {
    }

    @Test(enabled=true)
    public void testPluginConfigurationUpdateCallbackSuccess() throws Exception {
        Resource resource = this.newResource1;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration configuration1 = new Configuration();
        configuration1.put((Property)new PropertySimple("foo", (Object)"1"));
        Configuration configuration2 = new Configuration();
        configuration2.put((Property)new PropertySimple("bar", (Object)"2"));
        Configuration current = this.configurationManager.getPluginConfiguration(overlord, resource.getId());
        assert (current != null);
        assert (current.getProperties().size() == 0) : current;
        this.configurationManager.updatePluginConfiguration(overlord, resource.getId(), configuration1);
        current = this.configurationManager.getPluginConfiguration(overlord, resource.getId());
        assert (current != null);
        assert (current.getProperties().size() == 1) : current;
        assert (current.getSimple("foo").getIntegerValue() == 1) : current;
        this.configurationManager.updatePluginConfiguration(overlord, resource.getId(), configuration2);
        current = this.configurationManager.getPluginConfiguration(overlord, resource.getId());
        assert (current != null);
        assert (current.getProperties().size() == 1) : current;
        assert (current.getSimple("bar").getIntegerValue() == 2) : current;
        assert (current.getSimple("foo") == null) : current;
        assert (current.remove("foo") == null) : current;
        assert (current.remove("bar") != null) : current;
        current.put((Property)new PropertySimple("hello", (Object)"3"));
        this.configurationManager.updatePluginConfiguration(overlord, resource.getId(), current);
        current = this.configurationManager.getPluginConfiguration(overlord, resource.getId());
        assert (current != null);
        assert (current.getProperties().size() == 1) : current;
        assert (current.getSimple("hello").getIntegerValue() == 3) : current;
        assert (current.getSimple("foo") == null) : current;
        assert (current.getSimple("bar") == null) : current;
    }

    @Test(enabled=true)
    public void testPluginConfigurationUpdateCallbackFailure() throws Exception {
        Resource resource = this.newResource1;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration configuration1 = new Configuration();
        configuration1.put((Property)new PropertySimple("foo", (Object)"1"));
        configuration1.put((Property)new PropertySimple("fail", (Object)"true"));
        Configuration current = this.configurationManager.getPluginConfiguration(overlord, resource.getId());
        assert (current != null);
        assert (current.getProperties().size() == 0) : current;
        PluginConfigurationUpdate update = this.configurationManager.updatePluginConfiguration(overlord, resource.getId(), configuration1);
        assert (update.getErrorMessage() != null) : "We should have simulated a failure, but instead received no error.";
        current = this.configurationManager.getPluginConfiguration(overlord, resource.getId());
        assert (current != null);
        assert (current.getProperties().size() != 0) : current.toString();
    }

    @Test(enabled=false)
    public void testGroupPluginConfigurationUpdateWorkflowSuccess() throws Exception {
    }

    @Test(enabled=false)
    public void testGroupPluginConfigurationUpdateWorkflowFailure() throws Exception {
    }

    @Test(enabled=false)
    public void testGroupPluginConfigurationUpdateMergeAlgorithmPerformance() throws Exception {
        Configuration configuration = new Configuration();
        configuration.put((Property)new PropertySimple("foo1", (Object)"1"));
        configuration.put((Property)new PropertySimple("foo2", (Object)"2"));
        configuration.put((Property)new PropertySimple("foo3", (Object)"3"));
        configuration.put((Property)new PropertySimple("foo4", (Object)"4"));
        configuration.put((Property)new PropertySimple("foo5", (Object)"5"));
        int TEST_SIZE = 100000;
        double BASELINE = 0.00165;
        double TOLERANCE = 3.0;
        long EXPECTED = 660L;
        ArrayList<Configuration> timingSet = new ArrayList<Configuration>();
        for (int i = 0; i < 100000; ++i) {
            timingSet.add(configuration);
        }
        long before = System.currentTimeMillis();
        long after = System.currentTimeMillis();
        long millisTaken = after - before;
        if (millisTaken < 660L) {
            if (millisTaken + 5000L < 660L) {
                assert (false) : "Merging GroupPluginConfigurationUpdates is too slow: It took " + millisTaken + " millis for " + 100000 + " resources; " + "We wanted less than " + 660L + "ms";
            } else {
                System.out.println("Merging GroupPluginConfigurationUpdates is a bit slow: It took " + millisTaken + " millis for " + 100000 + " resources; " + "We wanted less than " + 660L + "ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGroupPluginConfigurationUpdateWorkflowHelper(boolean failOnChildUpdates) throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ConfigurationManagerBeanTest.getEntityManager();
        Resource resource1 = this.newResource1;
        Resource resource2 = this.newResource2;
        try {
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            Configuration configuration1 = new Configuration();
            configuration1.put((Property)new PropertySimple("foo", (Object)"1"));
            configuration1.put((Property)new PropertySimple("fail", (Object)"false"));
            Configuration configuration2 = new Configuration();
            configuration2.put((Property)new PropertySimple("foo", (Object)"2"));
            configuration2.put((Property)new PropertySimple("fail", (Object)"false"));
            PluginConfigurationUpdate update1 = this.configurationManager.updatePluginConfiguration(overlord, resource1.getId(), configuration1);
            assert (update1.getErrorMessage() == null) : "We weren't expecting a failure here";
            PluginConfigurationUpdate update2 = this.configurationManager.updatePluginConfiguration(overlord, resource2.getId(), configuration2);
            assert (update2.getErrorMessage() == null) : "We weren't expecting a failure here";
            Configuration updatedConfiguration1 = this.configurationManager.getPluginConfiguration(overlord, resource1.getId());
            Configuration updatedConfiguration2 = this.configurationManager.getPluginConfiguration(overlord, resource2.getId());
            assert (updatedConfiguration1.equals((Object)configuration1)) : "configuration1 was: " + updatedConfiguration1 + ", " + "expected was: " + configuration1;
            assert (updatedConfiguration2.equals((Object)configuration2)) : "configuration2 was: " + updatedConfiguration2 + ", " + "expected was: " + configuration2;
            Configuration expectedGroupConfiguration = new Configuration();
            expectedGroupConfiguration.put((Property)new PropertySimple("foo", (Object)"~ Mixed Values ~"));
            expectedGroupConfiguration.put((Property)new PropertySimple("fail", (Object)"false"));
            List<Configuration> updatedConfigurations = Arrays.asList(updatedConfiguration1, updatedConfiguration2);
            Object groupConfiguration = null;
            assert (groupConfiguration.equals((Object)expectedGroupConfiguration)) : "group configuration was: " + groupConfiguration + ", " + "expected was: " + expectedGroupConfiguration;
            Configuration groupConfigurationOverride = new Configuration();
            PropertySimple propertySimple1 = new PropertySimple("foo", (Object)"3");
            PropertySimple propertySimple2 = new PropertySimple("fail", (Object)"true");
            groupConfigurationOverride.put((Property)propertySimple1);
            groupConfigurationOverride.put((Property)propertySimple2);
            Configuration expectedGroupConfigurationResults = new Configuration();
            expectedGroupConfigurationResults.put((Property)new PropertySimple("foo", (Object)"3"));
            propertySimple1.setOverride(Boolean.TRUE);
            if (failOnChildUpdates) {
                expectedGroupConfigurationResults.put((Property)new PropertySimple("fail", (Object)"true"));
                propertySimple2.setOverride(Boolean.TRUE);
            } else {
                expectedGroupConfigurationResults.put((Property)new PropertySimple("fail", (Object)"false"));
                propertySimple2.setOverride(Boolean.FALSE);
            }
            HashMap<Integer, Configuration> memberConfigs = new HashMap<Integer, Configuration>();
            memberConfigs.put(resource1.getId(), configuration1);
            memberConfigs.put(resource2.getId(), configuration2);
            int groupUpdateId = this.configurationManager.scheduleGroupPluginConfigurationUpdate(overlord, this.compatibleGroup.getId(), memberConfigs);
            GroupPluginConfigurationUpdate update = this.configurationManager.getGroupPluginConfigurationById(groupUpdateId);
            assert (update != null) : "Group plugin configuration update should not have been null";
            int i = 0;
            for (PluginConfigurationUpdate childUpdate : update.getConfigurationUpdates()) {
                Configuration childUpdateConfiguration = childUpdate.getConfiguration();
                assert (childUpdateConfiguration.equals((Object)expectedGroupConfigurationResults)) : "new updateChildConfig[" + i + "] was: " + childUpdateConfiguration + ", " + "expected was: " + expectedGroupConfigurationResults;
                ++i;
            }
            Configuration configurationAfterGroupUpdate1 = this.configurationManager.getPluginConfiguration(overlord, resource1.getId());
            Configuration configurationAfterGroupUpdate2 = this.configurationManager.getPluginConfiguration(overlord, resource2.getId());
            ConfigurationUpdateStatus expectedResultStatus = null;
            expectedResultStatus = failOnChildUpdates ? ConfigurationUpdateStatus.FAILURE : ConfigurationUpdateStatus.SUCCESS;
            assert (configurationAfterGroupUpdate1.equals((Object)expectedGroupConfigurationResults)) : "new config1 was: " + configurationAfterGroupUpdate1 + ", " + "expected was: " + expectedGroupConfigurationResults;
            assert (configurationAfterGroupUpdate2.equals((Object)expectedGroupConfigurationResults)) : "new config2 was: " + configurationAfterGroupUpdate2 + ", " + "expected was: " + expectedGroupConfigurationResults;
            assert (update.getStatus() == expectedResultStatus) : "Group plugin configuration update should have been marked as " + expectedResultStatus + ": " + update;
        }
        catch (Exception e) {
            e.printStackTrace();
            assert (false) : "Failed test with this exception: " + e;
        }
        finally {
            this.getTransactionManager().rollback();
            try {
                em.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testResourceConfigurationUpdateCallbackFailure() throws Exception {
        block27: {
            Resource resource = this.newResource1;
            try {
                Subject overlord = LookupUtil.getSubjectManager().getOverlord();
                Configuration configuration = new Configuration();
                configuration.put((Property)new PropertySimple("myboolean", (Object)"invalid-bool"));
                ResourceConfigurationUpdate history = new ResourceConfigurationUpdate(resource, configuration, "dummyuser");
                assert (history.getStatus().equals((Object)ConfigurationUpdateStatus.INPROGRESS));
                this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration);
                Thread.sleep(2000L);
                this.getTransactionManager().begin();
                EntityManager em = ConfigurationManagerBeanTest.getEntityManager();
                try {
                    resource = (Resource)em.find(Resource.class, (Object)resource.getId());
                    history = (ResourceConfigurationUpdate)resource.getResourceConfigurationUpdates().get(0);
                    assert (history.getStatus().equals((Object)ConfigurationUpdateStatus.FAILURE)) : "Status was " + history.getStatus();
                    assert (history.getErrorMessage() != null);
                    assert (history.getErrorMessage().indexOf("This simulates a failed update") > 0);
                    assert (history.getConfiguration() != null);
                    PropertySimple mybool = history.getConfiguration().getSimple("myboolean");
                    assert (mybool != null);
                    assert (mybool.getStringValue().equals("invalid-bool"));
                    assert (mybool.getErrorMessage().indexOf("Not a valid boolean") > 0);
                }
                finally {
                    this.getTransactionManager().rollback();
                    try {
                        em.close();
                    }
                    catch (Exception e) {}
                }
                assert (this.configurationManager.getLatestResourceConfigurationUpdate(overlord, resource.getId()) != null) : "Resource wasn't configured yet - but we should have populated it with live values";
                this.configurationManager.purgeResourceConfigurationUpdate(overlord, Integer.MIN_VALUE, false);
                this.configurationManager.purgeResourceConfigurationUpdate(overlord, history.getId(), false);
                this.getTransactionManager().begin();
                em = ConfigurationManagerBeanTest.getEntityManager();
                try {
                    resource = (Resource)em.find(Resource.class, (Object)resource.getId());
                    assert (resource.getResourceConfigurationUpdates().size() == 1);
                }
                finally {
                    this.getTransactionManager().rollback();
                    try {
                        em.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block27;
                throw new AssertionError((Object)("Failed test with this exception: " + e));
            }
        }
    }

    @Test(enabled=true)
    public void testResourceConfigurationUpdateCallbackSuccess() throws Exception {
        Resource resource = this.newResource1;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration configuration = new Configuration();
        configuration.put((Property)new PropertySimple("myboolean", (Object)"true"));
        ResourceConfigurationUpdate request = new ResourceConfigurationUpdate(resource, configuration, "dummyuser");
        assert (request.getStatus().equals((Object)ConfigurationUpdateStatus.INPROGRESS));
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration);
        Thread.sleep(2000L);
        ResourceConfigurationUpdateCriteria criteria = new ResourceConfigurationUpdateCriteria();
        criteria.addFilterResourceIds(new Integer[]{resource.getId()});
        criteria.fetchConfiguration(true);
        criteria.addSortCreatedTime(PageOrdering.ASC);
        PageList requests = this.configurationManager.findResourceConfigurationUpdatesByCriteria(overlord, criteria);
        assert (requests.size() == 1);
        assert (requests.get(0) != null);
        request = (ResourceConfigurationUpdate)requests.get(0);
        assert (request.getStatus().equals((Object)ConfigurationUpdateStatus.SUCCESS));
        assert (request.getErrorMessage() == null);
        assert (request.getConfiguration() != null);
        PropertySimple mybool = request.getConfiguration().getSimple("myboolean");
        assert (mybool != null);
        assert (mybool.getStringValue().equals("true"));
        assert (mybool.getErrorMessage() == null);
        ResourceConfigurationUpdate current = this.configurationManager.getLatestResourceConfigurationUpdate(overlord, resource.getId());
        assert (current != null);
        assert (current.getId() == request.getId());
        assert (current.getResource().equals((Object)resource));
        assert (current.getStatus().equals((Object)request.getStatus()));
        assert (current.getSubjectName().equals(request.getSubjectName()));
        assert (current.getCreatedTime() == request.getCreatedTime());
        assert (current.getModifiedTime() == request.getModifiedTime());
        assert (current.getConfiguration().getId() == request.getConfiguration().getId());
        Configuration live = this.configurationManager.getLiveResourceConfiguration(overlord, resource.getId(), false);
        assert (live != null);
        mybool = live.getSimple("myboolean");
        assert (mybool != null);
        assert ("true".equals(mybool.getStringValue()));
        assert (mybool.getErrorMessage() == null);
        this.configurationManager.purgeResourceConfigurationUpdate(overlord, Integer.MIN_VALUE, false);
        System.out.println("REQUEST WAS: " + request.toString());
        this.configurationManager.purgeResourceConfigurationUpdate(overlord, request.getId(), false);
        requests = this.configurationManager.findResourceConfigurationUpdates(overlord, Integer.valueOf(resource.getId()), null, null, false, this.configUpdatesPageControl);
        assert (requests.size() == 1);
    }

    @Test(enabled=true)
    public void testConfigurationRollback() throws Exception {
        Resource resource = this.newResource1;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration configuration1 = new Configuration();
        configuration1.put((Property)new PropertySimple("myboolean", (Object)"true"));
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration1);
        Thread.sleep(3000L);
        Configuration configuration2 = new Configuration();
        configuration2.put((Property)new PropertySimple("myboolean", (Object)"false"));
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration2);
        Thread.sleep(3000L);
        Configuration configuration3 = new Configuration();
        configuration3.put((Property)new PropertySimple("myboolean", (Object)"TRUE"));
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration3);
        Thread.sleep(3000L);
        ResourceConfigurationUpdateCriteria criteria = new ResourceConfigurationUpdateCriteria();
        criteria.addFilterResourceIds(new Integer[]{resource.getId()});
        criteria.fetchConfiguration(true);
        criteria.addSortCreatedTime(PageOrdering.ASC);
        PageList history = this.configurationManager.findResourceConfigurationUpdatesByCriteria(overlord, criteria);
        assert (history != null);
        assert (history.size() == 3);
        Configuration currentConfiguration = ((ResourceConfigurationUpdate)history.get(2)).getConfiguration();
        PropertySimple mybool = currentConfiguration.getSimple("myboolean");
        assert (mybool != null);
        ConfigurationManagerBeanTest.assertEquals((String)"TRUE", (String)mybool.getStringValue());
        Configuration rollbackToHere = ((ResourceConfigurationUpdate)history.get(1)).getConfiguration();
        mybool = rollbackToHere.getSimple("myboolean");
        assert (mybool != null);
        ConfigurationManagerBeanTest.assertEquals((String)"false", (String)mybool.getStringValue());
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), rollbackToHere);
        Thread.sleep(3000L);
        criteria = new ResourceConfigurationUpdateCriteria();
        criteria.addFilterResourceIds(new Integer[]{resource.getId()});
        criteria.fetchConfiguration(true);
        criteria.addSortCreatedTime(PageOrdering.ASC);
        history = this.configurationManager.findResourceConfigurationUpdatesByCriteria(overlord, criteria);
        assert (history != null);
        assert (history.size() == 4);
        ResourceConfigurationUpdate newConfigUpdate = (ResourceConfigurationUpdate)history.get(3);
        Configuration newConfiguration = newConfigUpdate.getConfiguration();
        assert (newConfiguration.getId() != rollbackToHere.getId());
        mybool = newConfiguration.getSimple("myboolean");
        assert (mybool != null);
        ConfigurationManagerBeanTest.assertEquals((String)"false", (String)mybool.getStringValue());
        assert (mybool.getErrorMessage() == null);
        ResourceConfigurationUpdate current = this.configurationManager.getLatestResourceConfigurationUpdate(overlord, resource.getId());
        assert (current != null);
        assert (current.getId() == newConfigUpdate.getId());
        assert (current.getResource().equals((Object)resource));
        assert (current.getStatus().equals((Object)newConfigUpdate.getStatus()));
        assert (current.getSubjectName().equals(newConfigUpdate.getSubjectName()));
        assert (current.getCreatedTime() == newConfigUpdate.getCreatedTime());
        assert (current.getModifiedTime() == newConfigUpdate.getModifiedTime());
        assert (current.getConfiguration().getId() == newConfigUpdate.getConfiguration().getId());
    }

    @Test(enabled=true)
    public void testPurgeConfigurationHistorySame() throws Exception {
        Resource resource = this.newResource1;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration configuration1 = new Configuration();
        configuration1.put((Property)new PropertySimple("myboolean", (Object)"true"));
        Configuration configuration2 = new Configuration();
        configuration2.put((Property)new PropertySimple("myboolean", (Object)"true"));
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration1);
        Thread.sleep(6000L);
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration2);
        Thread.sleep(6000L);
        PageList requests = this.configurationManager.findResourceConfigurationUpdates(overlord, Integer.valueOf(resource.getId()), null, null, false, this.configUpdatesPageControl);
        assert (requests != null);
        assert (requests.size() == 1) : "Got " + requests.size() + " config update requests - expected 1.";
    }

    @Test(enabled=true)
    public void testPurgeConfigurationHistoryDifferent() throws Exception {
        Resource resource = this.newResource1;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration configuration1 = new Configuration();
        configuration1.put((Property)new PropertySimple("myboolean", (Object)"true"));
        Configuration configuration2 = new Configuration();
        configuration2.put((Property)new PropertySimple("myboolean", (Object)"false"));
        ResourceConfigurationUpdate up = this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration1);
        Thread.sleep(2000L);
        assert (configuration1.equals((Object)this.configurationManager.getResourceConfiguration(resource.getId())));
        up = this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration2);
        Thread.sleep(2000L);
        assert (configuration2.equals((Object)this.configurationManager.getResourceConfiguration(resource.getId())));
        PageList requests = this.configurationManager.findResourceConfigurationUpdates(overlord, Integer.valueOf(resource.getId()), null, null, false, this.configUpdatesPageControl);
        assert (requests != null);
        assert (requests.size() == 2) : "Got " + requests.size() + " config update requests - expected 2.";
        ResourceConfigurationUpdate doomedRequest = (ResourceConfigurationUpdate)requests.get(0);
        ResourceConfigurationUpdate savedRequest = (ResourceConfigurationUpdate)requests.get(1);
        this.configurationManager.purgeResourceConfigurationUpdates(overlord, new int[]{doomedRequest.getId()}, false);
        requests = this.configurationManager.findResourceConfigurationUpdates(overlord, Integer.valueOf(resource.getId()), null, null, false, this.configUpdatesPageControl);
        assert (requests.size() == 1);
        assert (((ResourceConfigurationUpdate)requests.get(0)).getId() == savedRequest.getId());
    }

    @Test(enabled=true)
    public void testPurgeConfigurationHistoryWithFailedUpdateRequest() throws Exception {
        Resource resource = this.newResource1;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration configuration1 = new Configuration();
        configuration1.put((Property)new PropertySimple("myboolean", (Object)"invalid-boolean"));
        Configuration configuration2 = new Configuration();
        configuration2.put((Property)new PropertySimple("myboolean", (Object)"true"));
        Configuration activeConfigurationBefore = this.configurationManager.getResourceConfiguration(resource.getId());
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration1);
        Thread.sleep(2000L);
        Configuration activeConfigurationAfter = this.configurationManager.getResourceConfiguration(resource.getId());
        assert (activeConfigurationBefore.equals((Object)activeConfigurationAfter)) : "ActiveResourceConfiguration was not supposed to change for a failed update -- old was: " + activeConfigurationBefore + ", new was: " + activeConfigurationAfter;
        this.configurationManager.updateResourceConfiguration(overlord, resource.getId(), configuration2);
        Thread.sleep(2000L);
        Configuration activeConfiguration = this.configurationManager.getResourceConfiguration(resource.getId());
        assert (activeConfiguration != null) : "ActiveResourceConfiguration was not updated with configuration2";
        Map activeProperties = activeConfiguration.getSimpleProperties();
        assert (activeProperties.size() == 1);
        assert (activeProperties.containsKey("myboolean"));
        PropertySimple activeProperty = (PropertySimple)activeProperties.get("myboolean");
        assert (activeProperty.getName().equals("myboolean"));
        assert ("true".equals(activeProperty.getStringValue()));
        PageList requests = this.configurationManager.findResourceConfigurationUpdates(overlord, Integer.valueOf(resource.getId()), null, null, false, this.configUpdatesPageControl);
        assert (requests != null);
        assert (requests.size() == 2);
        assert (((ResourceConfigurationUpdate)requests.get(0)).getStatus() == ConfigurationUpdateStatus.FAILURE) : "actual: " + ((ResourceConfigurationUpdate)requests.get(0)).getStatus();
        assert (((ResourceConfigurationUpdate)requests.get(1)).getStatus() == ConfigurationUpdateStatus.SUCCESS) : "actual: " + ((ResourceConfigurationUpdate)requests.get(1)).getStatus();
        ResourceConfigurationUpdate savedRequest = (ResourceConfigurationUpdate)requests.get(0);
        ResourceConfigurationUpdate doomedRequest = (ResourceConfigurationUpdate)requests.get(1);
        this.configurationManager.purgeResourceConfigurationUpdate(overlord, doomedRequest.getId(), false);
        ResourceConfigurationUpdateCriteria criteria = new ResourceConfigurationUpdateCriteria();
        criteria.addFilterResourceIds(new Integer[]{resource.getId()});
        criteria.fetchConfiguration(true);
        criteria.addSortCreatedTime(PageOrdering.ASC);
        requests = this.configurationManager.findResourceConfigurationUpdatesByCriteria(overlord, criteria);
        assert (requests.size() == 1);
        ResourceConfigurationUpdate request = (ResourceConfigurationUpdate)requests.get(0);
        assert (request.getId() == savedRequest.getId());
        assert (request.getStatus().equals((Object)ConfigurationUpdateStatus.FAILURE));
        assert (request.getErrorMessage() != null);
        assert (request.getErrorMessage().indexOf("This simulates a failed update") > 0);
        assert (request.getConfiguration() != null);
        PropertySimple mybool = request.getConfiguration().getSimple("myboolean");
        assert (mybool != null);
        assert (mybool.getStringValue().equals("invalid-boolean"));
        assert (mybool.getErrorMessage().indexOf("Not a valid boolean") > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNoPermissionCallback() throws Exception {
        Subject superuser = LookupUtil.getSubjectManager().getOverlord();
        Subject noPermSubject = new Subject("userWithNoPermissions", true, false);
        Resource resource = this.newResource1;
        try {
            noPermSubject = LookupUtil.getSubjectManager().createSubject(superuser, noPermSubject);
            noPermSubject = this.createSession(noPermSubject);
            try {
                this.configurationManager.updateResourceConfiguration(noPermSubject, resource.getId(), new Configuration());
                assert (false) : "Should not have been updated - user didn't have permissions";
            }
            catch (PermissionException expected) {
                System.out.println("This was expected and OK:\n" + (Object)((Object)expected));
            }
            try {
                this.configurationManager.updatePluginConfiguration(noPermSubject, resource.getId(), new Configuration());
                assert (false) : "Should not have been updated - user didn't have permissions";
            }
            catch (PermissionException expected) {
                System.out.println("This was expected and OK:\n" + (Object)((Object)expected));
                expected.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            LookupUtil.getSubjectManager().deleteUsers(LookupUtil.getSubjectManager().getOverlord(), new int[]{noPermSubject.getId()});
            throw throwable;
        }
        LookupUtil.getSubjectManager().deleteUsers(LookupUtil.getSubjectManager().getOverlord(), new int[]{noPermSubject.getId()});
    }

    @Test(enabled=true)
    public void testInvalidUpdateCallback() throws Exception {
        ConfigurationUpdateResponse response = new ConfigurationUpdateResponse(Integer.MAX_VALUE, new Configuration(), ConfigurationUpdateStatus.SUCCESS, null);
        try {
            this.configurationManager.completeResourceConfigurationUpdate(response);
            assert (false) : "Should not have been able to process an unknown request - we didn't persist it yet";
        }
        catch (Exception expected) {
            System.out.println("This was expected and OK:\n" + expected);
        }
    }

    void persist(Object entity) throws Exception {
        EntityManager entityMgr = ConfigurationManagerBeanTest.getEntityManager();
        ConfigurationManagerBeanTest.getEntityManager().persist(entity);
        entityMgr.flush();
        entityMgr.clear();
    }

    void delete(Configuration configuration) {
        EntityManager entityMgr = ConfigurationManagerBeanTest.getEntityManager();
        Configuration managedConfig = (Configuration)entityMgr.find(Configuration.class, (Object)configuration.getId());
        entityMgr.remove((Object)managedConfig);
    }

    private class TestServices
    implements ConfigurationAgentService,
    DiscoveryAgentService {
        private Configuration savedConfiguration = null;

        private TestServices() {
        }

        public ConfigurationUpdateResponse executeUpdateResourceConfigurationImmediately(ConfigurationUpdateRequest request) throws PluginContainerException {
            return null;
        }

        public AvailabilityReport executeAvailabilityScanImmediately(boolean changedOnlyReport) {
            return null;
        }

        public void updateResourceConfiguration(final ConfigurationUpdateRequest request) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        ConfigurationUpdateResponse response;
                        PropertySimple mysleep = request.getConfiguration().getSimple("mysleep");
                        PropertySimple mybool = request.getConfiguration().getSimple("myboolean");
                        assert (mybool != null);
                        if (mybool.getStringValue().equalsIgnoreCase("true")) {
                            TestServices.this.savedConfiguration = request.getConfiguration();
                            if (mysleep != null) {
                                Thread.sleep(mysleep.getLongValue());
                            }
                            response = new ConfigurationUpdateResponse(request.getConfigurationUpdateId(), null, ConfigurationUpdateStatus.SUCCESS, null);
                        } else if (mybool.getStringValue().equalsIgnoreCase("false")) {
                            TestServices.this.savedConfiguration = request.getConfiguration();
                            if (mysleep != null) {
                                Thread.sleep(mysleep.getLongValue());
                            }
                            response = new ConfigurationUpdateResponse(request.getConfigurationUpdateId(), null, ConfigurationUpdateStatus.SUCCESS, null);
                        } else {
                            mybool.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)new IllegalArgumentException("Not a valid boolean")));
                            response = new ConfigurationUpdateResponse(request.getConfigurationUpdateId(), request.getConfiguration(), (Throwable)new NullPointerException("This simulates a failed update"));
                        }
                        LookupUtil.getConfigurationManager().completeResourceConfigurationUpdate(response);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new RuntimeException(t);
                    }
                }
            };
            thread.start();
        }

        public void updatePluginConfiguration(int resourceId, Configuration newPluginConfiguration) throws InvalidPluginConfigurationClientException, PluginContainerException {
            PropertySimple mybool = newPluginConfiguration.getSimple("fail");
            if (mybool != null && mybool.getBooleanValue().booleanValue()) {
                throw new PluginContainerException("Simulates a failure to update plugin config");
            }
        }

        public ResourceConfigurationUpdate createResource(Resource parent, ResourceType resourceType, ResourceConfigurationUpdate configuration) throws PluginContainerException {
            return null;
        }

        public void deleteResource(Resource resource) throws PluginContainerException {
        }

        public Configuration loadResourceConfiguration(int resourceId) throws PluginContainerException {
            return this.savedConfiguration;
        }

        public Configuration loadResourceConfiguration(int resourceId, boolean fromStructured) throws PluginContainerException {
            return this.savedConfiguration;
        }

        public Configuration merge(Configuration configuration, int resourceId, boolean fromStructured) throws PluginContainerException {
            return null;
        }

        public void disableServiceScans(int serverResourceId) {
        }

        public void enableServiceScans(int serverResourceId, Configuration config) {
        }

        public InventoryReport executeServerScanImmediately() throws PluginContainerException {
            return null;
        }

        public InventoryReport executeServiceScanImmediately() throws PluginContainerException {
            return null;
        }

        public void executeServiceScanDeferred() {
        }

        public Availability getCurrentAvailability(Resource resource) {
            return null;
        }

        public MergeResourceResponse manuallyAddResource(ResourceType resourceType, int parentResourceId, Configuration pluginConfiguration, int ownerSubjectId) throws InvalidPluginConfigurationClientException, PluginContainerException {
            return null;
        }

        public Resource getPlatform() {
            return null;
        }

        public InventoryReport getPlatformScanResults(long jobId) {
            return null;
        }

        public long startPlatformScan(Configuration config) {
            return 0L;
        }

        public boolean stopPlatformScan(long jobId) {
            return false;
        }

        public void uninventoryResource(int resourceId) {
        }

        @Asynchronous(guaranteedDelivery=true)
        public void synchronizeInventory(ResourceSyncInfo syncInfo) {
        }

        public Configuration validate(Configuration configuration, int resourceId, boolean isStructured) throws PluginContainerException {
            return null;
        }
    }
}

