/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.configuration.DynamicConfigurationPropertyValue;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.configuration.DynamicConfigurationPropertyLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DynamicConfigurationPropertyBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLED = true;
    private DynamicConfigurationPropertyLocal bean;

    @BeforeMethod
    public void setUp() {
        this.bean = LookupUtil.getDynamicConfigurationProperty();
    }

    @Test(enabled=true)
    public void invalidKey() throws Exception {
        List stringList = this.bean.lookupValues("foo");
        assert (stringList != null);
        assert (stringList.size() == 0);
    }

    @Test(enabled=true)
    public void user() throws Exception {
        String queryString = "SELECT s FROM Subject s WHERE s.fsystem = false";
        int existingUserCount = this.countForQuery(queryString, false);
        List users = this.bean.lookupValues("users");
        this.outputList(users);
        assert (users.size() == existingUserCount) : "Expected: " + existingUserCount + ", Found: " + users.size();
    }

    @Test(enabled=true)
    public void roles() throws Exception {
        int existingRoleCount = this.countForQuery("Role.findAll");
        List roles = this.bean.lookupValues("roles");
        this.outputList(roles);
        assert (roles.size() == existingRoleCount) : "Expected: " + existingRoleCount + ", Found: " + roles.size();
    }

    @Test(enabled=true)
    public void packageType() throws Exception {
        block7: {
            TransactionManager tx;
            PackageType packageType;
            ResourceType resourceType;
            block6: {
                resourceType = null;
                packageType = null;
                tx = this.getTransactionManager();
                try {
                    tx.begin();
                    EntityManager entityManager = DynamicConfigurationPropertyBeanTest.getEntityManager();
                    resourceType = new ResourceType("dynamicConfigPropBeanTestType", "foo", ResourceCategory.PLATFORM, null);
                    entityManager.persist((Object)resourceType);
                    packageType = new PackageType("dynamicConfigPropBeanTestType", resourceType);
                    entityManager.persist((Object)packageType);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx.getStatus() != 0) break block6;
                    tx.rollback();
                }
            }
            int existingPackageTypes = this.countForQuery("PackageType.findAll");
            assert (existingPackageTypes > 0) : "Package type created in setup was not written correctly";
            List types = this.bean.lookupValues("package-types");
            assert (types.size() == existingPackageTypes) : "Expected: " + existingPackageTypes + ", Found: " + types.size();
            tx = this.getTransactionManager();
            try {
                tx.begin();
                EntityManager entityManager = DynamicConfigurationPropertyBeanTest.getEntityManager();
                resourceType = (ResourceType)entityManager.find(ResourceType.class, (Object)resourceType.getId());
                entityManager.remove((Object)resourceType);
                packageType = (PackageType)entityManager.find(PackageType.class, (Object)packageType.getId());
                entityManager.remove((Object)packageType);
                tx.commit();
            }
            catch (Exception e) {
                if (tx.getStatus() != 0) break block7;
                tx.rollback();
            }
        }
    }

    private int countForQuery(String queryName) throws NotSupportedException, SystemException {
        return this.countForQuery(queryName, true);
    }

    private int countForQuery(String queryString, boolean isName) throws NotSupportedException, SystemException {
        this.getTransactionManager().begin();
        EntityManager entityManager = DynamicConfigurationPropertyBeanTest.getEntityManager();
        Query query = isName ? entityManager.createNamedQuery(queryString) : entityManager.createQuery(queryString);
        List existing = query.getResultList();
        int count = existing.size();
        this.getTransactionManager().rollback();
        return count;
    }

    private void outputList(List<DynamicConfigurationPropertyValue> items) {
        System.out.println("Items returned from lookupValues:");
        for (DynamicConfigurationPropertyValue item : items) {
            System.out.println(item);
        }
    }
}

