/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.test.LargeGroupTestBase;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class LargeGroupPluginConfigurationTest
extends LargeGroupTestBase {
    private LargeGroupTestBase.LargeGroupEnvironment env;
    private CountDownLatch latch;

    @Override
    protected void setupMockAgentServices(TestServerCommunicationsService agentServiceContainer) {
        TestServices testServices = new TestServices();
        agentServiceContainer.discoveryService = testServices;
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.env = this.createLargeGroupWithNormalUserRoleAccess(1010, Permission.MODIFY_RESOURCE);
        SessionTestHelper.simulateLogin(this.env.normalSubject);
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        this.tearDownLargeGroupWithNormalUserRoleAccess(this.env);
        SessionTestHelper.simulateLogout(this.env.normalSubject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupPluginConfigurationUpdate() throws Exception {
        int memberCount = this.env.platformResource.getChildResources().size();
        System.out.println("Getting plugin config for group [#members=" + memberCount + "]");
        long start = System.currentTimeMillis();
        Map existingMap = this.configurationManager.getPluginConfigurationsForCompatibleGroup(this.env.normalSubject, this.env.compatibleGroup.getId());
        long duration = System.currentTimeMillis() - start;
        System.out.println("Took [" + duration + "]ms to get plugin config for group [#members=" + memberCount + "]");
        assert (existingMap.size() == memberCount) : "did not get back the amount of configs [" + existingMap.size() + "] we expected [" + memberCount + "]";
        for (Map.Entry entry : existingMap.entrySet()) {
            Integer resourceId = (Integer)entry.getKey();
            Configuration config = (Configuration)entry.getValue();
            assert ("LargeGroupTest pc property one".equals(config.getSimpleValue("LargeGroupTest pc prop1", null))) : "bad plugin config for " + resourceId + "=" + config.toString(true);
            assert (resourceId.toString().equals(config.getSimpleValue("LargeGroupTest pc prop2", null))) : "bad plugin config for " + resourceId + "=" + config.toString(true);
            config.getSimple("LargeGroupTest pc prop2").setStringValue("UPDATE" + resourceId);
        }
        System.out.println("Scheduling a group plugin update.");
        this.latch = new CountDownLatch(memberCount);
        int groupUpdateId = this.configurationManager.scheduleGroupPluginConfigurationUpdate(this.env.normalSubject, this.env.compatibleGroup.getId(), existingMap);
        System.out.print("Waiting for mock agents");
        assert (this.latch.await(5L, TimeUnit.MINUTES)) : "agents should not have taken this long";
        System.out.println(" Mock agents are done.");
        System.out.print("Waiting for group plugin config update to be finished...");
        ConfigurationUpdateStatus status = this.getGroupPluginConfigurationStatus(this.env.compatibleGroup.getId());
        boolean inprogress = status == ConfigurationUpdateStatus.INPROGRESS;
        for (int i = 0; i < 20 && inprogress; ++i) {
            Thread.sleep(3000L);
            status = this.getGroupPluginConfigurationStatus(this.env.compatibleGroup.getId());
            inprogress = status == ConfigurationUpdateStatus.INPROGRESS;
        }
        assert (!inprogress) : "group plugin configuration update is still inprogress - this is taking too long";
        System.out.println(" Done. Status=" + (status != null ? status.name() : "????null????"));
        assert (status == ConfigurationUpdateStatus.SUCCESS) : "should have finished in the success status";
        System.out.println("Getting updated plugin config for group [#members=" + memberCount + "]");
        start = System.currentTimeMillis();
        existingMap = this.configurationManager.getPluginConfigurationsForCompatibleGroup(this.env.normalSubject, this.env.compatibleGroup.getId());
        duration = System.currentTimeMillis() - start;
        System.out.println("Took [" + duration + "]ms to get updated plugin config for group [#members=" + memberCount + "]");
        assert (existingMap.size() == memberCount) : "did not get back the amount of configs [" + existingMap.size() + "] we expected [" + memberCount + "]";
        for (Map.Entry entry : existingMap.entrySet()) {
            Integer resourceId = (Integer)entry.getKey();
            Configuration config = (Configuration)entry.getValue();
            assert ("LargeGroupTest pc property one".equals(config.getSimpleValue("LargeGroupTest pc prop1", null))) : "bad plugin config for " + resourceId + "=" + config.toString(true);
            assert (("UPDATE" + resourceId.toString()).equals(config.getSimpleValue("LargeGroupTest pc prop2", null))) : "bad plugin config for " + resourceId + "=" + config.toString(true);
        }
        System.out.println("Attempting unauthz access");
        SessionTestHelper.simulateLogin(this.env.unauthzSubject);
        start = System.currentTimeMillis();
        try {
            this.configurationManager.getPluginConfigurationsForCompatibleGroup(this.env.unauthzSubject, this.env.compatibleGroup.getId());
            assert (false) : "should have failed - unauthz user not allowed to get plugin configuration";
        }
        catch (PermissionException expected) {
        }
        finally {
            duration = System.currentTimeMillis() - start;
            SessionTestHelper.simulateLogout(this.env.unauthzSubject);
        }
        System.out.println("Took [" + duration + "]ms to attempt unauthz access");
    }

    private class TestServices
    implements DiscoveryAgentService {
        private TestServices() {
        }

        public void updatePluginConfiguration(int resourceId, Configuration newPluginConfiguration) throws InvalidPluginConfigurationClientException, PluginContainerException {
            LargeGroupPluginConfigurationTest.this.latch.countDown();
            long latchCount = LargeGroupPluginConfigurationTest.this.latch.getCount();
            System.out.print(latchCount % 100L != 0L ? "." : String.valueOf(latchCount));
        }

        public AvailabilityReport executeAvailabilityScanImmediately(boolean changedOnlyReport) {
            return null;
        }

        public Availability getCurrentAvailability(Resource resource) {
            return null;
        }

        public InventoryReport executeServerScanImmediately() throws PluginContainerException {
            return null;
        }

        public InventoryReport executeServiceScanImmediately() throws PluginContainerException {
            return null;
        }

        public void executeServiceScanDeferred() {
        }

        public Resource getPlatform() {
            return null;
        }

        public MergeResourceResponse manuallyAddResource(ResourceType resourceType, int parentResourceId, Configuration pluginConfiguration, int creatorSubjectId) throws InvalidPluginConfigurationClientException, PluginContainerException {
            return null;
        }

        public void synchronizeInventory(ResourceSyncInfo syncInfo) {
        }

        public void uninventoryResource(int resourceId) {
        }

        public void disableServiceScans(int serverResourceId) {
        }

        public void enableServiceScans(int serverResourceId, Configuration config) {
        }
    }
}

