/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration.metadata;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.transaction.SystemException;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.shared.PluginDescriptorUtil;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.domain.configuration.definition.PropertyOptionsSource;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.AssertUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ConfigurationMetadataManagerBeanTest
extends AbstractEJB3Test {
    PluginDescriptor originalDescriptor;
    PluginDescriptor updatedDescriptor;
    ConfigurationDefinition originalConfigDef;
    ConfigurationDefinition updatedConfigDef;

    @BeforeClass
    public void setupClass() {
        String pluginFileBaseName = "configuration_metadata_manager_bean_test";
        String version1 = pluginFileBaseName + "_v1.xml";
        String version2 = pluginFileBaseName + "_v2.xml";
        this.originalDescriptor = PluginDescriptorUtil.loadPluginDescriptor((URL)((Object)((Object)this)).getClass().getResource(version1));
        this.updatedDescriptor = PluginDescriptorUtil.loadPluginDescriptor((URL)((Object)((Object)this)).getClass().getResource(version2));
    }

    @Test
    public void addNewUngroupedSimplePropertyDef() {
        this.initConfigDefs("servers[name='MyServer1']", "test");
        String propertyName = "newUngroupedProperty";
        PropertyDefinitionSimple expected = this.updatedConfigDef.getPropertyDefinitionSimple(propertyName);
        PropertyDefinitionSimple actual = this.originalConfigDef.getPropertyDefinitionSimple(propertyName);
        this.assertPropertyDefinitionMatches("New ungrouped property defs should be added to the configuration definition", (PropertyDefinition)expected, (PropertyDefinition)actual);
    }

    @Test
    public void removePropertyDefThatIsNotInNewDescriptor() {
        this.initConfigDefs("servers[name='MyServer1']", "test");
        ConfigurationMetadataManagerBeanTest.assertNull((String)"The property exists in version 1 but not in version 2 of the plugin; therefore, it should be removed the configuration definition", (Object)this.originalConfigDef.get("v1OnlyProperty"));
    }

    @Test
    public void doNotModifyExistingPropertyDefThatIsNotModifiedInUpgrade() {
        this.initConfigDefs("servers[name='MyServer1']", "test");
        String propertyName = "myExistingProperty";
        PropertyDefinitionSimple expected = this.updatedConfigDef.getPropertyDefinitionSimple(propertyName);
        PropertyDefinitionSimple actual = this.originalConfigDef.getPropertyDefinitionSimple(propertyName);
        this.assertPropertyDefinitionMatches("Existing property that is not changed in new version of pluign should not change", (PropertyDefinition)expected, (PropertyDefinition)actual);
    }

    @Test
    public void updatePropertyWithAddedOptions() {
        this.initConfigDefs("servers[name='ServerWithAddedOptions']", "UpdatedPropertyWithAddedOptions");
        String propertyName = "mySimple";
        PropertyDefinitionSimple expectedProperty = this.updatedConfigDef.getPropertyDefinitionSimple(propertyName);
        List expected = expectedProperty.getEnumeratedValues();
        PropertyDefinitionSimple actualProperty = this.originalConfigDef.getPropertyDefinitionSimple(propertyName);
        List actual = actualProperty.getEnumeratedValues();
        AssertUtils.assertCollectionEqualsNoOrder((Collection)expected, (Collection)actual, (String)"Options should have been added to property");
    }

    @Test
    public void addNewGroup() {
        this.initConfigDefs("servers[name='GroupTests']", "GroupTests");
        ConfigurationMetadataManagerBeanTest.assertNotNull((String)"The new property should be added to the configuration definition", (Object)this.findGroup("newGroup", this.originalConfigDef));
    }

    @Test
    public void replaceMemberDefinitionOfPropertyList() {
        this.initConfigDefs("servers[name='UpdatedPropertyList']", "ReplaceMemberDefinitionOfPropertyList");
        String propertyName = "myList";
        PropertyDefinitionList expectedList = this.updatedConfigDef.getPropertyDefinitionList(propertyName);
        PropertyDefinitionList actualList = this.originalConfigDef.getPropertyDefinitionList(propertyName);
        this.assertPropertyDefinitionMatches("The member definition should be replaced with the new version", (PropertyDefinition)expectedList, (PropertyDefinition)actualList);
    }

    @Test(enabled=false)
    public void updateMapWithRemovedProperty() {
        this.initConfigDefs("servers[name='UpdatedMapWithRemovedProperty']", "UpdateMapWithRemovedProperty");
        String propertyName = "myMap";
        PropertyDefinitionMap map = this.originalConfigDef.getPropertyDefinitionMap(propertyName);
        ConfigurationMetadataManagerBeanTest.assertEquals((String)"Expected property to be removed when it is removed from parent map", (int)0, (int)map.getPropertyDefinitions().size());
    }

    @Test
    public void updateMapWithUpdatedProperty() {
        this.initConfigDefs("servers[name='UpdatedMapWithUpdatedProperty']", "UpdateMapWithUpdatedProperty");
        String propertyName = "propertyToUpdate";
        String mapPropertyName = "myMap";
        PropertyDefinitionMap expectedMap = this.updatedConfigDef.getPropertyDefinitionMap(mapPropertyName);
        PropertyDefinitionSimple expected = expectedMap.getPropertyDefinitionSimple(propertyName);
        PropertyDefinitionMap actualMap = this.originalConfigDef.getPropertyDefinitionMap(mapPropertyName);
        PropertyDefinitionSimple actual = actualMap.getPropertyDefinitionSimple(propertyName);
        List<String> ignoredProperties = Arrays.asList("id", "parentPropertyMapDefinition");
        this.assertPropertyDefinitionMatches("Expected property who is a child of map to get updated and remain in the map", (PropertyDefinition)expected, (PropertyDefinition)actual, ignoredProperties);
    }

    @Test
    public void updatePropertyDefinitionOptionSource() {
        this.initConfigDefs("servers[name='OptionSourceTest']", "OptionSourceTest");
        PropertyDefinitionSimple prop1 = (PropertyDefinitionSimple)this.updatedConfigDef.get("prop1");
        assert (prop1 != null);
        assert (prop1.getEnumeratedValues().size() == 0) : "Found an option value. ";
        PropertyOptionsSource source = prop1.getOptionsSource();
        assert (source != null) : "PropertyOptionSource was not persisted";
        assert (source.getFilter() == null) : "Assumed filter to be null, but was " + source.getFilter();
        PropertyDefinitionSimple prop2 = (PropertyDefinitionSimple)this.updatedConfigDef.get("prop2");
        assert (prop2 != null);
        assert (prop2.getEnumeratedValues().size() == 1);
        assert (prop2.getOptionsSource() != null);
        assert (prop2.getOptionsSource().getExpression().equals("*"));
    }

    private void initConfigDefs(String path, String configName) {
        this.loadAndPersistConfigDefs(path, configName);
        this.updateConfigDef();
    }

    private void loadAndPersistConfigDefs(String path, String configName) {
        this.originalConfigDef = PluginDescriptorUtil.loadPluginConfigDefFor((PluginDescriptor)this.originalDescriptor, (String)path, (String)configName);
        ConfigurationMetadataManagerBeanTest.assertNotNull((Object)this.originalConfigDef);
        this.updatedConfigDef = PluginDescriptorUtil.loadPluginConfigDefFor((PluginDescriptor)this.updatedDescriptor, (String)path, (String)configName);
        ConfigurationMetadataManagerBeanTest.assertNotNull((Object)this.updatedConfigDef);
        try {
            this.getTransactionManager().begin();
            EntityManager entityMgr = ConfigurationMetadataManagerBeanTest.getEntityManager();
            entityMgr.persist((Object)this.originalConfigDef);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                this.getTransactionManager().rollback();
            }
            catch (SystemException e1) {
                throw new RuntimeException(e1);
            }
            throw new RuntimeException(e);
        }
    }

    private void updateConfigDef() {
        ConfigurationMetadataManagerLocal configMetadataMgr = LookupUtil.getConfigurationMetadataManager();
        configMetadataMgr.updateConfigurationDefinition(this.updatedConfigDef, this.originalConfigDef);
    }

    private String getPackagePath() {
        return "/" + ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/";
    }

    private PropertyGroupDefinition findGroup(String name, ConfigurationDefinition configDef) {
        for (PropertyGroupDefinition groupDef : configDef.getGroupDefinitions()) {
            if (!groupDef.getName().equals(name)) continue;
            return groupDef;
        }
        return null;
    }

    void assertPropertyDefinitionMatches(String msg, PropertyDefinition expected, PropertyDefinition actual) {
        AssertUtils.assertPropertiesMatch((String)msg, (Object)expected, (Object)actual, (String[])new String[]{"id", "configurationDefinition"});
    }

    void assertPropertyDefinitionMatches(String msg, PropertyDefinition expected, PropertyDefinition actual, List<String> ignoredProperties) {
        AssertUtils.assertPropertiesMatch((String)msg, (Object)expected, (Object)actual, ignoredProperties);
    }
}

