/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.metadata.test;

import java.net.URL;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.metadata.ContentSourcePluginMetadataManager;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.content.ContentPluginDescriptorType;
import org.testng.annotations.BeforeClass;

public class TestBase
extends AbstractEJB3Test {
    protected ContentSourceMetadataManagerLocal metadataManager;

    @BeforeClass
    protected void beforeClass() {
        try {
            this.metadataManager = LookupUtil.getContentSourceMetadataManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentSourceType getContentSourceType(String typeName) throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = TestBase.getEntityManager();
        try {
            ContentSourceType type;
            Query q = em.createNamedQuery("ContentSourceType.findByNameWithConfigDef");
            ContentSourceType contentSourceType = type = (ContentSourceType)q.setParameter("name", (Object)typeName).getSingleResult();
            return contentSourceType;
        }
        catch (NoResultException nre) {
            ContentSourceType contentSourceType = null;
            return contentSourceType;
        }
        finally {
            this.getTransactionManager().rollback();
            em.close();
        }
    }

    protected void registerPlugin(String pathToDescriptor) throws Exception {
        ContentPluginDescriptorType descriptor = this.loadPluginDescriptor(pathToDescriptor);
        ContentSourcePluginMetadataManager mm = new ContentSourcePluginMetadataManager();
        mm.loadPlugin(descriptor);
        this.metadataManager.registerTypes(mm.getAllContentSourceTypes());
    }

    public ContentPluginDescriptorType loadPluginDescriptor(String descriptorFile) throws Exception {
        URL descriptorUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(descriptorFile);
        Unmarshaller unmarshaller = ServerPluginDescriptorUtil.getServerPluginDescriptorUnmarshaller();
        return (ContentPluginDescriptorType)((JAXBElement)unmarshaller.unmarshal(descriptorUrl.openStream())).getValue();
    }
}

