/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.ProductVersionPackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoPackageVersion;
import org.rhq.core.domain.content.ResourceRepo;
import org.rhq.core.domain.content.composite.PackageVersionComposite;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ContentUIManagerBeanEligiblePackagesTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = true;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ContentUIManagerLocal contentUIManager;
    private SubjectManagerLocal subjectManager;
    private Architecture architecture;
    private PackageType packageType1;
    private Package package1;
    private Package package2;
    private Package package3;
    private Package package4;
    private RepoPackageVersion repoPackageVersion1;
    private RepoPackageVersion repoPackageVersion2;
    private RepoPackageVersion repoPackageVersion3;
    private RepoPackageVersion repoPackageVersion4;
    private InstalledPackage installedPackage1;
    private Resource resource;
    private ResourceType resourceType;
    private Repo repo1;
    private Repo repo2;
    private ResourceRepo resourceRepo1;
    private ResourceRepo resourceRepo2;
    private ProductVersion productVersion1;
    private ProductVersion productVersion2;

    @BeforeClass
    public void setupBeforeClass() throws Exception {
        this.contentUIManager = LookupUtil.getContentUIManager();
        this.subjectManager = LookupUtil.getSubjectManager();
    }

    @BeforeMethod
    public void populateDatabase() throws Exception {
        this.setupTestEnvironment();
    }

    @AfterMethod
    public void cleanDatabase() throws Exception {
        this.tearDownTestEnvironment();
    }

    @Test(enabled=true)
    public void testEligiblePackagesLogic() throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        PageControl pageControl = new PageControl(0, 100);
        PageList pageList = this.contentUIManager.getPackageVersionCompositesByFilter(overlord, this.resource.getId(), null, pageControl);
        assert (pageList != null) : "Null page list returned from query";
        for (PackageVersionComposite pvc : pageList.getValues()) {
            this.log.warn((Object)("Package: " + pvc.getPackageName()));
        }
        assert (pageList.getTotalSize() == 2) : "Incorrect total size found. Found: " + pageList.getTotalSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ContentUIManagerBeanEligiblePackagesTest.getEntityManager();
        try {
            try {
                this.architecture = (Architecture)em.find(Architecture.class, (Object)1);
                this.resourceType = new ResourceType("resourcetype-" + System.currentTimeMillis(), "TestPlugin", ResourceCategory.PLATFORM, null);
                em.persist((Object)this.resourceType);
                this.resource = new Resource("parent" + System.currentTimeMillis(), "name", this.resourceType);
                this.resource.setUuid("" + new Random().nextInt());
                this.resource.setVersion("1.0");
                em.persist((Object)this.resource);
                this.productVersion1 = new ProductVersion();
                this.productVersion1.setVersion("1.0");
                this.productVersion1.setResourceType(this.resourceType);
                em.persist((Object)this.productVersion1);
                this.resource.setProductVersion(this.productVersion1);
                this.productVersion2 = new ProductVersion();
                this.productVersion2.setVersion("2.0");
                this.productVersion2.setResourceType(this.resourceType);
                em.persist((Object)this.productVersion2);
                this.packageType1 = new PackageType();
                this.packageType1.setName("package1-" + System.currentTimeMillis());
                this.packageType1.setDescription("");
                this.packageType1.setCategory(PackageCategory.DEPLOYABLE);
                this.packageType1.setDisplayName("TestResourcePackage");
                this.packageType1.setCreationData(true);
                this.packageType1.setResourceType(this.resourceType);
                em.persist((Object)this.packageType1);
                this.resourceType.addPackageType(this.packageType1);
                this.package1 = new Package("Package1", this.packageType1);
                PackageVersion packageVersion1 = new PackageVersion(this.package1, "1.0.0", this.architecture);
                this.package1.addVersion(packageVersion1);
                em.persist((Object)this.package1);
                this.package2 = new Package("Package2", this.packageType1);
                PackageVersion packageVersion2 = new PackageVersion(this.package2, "1.0.0", this.architecture);
                ProductVersionPackageVersion pvpv1 = packageVersion2.addProductVersion(this.productVersion1);
                ProductVersionPackageVersion pvpv2 = packageVersion2.addProductVersion(this.productVersion2);
                this.package2.addVersion(packageVersion2);
                em.persist((Object)this.package2);
                em.persist((Object)pvpv1);
                em.persist((Object)pvpv2);
                this.package3 = new Package("Package3", this.packageType1);
                PackageVersion packageVersion3 = new PackageVersion(this.package3, "1.0.0", this.architecture);
                ProductVersionPackageVersion pvpv3 = packageVersion3.addProductVersion(this.productVersion2);
                this.package3.addVersion(packageVersion3);
                em.persist((Object)this.package3);
                em.persist((Object)pvpv3);
                this.package4 = new Package("Package4", this.packageType1);
                PackageVersion packageVersion4 = new PackageVersion(this.package4, "1.0.0", this.architecture);
                this.package4.addVersion(packageVersion4);
                em.persist((Object)this.package4);
                this.repo1 = new Repo("repo-" + RandomStringUtils.randomNumeric((int)6));
                em.persist((Object)this.repo1);
                this.repoPackageVersion1 = this.repo1.addPackageVersion(packageVersion1);
                this.repoPackageVersion2 = this.repo1.addPackageVersion(packageVersion2);
                this.repoPackageVersion3 = this.repo1.addPackageVersion(packageVersion3);
                this.repoPackageVersion4 = this.repo1.addPackageVersion(packageVersion4);
                em.persist((Object)this.repoPackageVersion1);
                em.persist((Object)this.repoPackageVersion2);
                em.persist((Object)this.repoPackageVersion3);
                em.persist((Object)this.repoPackageVersion4);
                this.resourceRepo1 = this.repo1.addResource(this.resource);
                em.persist((Object)this.resourceRepo1);
                this.repo2 = new Repo("test-" + RandomStringUtils.randomNumeric((int)6));
                em.persist((Object)this.repo2);
                this.resourceRepo2 = this.repo2.addResource(this.resource);
                em.persist((Object)this.resourceRepo2);
                this.installedPackage1 = new InstalledPackage();
                this.installedPackage1.setResource(this.resource);
                this.installedPackage1.setPackageVersion(packageVersion4);
                this.resource.addInstalledPackage(this.installedPackage1);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getTransactionManager().rollback();
                throw e;
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDownTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ContentUIManagerBeanEligiblePackagesTest.getEntityManager();
        try {
            try {
                Query q = em.createNamedQuery("RepoPackageVersion.deleteByRepoId");
                q.setParameter("repoId", (Object)this.repo1.getId());
                q.executeUpdate();
                q = em.createNamedQuery("ResourceRepo.deleteByResourceId");
                q.setParameter("resourceId", (Object)this.resource.getId());
                q.executeUpdate();
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getTransactionManager().rollback();
                throw e;
            }
        }
        finally {
            em.close();
        }
        this.getTransactionManager().begin();
        em = ContentUIManagerBeanEligiblePackagesTest.getEntityManager();
        try {
            try {
                this.resource = (Resource)em.find(Resource.class, (Object)this.resource.getId());
                for (InstalledPackage ip : this.resource.getInstalledPackages()) {
                    em.remove((Object)ip);
                }
                this.package1 = (Package)em.find(Package.class, (Object)this.package1.getId());
                em.remove((Object)this.package1);
                this.package2 = (Package)em.find(Package.class, (Object)this.package2.getId());
                em.remove((Object)this.package2);
                this.package3 = (Package)em.find(Package.class, (Object)this.package3.getId());
                em.remove((Object)this.package3);
                this.package4 = (Package)em.find(Package.class, (Object)this.package4.getId());
                em.remove((Object)this.package4);
                this.packageType1 = (PackageType)em.find(PackageType.class, (Object)this.packageType1.getId());
                em.remove((Object)this.packageType1);
                em.remove((Object)this.resource);
                this.repo1 = (Repo)em.find(Repo.class, (Object)this.repo1.getId());
                em.remove((Object)this.repo1);
                this.repo2 = (Repo)em.find(Repo.class, (Object)this.repo2.getId());
                em.remove((Object)this.repo2);
                this.productVersion1 = (ProductVersion)em.find(ProductVersion.class, (Object)this.productVersion1.getId());
                em.remove((Object)this.productVersion1);
                this.productVersion2 = (ProductVersion)em.find(ProductVersion.class, (Object)this.productVersion2.getId());
                em.remove((Object)this.productVersion2);
                this.resourceType = (ResourceType)em.find(ResourceType.class, (Object)this.resourceType.getId());
                em.remove((Object)this.resourceType);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getTransactionManager().rollback();
                throw e;
            }
        }
        finally {
            em.close();
        }
    }
}

