/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.persistence.EntityManager;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageBits;
import org.rhq.core.domain.content.PackageBitsBlob;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.composite.LoadedPackageBitsComposite;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ContentUIManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = true;
    private ContentUIManagerLocal contentUIManager;
    private ContentManagerLocal contentManager;

    @BeforeClass
    public void setupBeforeClass() throws Exception {
        this.contentUIManager = LookupUtil.getContentUIManager();
        this.contentManager = LookupUtil.getContentManager();
    }

    @Test(enabled=true)
    public void testPackageBits() throws Throwable {
        this.getTransactionManager().begin();
        try {
            EntityManager em = ContentUIManagerBeanTest.getEntityManager();
            Resource resource = SessionTestHelper.createNewResource(em, "testPkgBitsResource");
            PackageType pkgType = new PackageType("testPkgBitsPT", resource.getResourceType());
            Package pkg = new Package("testPkgBitsP", pkgType);
            Architecture arch = new Architecture("testPkgArch");
            PackageVersion pkgVer = new PackageVersion(pkg, "1", arch);
            em.persist((Object)pkgType);
            em.persist((Object)pkg);
            em.persist((Object)arch);
            em.persist((Object)pkgVer);
            em.flush();
            LoadedPackageBitsComposite composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId() == null);
            assert (!composite.isPackageBitsAvailable());
            assert (!composite.isPackageBitsInDatabase());
            PackageBits packageBits = this.createPackageBits(em);
            pkgVer.setPackageBits(packageBits);
            pkgVer = (PackageVersion)em.merge((Object)pkgVer);
            em.flush();
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits.getId());
            assert (composite.isPackageBitsAvailable());
            assert (!composite.isPackageBitsInDatabase());
            packageBits = (PackageBits)em.find(PackageBits.class, (Object)packageBits.getId());
            assert (packageBits != null);
            assert (packageBits.getBlob().getBits() == null);
            String DATA = "testPackageBits data";
            PackageBitsBlob packageBitsBlob = (PackageBitsBlob)em.find(PackageBitsBlob.class, (Object)packageBits.getId());
            packageBitsBlob.setBits("testPackageBits data".getBytes());
            em.merge((Object)packageBitsBlob);
            em.flush();
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits.getId());
            assert (composite.isPackageBitsAvailable());
            assert (composite.isPackageBitsInDatabase());
            packageBits = (PackageBits)em.find(PackageBits.class, (Object)packageBits.getId());
            assert (packageBits != null);
            assert ("testPackageBits data".equals(new String(packageBits.getBlob().getBits())));
            PackageVersion pkgVer2 = new PackageVersion(pkg, "2", arch);
            em.persist((Object)pkgVer2);
            em.flush();
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits.getId());
            assert (composite.isPackageBitsAvailable());
            assert (composite.isPackageBitsInDatabase());
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer2.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer2.getId());
            assert (composite.getPackageBitsId() == null);
            assert (!composite.isPackageBitsAvailable());
            assert (!composite.isPackageBitsInDatabase());
            PackageBits packageBits2 = this.createPackageBits(em);
            pkgVer2.setPackageBits(packageBits2);
            pkgVer2 = (PackageVersion)em.merge((Object)pkgVer2);
            em.flush();
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits.getId());
            assert (composite.isPackageBitsAvailable());
            assert (composite.isPackageBitsInDatabase());
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer2.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer2.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits2.getId());
            assert (composite.isPackageBitsAvailable());
            assert (!composite.isPackageBitsInDatabase());
            packageBits2 = (PackageBits)em.find(PackageBits.class, (Object)packageBits2.getId());
            assert (packageBits2 != null);
            assert (packageBits2.getBlob().getBits() == null);
            String DATA2 = "testPackageBits more data";
            packageBits2.getBlob().setBits("testPackageBits more data".getBytes());
            em.merge((Object)packageBits2.getBlob());
            em.flush();
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits.getId());
            assert (composite.isPackageBitsAvailable());
            assert (composite.isPackageBitsInDatabase());
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer2.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer2.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits2.getId());
            assert (composite.isPackageBitsAvailable());
            assert (composite.isPackageBitsInDatabase());
            packageBits2 = (PackageBits)em.find(PackageBits.class, (Object)packageBits2.getId());
            assert (packageBits2 != null);
            assert ("testPackageBits more data".equals(new String(packageBits2.getBlob().getBits())));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    @Test(enabled=true)
    public void testPackageBitsBlobStream() throws Throwable {
        this.getTransactionManager().begin();
        try {
            EntityManager em = ContentUIManagerBeanTest.getEntityManager();
            Resource resource = SessionTestHelper.createNewResource(em, "testPkgBitsLargeResource");
            PackageType pkgType = new PackageType("testPkgBitsLargePT", resource.getResourceType());
            Package pkg = new Package("testPkgBitsLargeP", pkgType);
            Architecture arch = new Architecture("testPkgLargeArch");
            PackageVersion pkgVer = new PackageVersion(pkg, "1", arch);
            em.persist((Object)pkgType);
            em.persist((Object)pkg);
            em.persist((Object)arch);
            em.persist((Object)pkgVer);
            em.flush();
            LoadedPackageBitsComposite composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId() == null);
            assert (!composite.isPackageBitsAvailable());
            assert (!composite.isPackageBitsInDatabase());
            PackageBits packageBits = this.createPackageBits(em);
            pkgVer.setPackageBits(packageBits);
            pkgVer = (PackageVersion)em.merge((Object)pkgVer);
            em.flush();
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits.getId());
            assert (composite.isPackageBitsAvailable());
            assert (!composite.isPackageBitsInDatabase());
            packageBits = (PackageBits)em.find(PackageBits.class, (Object)packageBits.getId());
            assert (packageBits != null);
            assert (packageBits.getBlob().getBits() == null);
            File originalBinary = new File("./src/test/resources/binary-blob-sample.jar");
            File retrieved = new File("./target/pulled.jar");
            if (retrieved.exists()) {
                ContentUIManagerBeanTest.assertTrue((String)"Unable to delete ./target/pulled.jar for test cleanup.", (boolean)retrieved.delete());
            }
            FileInputStream fos = new FileInputStream(originalBinary);
            this.contentManager.updateBlobStream((InputStream)fos, packageBits, null);
            packageBits = (PackageBits)em.find(PackageBits.class, (Object)packageBits.getId());
            composite = this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
            assert (composite != null);
            assert (composite.getPackageVersionId() == pkgVer.getId());
            assert (composite.getPackageBitsId().intValue() == packageBits.getId());
            assert (composite.isPackageBitsAvailable());
            assert (composite.isPackageBitsInDatabase());
            FileOutputStream outputStream = new FileOutputStream(retrieved);
            this.contentManager.writeBlobOutToStream((OutputStream)outputStream, packageBits, false);
            String originalDigest = new MessageDigestGenerator("SHA-256").calcDigestString(originalBinary);
            String newDigest = new MessageDigestGenerator("SHA-256").calcDigestString(retrieved);
            ContentUIManagerBeanTest.assertEquals((String)"Uploaded and retrieved digests differ:", (String)originalDigest, (String)newDigest);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    private PackageBits createPackageBits(EntityManager em) {
        PackageBits bits = null;
        PackageBitsBlob blob = null;
        blob = new PackageBitsBlob();
        em.persist((Object)blob);
        bits = new PackageBits();
        bits.setId(blob.getId());
        bits.setBlob(blob);
        em.flush();
        return bits;
    }
}

