/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.DistributionType;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DistributionManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLED = true;
    private DistributionManagerLocal distManager;
    private DistributionType distType;
    private Subject overlord;

    @BeforeMethod
    public void setupBeforeMethod() throws Exception {
        TransactionManager tx = this.getTransactionManager();
        tx.begin();
        this.distManager = LookupUtil.getDistributionManagerLocal();
        this.distType = new DistributionType("kickstart");
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
    }

    @AfterMethod
    public void tearDownAfterMethod() throws Exception {
        TransactionManager tx = this.getTransactionManager();
        if (tx != null) {
            tx.rollback();
        }
    }

    @Test(enabled=true)
    public void createDeleteDistribution() throws Exception {
        String kslabel = "testCreateDeleteRepo";
        String kspath = "/tmp";
        int id = this.distManager.createDistribution(this.overlord, kslabel, kspath, this.distType).getId();
        Distribution distro = this.distManager.getDistributionByLabel(kslabel);
        assert (distro != null);
        assert (id == distro.getId());
        this.distManager.deleteDistributionByDistId(this.overlord, id);
        distro = this.distManager.getDistributionByLabel(kslabel);
        assert (distro == null);
    }

    public void testDistributionFiles() throws Exception {
        String kslabel = "testCreateDeleteRepo";
        String kspath = "/tmp";
        this.distManager.createDistribution(this.overlord, kslabel, kspath, this.distType);
        Distribution distro = this.distManager.getDistributionByLabel(kslabel);
        DistributionFile distfile = new DistributionFile(distro, "vmlinux", "d41d8cd98f00b204e9800998ecf8427e");
        EntityManager em = DistributionManagerBeanTest.getEntityManager();
        em.persist((Object)distfile);
        Query query = em.createNamedQuery("DistributionFile.selectByDistId");
        query.setParameter("distId", (Object)distro.getId());
        List results = query.getResultList();
        assert (results.size() != 0);
        Query querydel = em.createNamedQuery("DistributionFile.deleteByDistId");
        querydel.setParameter("distId", (Object)distro.getId());
        querydel.executeUpdate();
        List resultsdel = query.getResultList();
        assert (resultsdel.size() == 0);
    }
}

