/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProductVersionManagerBeanTest
extends AbstractEJB3Test {
    private ResourceType resourceType;
    private ProductVersionManagerLocal productManager;

    @BeforeClass
    public void setupBeforeClass() throws Exception {
        this.productManager = LookupUtil.getProductVersionManager();
    }

    @BeforeMethod
    public void setupBeforeMethod() throws Exception {
        this.setupTestEnvironment();
    }

    @AfterMethod
    public void teardownAfterMethod() throws Exception {
        this.teardownTestEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addNewProductVersion() throws Exception {
        this.productManager.addProductVersion(this.resourceType, "1.0.0");
        this.getTransactionManager().begin();
        EntityManager em = ProductVersionManagerBeanTest.getEntityManager();
        try {
            try {
                this.resourceType = (ResourceType)em.find(ResourceType.class, (Object)this.resourceType.getId());
                Query query = em.createNamedQuery("ProductVersion.findByResourceTypeAndVersion");
                query.setParameter("resourceType", (Object)this.resourceType);
                query.setParameter("version", (Object)"1.0.0");
                List addedProductVersion = query.getResultList();
                assert (addedProductVersion.size() == 1) : "Incorrect number of versions persisted. Expected: 1, Found: " + addedProductVersion.size();
                em.remove(addedProductVersion.get(0));
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                this.getTransactionManager().rollback();
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addExistingProductVersion() throws Exception {
        this.productManager.addProductVersion(this.resourceType, "1.0.0");
        this.productManager.addProductVersion(this.resourceType, "1.0.0");
        this.getTransactionManager().begin();
        EntityManager em = ProductVersionManagerBeanTest.getEntityManager();
        try {
            try {
                this.resourceType = (ResourceType)em.find(ResourceType.class, (Object)this.resourceType.getId());
                Query query = em.createNamedQuery("ProductVersion.findByResourceTypeAndVersion");
                query.setParameter("resourceType", (Object)this.resourceType);
                query.setParameter("version", (Object)"1.0.0");
                List addedProductVersion = query.getResultList();
                assert (addedProductVersion.size() == 1) : "Incorrect number of versions persisted. Expected: 1, Found: " + addedProductVersion.size();
                em.remove(addedProductVersion.get(0));
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                this.getTransactionManager().rollback();
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ProductVersionManagerBeanTest.getEntityManager();
        try {
            try {
                this.resourceType = new ResourceType("testResourceType", "testPlugin", ResourceCategory.PLATFORM, null);
                em.persist((Object)this.resourceType);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getTransactionManager().rollback();
                throw e;
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = ProductVersionManagerBeanTest.getEntityManager();
        try {
            try {
                this.resourceType = (ResourceType)em.find(ResourceType.class, (Object)this.resourceType.getId());
                em.remove((Object)this.resourceType);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getTransactionManager().rollback();
                throw e;
            }
        }
        finally {
            em.close();
        }
    }
}

