/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.lang.RandomStringUtils;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoGroup;
import org.rhq.core.domain.content.RepoGroupType;
import org.rhq.core.domain.content.RepoRelationshipType;
import org.rhq.core.domain.content.RepoRepoRelationship;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoException;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.TestContentServerPluginService;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RepoManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLED = true;
    private RepoManagerLocal repoManager;
    private ContentSourceManagerLocal contentSourceManager;
    private ContentSourceMetadataManagerLocal contentSourceMetadataManager;
    private Subject overlord;

    @BeforeMethod
    public void setupBeforeMethod() throws Exception {
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.prepareScheduler();
        this.repoManager = LookupUtil.getRepoManagerLocal();
        this.contentSourceManager = LookupUtil.getContentSourceManager();
        this.contentSourceMetadataManager = LookupUtil.getContentSourceMetadataManager();
        TestContentServerPluginService pluginService = new TestContentServerPluginService(this);
        this.getTransactionManager().begin();
    }

    @AfterMethod
    public void tearDownAfterMethod() throws Exception {
        this.unprepareServerPluginService();
        this.unprepareScheduler();
        this.getTransactionManager().rollback();
    }

    @Test(enabled=true)
    public void createABunchOfRepos() throws Exception {
        PageList repos = this.repoManager.findRepos(this.overlord, new PageControl());
        int origsize = 0;
        if (repos != null) {
            origsize = repos.size();
        }
        for (int i = 0; i < 10; ++i) {
            Random r = new Random(System.currentTimeMillis());
            Repo repo = new Repo(r.nextLong() + "");
            this.repoManager.createRepo(this.overlord, repo);
        }
        repos = this.repoManager.findRepos(this.overlord, new PageControl());
        assert (repos.size() == origsize + 10);
    }

    @Test(enabled=true)
    public void createDeleteRepo() throws Exception {
        Repo repo = new Repo("testCreateDeleteRepo");
        int id = this.repoManager.createRepo(this.overlord, repo).getId();
        Repo lookedUp = this.repoManager.getRepo(this.overlord, id);
        assert (lookedUp != null);
        Repo lookedUp2 = (Repo)this.repoManager.getRepoByName(lookedUp.getName()).get(0);
        assert (lookedUp2 != null);
        assert (id == lookedUp.getId());
        assert (id == lookedUp2.getId());
        this.repoManager.deleteRepo(this.overlord, id);
        lookedUp = this.repoManager.getRepo(this.overlord, id);
        assert (lookedUp == null);
    }

    @Test(enabled=true)
    public void createDeleteRepoGroup() throws Exception {
        EntityManager entityManager = RepoManagerBeanTest.getEntityManager();
        RepoGroupType groupType = new RepoGroupType("testCreateDeleteRepoGroupType");
        entityManager.persist((Object)groupType);
        entityManager.flush();
        String groupName = "testCreateDeleteRepoGroup";
        RepoGroup group = this.repoManager.getRepoGroupByName(groupName);
        assert (group == null);
        group = new RepoGroup(groupName);
        group.setRepoGroupType(groupType);
        group = this.repoManager.createRepoGroup(this.overlord, group);
        int id = group.getId();
        group = this.repoManager.getRepoGroup(this.overlord, id);
        assert (group != null);
        assert (group.getName().equals(groupName));
        this.repoManager.deleteRepoGroup(this.overlord, id);
        group = this.repoManager.getRepoGroup(this.overlord, id);
        assert (group == null);
        entityManager.remove((Object)groupType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void createFindDeleteCandidateRepo() throws Exception {
        Repo repo = new Repo("test create candidate repo");
        PageList importedRepos = this.repoManager.findRepos(this.overlord, new PageControl());
        int origSize = 0;
        if (importedRepos != null) {
            origSize = importedRepos.size();
        }
        repo.setCandidate(true);
        repo = this.repoManager.createRepo(this.overlord, repo);
        try {
            assert (repo.isCandidate());
            importedRepos = this.repoManager.findRepos(this.overlord, new PageControl());
            assert (importedRepos.size() == origSize);
            assert (this.repoManager.getRepo(this.overlord, repo.getId()) != null);
        }
        finally {
            this.repoManager.deleteRepo(this.overlord, repo.getId());
        }
    }

    @Test(enabled=true)
    public void createDuplicateRepoGroup() throws Exception {
        EntityManager entityManager = RepoManagerBeanTest.getEntityManager();
        RepoGroupType groupType = new RepoGroupType("testCreateDuplicateRepoGroup");
        entityManager.persist((Object)groupType);
        entityManager.flush();
        String groupName = "testCreateDuplicateRepoGroup";
        RepoGroup existing = new RepoGroup(groupName);
        existing.setRepoGroupType(groupType);
        this.repoManager.createRepoGroup(this.overlord, existing);
        existing = this.repoManager.getRepoGroupByName(groupName);
        assert (existing != null);
        RepoGroup duplicate = new RepoGroup(groupName);
        duplicate.setRepoGroupType(groupType);
        try {
            this.repoManager.createRepoGroup(this.overlord, existing);
            assert (false);
        }
        catch (RepoException e) {
            // empty catch block
        }
        this.repoManager.deleteRepoGroup(this.overlord, existing.getId());
        existing = this.repoManager.getRepoGroup(this.overlord, existing.getId());
        assert (existing == null);
        entityManager.remove((Object)groupType);
    }

    @Test(enabled=true)
    public void getRepoGroupByNameNoGroup() throws Exception {
        RepoGroup group = this.repoManager.getRepoGroupByName("foo");
        assert (group == null);
    }

    @Test(enabled=true)
    public void getRepoGroupTypeByName() throws Exception {
        EntityManager entityManager = RepoManagerBeanTest.getEntityManager();
        String name = "test-repo-type";
        RepoGroupType groupType = new RepoGroupType(name);
        entityManager.persist((Object)groupType);
        entityManager.flush();
        RepoGroupType type = this.repoManager.getRepoGroupTypeByName(this.overlord, name);
        assert (type != null);
        assert (type.getName().equals(name));
        type = (RepoGroupType)entityManager.find(RepoGroupType.class, (Object)type.getId());
        entityManager.remove((Object)type);
        entityManager.flush();
    }

    @Test(enabled=true)
    public void addRepoRelationship() throws Exception {
        EntityManager entityManager = RepoManagerBeanTest.getEntityManager();
        Repo repo = new Repo("repo1");
        Repo relatedRepo = new Repo("repo2");
        repo = this.repoManager.createRepo(this.overlord, repo);
        relatedRepo = this.repoManager.createRepo(this.overlord, relatedRepo);
        String relationshipTypeName = "testRelationshipType";
        RepoRelationshipType relationshipType = new RepoRelationshipType(relationshipTypeName);
        entityManager.persist((Object)relationshipType);
        entityManager.flush();
        this.repoManager.addRepoRelationship(this.overlord, repo.getId(), relatedRepo.getId(), relationshipTypeName);
        RepoCriteria repoCriteria = new RepoCriteria();
        repoCriteria.fetchRepoRepoGroups(true);
        repoCriteria.addFilterId(Integer.valueOf(repo.getId()));
        PageList repoPageList = this.repoManager.findReposByCriteria(this.overlord, repoCriteria);
        assert (repoPageList.size() == 1);
        Repo persistedRepo = (Repo)repoPageList.get(0);
        Set relationships = persistedRepo.getRepoRepoRelationships();
        assert (relationships.size() == 1);
        RepoRepoRelationship relationship = (RepoRepoRelationship)relationships.iterator().next();
        assert (relationship.getRepoRepoRelationshipPK().getRepo().getName().equals("repo1"));
        assert (relationship.getRepoRepoRelationshipPK().getRepoRelationship().getRelatedRepo().getName().equals("repo2"));
        assert (relationship.getRepoRepoRelationshipPK().getRepoRelationship().getRepoRelationshipType().getName().equals(relationshipTypeName));
    }

    @Test(enabled=true)
    public void findCandidatesByContentProvider() throws Exception {
        String candidateRepoName = "candidate with source";
        ContentSourceType type = new ContentSourceType("testGetSyncResultsListCST");
        HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
        types.add(type);
        this.contentSourceMetadataManager.registerTypes(types);
        ContentSource contentSource = new ContentSource("testGetSyncResultsListCS", type);
        contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
        Repo importedRepo = new Repo("imported repo");
        importedRepo.addContentSource(contentSource);
        importedRepo = this.repoManager.createRepo(this.overlord, importedRepo);
        Repo candidateRepo = new Repo(candidateRepoName);
        candidateRepo.setCandidate(true);
        candidateRepo.addContentSource(contentSource);
        candidateRepo = this.repoManager.createRepo(this.overlord, candidateRepo);
        RepoCriteria criteria = new RepoCriteria();
        criteria.addFilterCandidate(Boolean.valueOf(true));
        criteria.addFilterContentSourceIds(new Integer[]{contentSource.getId()});
        criteria.fetchRepoContentSources(true);
        PageList foundRepos = this.repoManager.findReposByCriteria(this.overlord, criteria);
        assert (foundRepos.size() == 1);
        Repo foundRepo = (Repo)foundRepos.get(0);
        assert (foundRepo.getName().equals(candidateRepoName));
        assert (foundRepo.isCandidate());
    }

    @Test(enabled=true)
    public void importCandidateRepo() throws Exception {
        Repo candidate = new Repo("create me");
        candidate.setCandidate(true);
        Repo created = this.repoManager.createRepo(this.overlord, candidate);
        ArrayList<Integer> repoIds = new ArrayList<Integer>(1);
        repoIds.add(created.getId());
        this.repoManager.importCandidateRepo(this.overlord, repoIds);
        RepoCriteria repoCriteria = new RepoCriteria();
        repoCriteria.addFilterId(Integer.valueOf(created.getId()));
        PageList repoList = this.repoManager.findReposByCriteria(this.overlord, repoCriteria);
        assert (repoList.size() == 1);
        Repo verify = (Repo)repoList.get(0);
        assert (verify != null);
        assert (!verify.isCandidate());
    }

    @Test(enabled=true)
    public void importCandidateRepoBadId() throws Exception {
        try {
            ArrayList<Integer> repoIds = new ArrayList<Integer>(1);
            repoIds.add(12345);
            this.repoManager.importCandidateRepo(this.overlord, repoIds);
            assert (false);
        }
        catch (RepoException repoException) {
            // empty catch block
        }
    }

    @Test(enabled=true)
    public void importNonCandidateRepo() throws Exception {
        Repo nonCandidate = new Repo("create me");
        Repo created = this.repoManager.createRepo(this.overlord, nonCandidate);
        try {
            ArrayList<Integer> repoIds = new ArrayList<Integer>(1);
            repoIds.add(created.getId());
            this.repoManager.importCandidateRepo(this.overlord, repoIds);
            assert (false);
        }
        catch (RepoException repoException) {
            // empty catch block
        }
    }

    @Test(enabled=true)
    public void deleteCandidatesForContentSource() throws Exception {
        ContentSourceType contentSourceType = new ContentSourceType("testSourceType");
        HashSet<ContentSourceType> types = new HashSet<ContentSourceType>(1);
        types.add(contentSourceType);
        this.contentSourceMetadataManager.registerTypes(types);
        ContentSource source1 = new ContentSource("testSource1", contentSourceType);
        source1 = this.contentSourceManager.simpleCreateContentSource(this.overlord, source1);
        ContentSource source2 = new ContentSource("testSource2", contentSourceType);
        source2 = this.contentSourceManager.simpleCreateContentSource(this.overlord, source2);
        Repo repo1 = new Repo("repo1");
        repo1.setCandidate(true);
        repo1.addContentSource(source1);
        Repo repo2 = new Repo("repo2");
        repo2.setCandidate(true);
        repo2.addContentSource(source2);
        Repo repo3 = new Repo("repo3");
        repo3.setCandidate(true);
        repo3.addContentSource(source1);
        repo3.addContentSource(source2);
        Repo repo4 = new Repo("repo4");
        repo4.setCandidate(true);
        repo1 = this.repoManager.createRepo(this.overlord, repo1);
        repo2 = this.repoManager.createRepo(this.overlord, repo2);
        repo3 = this.repoManager.createRepo(this.overlord, repo3);
        repo4 = this.repoManager.createRepo(this.overlord, repo4);
        this.repoManager.deleteCandidatesWithOnlyContentSource(this.overlord, source1.getId());
        assert (this.repoManager.getRepo(this.overlord, repo1.getId()) == null);
        assert (this.repoManager.getRepo(this.overlord, repo2.getId()) != null);
        assert (this.repoManager.getRepo(this.overlord, repo3.getId()) != null);
        assert (this.repoManager.getRepo(this.overlord, repo4.getId()) != null);
    }

    @Test(enabled=true)
    public void updateRepoWithProvider() throws Exception {
        String newName = "newRepo-" + RandomStringUtils.randomAlphanumeric((int)6);
        String oldName = "testRepo-" + RandomStringUtils.randomAlphanumeric((int)6);
        ContentSourceType contentSourceType = new ContentSourceType("testSourceType");
        HashSet<ContentSourceType> types = new HashSet<ContentSourceType>(1);
        types.add(contentSourceType);
        this.contentSourceMetadataManager.registerTypes(types);
        ContentSource source = new ContentSource("testSource1", contentSourceType);
        source = this.contentSourceManager.simpleCreateContentSource(this.overlord, source);
        Repo repo = new Repo(oldName);
        repo = this.repoManager.createRepo(this.overlord, repo);
        this.repoManager.simpleAddContentSourcesToRepo(this.overlord, repo.getId(), new int[]{source.getId()});
        repo.setName(newName);
        this.repoManager.updateRepo(this.overlord, repo);
        RepoCriteria byName = new RepoCriteria();
        byName.addFilterName(newName);
        PageList reposWithNewName = this.repoManager.findReposByCriteria(this.overlord, byName);
        assert (reposWithNewName.size() == 1);
        byName = new RepoCriteria();
        byName.addFilterName(oldName);
        PageList reposWithOldName = this.repoManager.findReposByCriteria(this.overlord, byName);
        assert (reposWithOldName.size() == 0);
    }

    @Test(enabled=true)
    public void updateSyncSchedule() {
        Repo repo = new Repo("updateSyncSchedule");
        repo.setSyncSchedule("NOT A VALID CRON");
        boolean failed = false;
        try {
            repo = this.repoManager.createRepo(this.overlord, repo);
        }
        catch (RepoException e) {
            failed = true;
        }
        assert (failed);
        failed = false;
        repo.setSyncSchedule("0 0 3 * * ?");
        try {
            repo = this.repoManager.createRepo(this.overlord, repo);
        }
        catch (RepoException e) {
            failed = true;
        }
        assert (!failed);
    }
}

