/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.persistence.Query;
import org.rhq.core.clientapi.server.core.AgentRegistrationException;
import org.rhq.core.clientapi.server.core.AgentRegistrationRequest;
import org.rhq.core.clientapi.server.core.AgentRegistrationResults;
import org.rhq.core.clientapi.server.core.AgentVersion;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.CoreServerServiceImpl;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"core.agent-registration"})
public class CoreServerServiceImplTest
extends AbstractEJB3Test {
    private static final String TEST_AGENT_NAME_PREFIX = "CoreServerServiceImplTest.Agent";
    private static final String RHQ_SERVER_NAME_PROPERTY = "rhq.server.high-availability.name";
    private AgentVersion agentVersion;
    private Server server;
    private String oldServerNamePropertyValue = null;
    private AgentRegistrationRequest aReq = null;
    private AgentRegistrationResults aResults = null;
    private AgentRegistrationRequest zReq = null;
    private AgentRegistrationResults zResults = null;
    private static final int A_PORT = 11111;
    private static final String A_HOST = "hostA";
    private static final int B_PORT = 22222;
    private static final String B_HOST = "hostB";

    @AfterGroups(groups={"core.agent-registration"})
    public void afterGroup() throws Exception {
        Query q = CoreServerServiceImplTest.getEntityManager().createQuery("select a from Agent a where name like 'CoreServerServiceImplTest.Agent%'");
        List doomed = q.getResultList();
        for (Agent deleteMe : doomed) {
            LookupUtil.getAgentManager().deleteAgent(deleteMe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeMethod
    public void prepare() throws Exception {
        this.oldServerNamePropertyValue = System.getProperty(RHQ_SERVER_NAME_PROPERTY);
        String newServerNamePropertyValue = "CoreServerServiceImplTest.Server";
        System.setProperty(RHQ_SERVER_NAME_PROPERTY, newServerNamePropertyValue);
        MBeanServer mbs = this.getJBossMBeanServer();
        DummyCoreServer mbean = new DummyCoreServer();
        mbs.registerMBean(mbean, CoreServerMBean.OBJECT_NAME);
        this.agentVersion = new AgentVersion("1.2.3", "12345");
        File agentVersionFile = new File(mbean.getJBossServerHomeDir(), "deploy/rhq.ear/rhq-downloads/rhq-agent/rhq-server-agent-versions.properties");
        agentVersionFile.getParentFile().mkdirs();
        agentVersionFile.delete();
        Properties agentVersionProps = new Properties();
        agentVersionProps.put("rhq-agent.latest.version", this.agentVersion.getVersion());
        agentVersionProps.put("rhq-agent.latest.build-number", this.agentVersion.getBuild());
        FileOutputStream fos = new FileOutputStream(agentVersionFile);
        try {
            agentVersionProps.store(fos, "This file was created by " + CoreServerServiceImplTest.class.getName());
        }
        finally {
            fos.close();
        }
        this.prepareForTestAgents();
        this.server = new Server();
        this.server.setName(newServerNamePropertyValue);
        this.server.setAddress("CoreServerServiceImplTest.localhost");
        this.server.setPort(12345);
        this.server.setSecurePort(12346);
        this.server.setOperationMode(Server.OperationMode.NORMAL);
        int serverId = LookupUtil.getServerManager().create(this.server);
        this.server.setId(serverId);
    }

    @AfterMethod
    public void unprepare() throws Exception {
        LookupUtil.getCloudManager().updateServerMode(new Integer[]{this.server.getId()}, Server.OperationMode.DOWN);
        LookupUtil.getCloudManager().deleteServer(Integer.valueOf(this.server.getId()));
        MBeanServer mbs = this.getJBossMBeanServer();
        mbs.unregisterMBean(CoreServerMBean.OBJECT_NAME);
        this.unprepareForTestAgents();
        if (this.oldServerNamePropertyValue != null) {
            System.setProperty(RHQ_SERVER_NAME_PROPERTY, this.oldServerNamePropertyValue);
        }
    }

    @Test
    public void testNewAgentRegistrationWithOldToken() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.prefixName("old"), "hostOld", 12345, "oldtoken");
        AgentRegistrationResults results = service.registerAgent(request);
        assert (results != null) : "cannot re-register an old agent";
        Agent agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(request.getName()));
        assert (agent.getAddress().equals(request.getAddress()));
        assert (agent.getPort() == request.getPort());
        LookupUtil.getAgentManager().deleteAgent(agent);
    }

    @Test
    public void testChangeAddressPort() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        String zName = this.prefixName("Z");
        AgentRegistrationRequest request = this.createRequest(zName, "hostZ", 55550, null);
        AgentRegistrationResults results = service.registerAgent(request);
        assert (results != null) : "got null results";
        request = this.createRequest(zName, "hostZprime", 55550, results.getAgentToken());
        results = service.registerAgent(request);
        assert (results != null);
        Agent agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(zName));
        assert (agent.getAddress().equals("hostZprime"));
        assert (agent.getPort() == 55550);
        request = this.createRequest(zName, "hostZprime", 55551, results.getAgentToken());
        results = service.registerAgent(request);
        assert (results != null);
        agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(zName));
        assert (agent.getAddress().equals("hostZprime"));
        assert (agent.getPort() == 55551);
        request = this.createRequest(zName, "hostZdoubleprime", 55552, results.getAgentToken());
        results = service.registerAgent(request);
        assert (results != null);
        agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(zName));
        assert (agent.getAddress().equals("hostZdoubleprime"));
        assert (agent.getPort() == 55552);
        request = this.createRequest(zName, "hostZdoubleprime", 55552, results.getAgentToken());
        results = service.registerAgent(request);
        assert (results != null);
        agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(zName));
        assert (agent.getAddress().equals("hostZdoubleprime"));
        assert (agent.getPort() == 55552);
        this.zReq = request;
        this.zResults = results;
        request = this.createRequest(zName, B_HOST, this.zReq.getPort(), null);
        try {
            service.registerAgent(request);
            assert (false) : "(1) Should not have been able to register without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(zName, this.zReq.getAddress(), 22222, null);
        try {
            service.registerAgent(request);
            assert (false) : "(2) Should not have been able to register without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(zName, B_HOST, 22222, null);
        try {
            service.registerAgent(request);
            assert (false) : "(3) Should not have been able to register without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(zName, this.zReq.getAddress(), this.zReq.getPort(), null);
        try {
            service.registerAgent(request);
            assert (false) : "(4) Should not have been able to register without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testChangeAddressPort"})
    public void testNormalAgentRegistration() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        this.aReq = this.createRequest(this.prefixName("A"), A_HOST, 11111, null);
        this.aResults = service.registerAgent(this.aReq);
        assert (this.aResults != null) : "got null results";
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentAddressPort() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.prefixName("B"), this.aReq.getAddress(), this.aReq.getPort(), null);
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used host/port with new agent name";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentName() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.aReq.getName(), this.aReq.getAddress(), 22222, null);
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(this.aReq.getName(), B_HOST, this.aReq.getPort(), null);
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(this.aReq.getName(), B_HOST, 22222, null);
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentAddressPortWithBogusToken() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.prefixName("B"), this.aReq.getAddress(), this.aReq.getPort(), "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used host/port with new agent name and invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentNameWithBogusToken() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.aReq.getName(), this.aReq.getAddress(), this.aReq.getPort(), "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name with an invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(this.aReq.getName(), this.aReq.getAddress(), 22222, "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name with an invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(this.aReq.getName(), B_HOST, this.aReq.getPort(), "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name with an invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(this.aReq.getName(), B_HOST, 22222, "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name with an invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentNameWithAnotherAgentToken() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.aReq.getName(), this.aReq.getAddress(), this.aReq.getPort(), this.zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack agent A using Z's token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(this.aReq.getName(), B_HOST, this.aReq.getPort(), this.zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack agent A using Z's token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(this.aReq.getName(), this.aReq.getAddress(), 22222, this.zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack agent A using Z's token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(this.aReq.getName(), B_HOST, 22222, this.zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack agent A using Z's token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testAgentHijackingAnotherAgentAddressPort() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.aReq.getName(), this.zReq.getAddress(), this.zReq.getPort(), this.aResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "An agent should not have been able to hijack another agent's host/port";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testAttemptToChangeAgentName() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.prefixName("newName"), this.zReq.getAddress(), this.zReq.getPort(), this.zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "An agent should not be able to change its name";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    private AgentRegistrationRequest createRequest(String name, String address, int port, String token) {
        return new AgentRegistrationRequest(name, address, port, "socket://" + address + ":" + port + "/?rhq.communications.connector.rhqtype=agent", true, token, this.agentVersion);
    }

    private String prefixName(String name) {
        return TEST_AGENT_NAME_PREFIX + name;
    }

    private void debugPrintThrowable(Throwable t) {
        System.out.println(ThrowableUtil.getAllMessages((Throwable)t));
    }

    class DummyCoreServer
    implements DummyCoreServerMBean {
        DummyCoreServer() {
        }

        public String getName() {
            return "CoreServer";
        }

        public int getState() {
            return 0;
        }

        public String getStateString() {
            return "";
        }

        public void jbossInternalLifecycle(String arg0) throws Exception {
        }

        public void create() throws Exception {
        }

        public void destroy() {
        }

        public void start() throws Exception {
        }

        public void stop() {
        }

        public String getVersion() {
            return null;
        }

        public String getBuildNumber() {
            return null;
        }

        public Date getBootTime() {
            return null;
        }

        public File getInstallDir() {
            return null;
        }

        public File getJBossServerHomeDir() {
            return new File(System.getProperty("java.io.tmpdir"), "CoreServerServiceImplTest");
        }

        public File getJBossServerDataDir() {
            return null;
        }

        public File getJBossServerTempDir() {
            return null;
        }

        public ProductInfo getProductInfo() {
            return null;
        }
    }

    static interface DummyCoreServerMBean
    extends CoreServerMBean {
    }
}

