/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceCircularityException;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceController;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceException;
import org.testng.annotations.Test;

@Test
public class LatchedServiceCircularDependenciesTest {
    private Collection<DummyLatchedService> getDummiesFromDependencyGraph(String dependencyGraph) {
        String[] deps;
        HashMap<String, DummyLatchedService> knownServices = new HashMap<String, DummyLatchedService>();
        ArrayList<DummyLatchedService> orderedServices = new ArrayList<DummyLatchedService>();
        for (String dep : deps = dependencyGraph.replaceAll(" ", "").split(",")) {
            String[] parts = dep.split("-");
            DummyLatchedService service = this.getDummyServiceByName(parts[0], knownServices);
            if (parts.length > 1) {
                DummyLatchedService dependency = this.getDummyServiceByName(parts[1], knownServices);
                service.addDependency(dependency);
            }
            orderedServices.add(service);
        }
        return orderedServices;
    }

    private DummyLatchedService getDummyServiceByName(String name, Map<String, DummyLatchedService> dummies) {
        DummyLatchedService result = dummies.get(name);
        if (result == null) {
            result = new DummyLatchedService(name);
            dummies.put(name, result);
        }
        return result;
    }

    @Test
    public void testLongCircularDependencyGraph() {
        this.testCircularDependency("1-2, 2-3, 3-4, 4-5, 5-1");
    }

    @Test
    public void testShortCircularDependencyGraph() {
        this.testCircularDependency("1-2, 2-3, 2-4, 2-5, 5-1");
    }

    @Test
    public void testTwoElementCircularDependencyGraph() {
        this.testCircularDependency("1-2, 2-1");
    }

    @Test
    public void testSelfCircularDependencyGraph() {
        this.testCircularDependency("1-1");
    }

    @Test
    public void testNoCircularDependencyGraph() {
        block2: {
            Collection<DummyLatchedService> dummies = this.getDummiesFromDependencyGraph("1,2,3,4,5,6,7,8,9,10");
            LatchedServiceController controller = new LatchedServiceController(dummies);
            try {
                controller.executeServices();
            }
            catch (LatchedServiceCircularityException lsce) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Should not have recieved a LatchedServiceCircularityException, but did: " + (Object)((Object)lsce)));
            }
        }
    }

    private void testCircularDependency(String dependencyGraph) {
        Collection<DummyLatchedService> dummies = this.getDummiesFromDependencyGraph(dependencyGraph);
        LatchedServiceController controller = new LatchedServiceController(dummies);
        try {
            controller.executeServices();
            assert (false) : "Should have recieved a LatchedServiceCircularityException, but didn't";
        }
        catch (LatchedServiceCircularityException lsce) {
            // empty catch block
        }
    }

    private class DummyLatchedService
    extends LatchedServiceController.LatchedService {
        public DummyLatchedService(String name) {
            super(name);
        }

        public void executeService() throws LatchedServiceException {
        }
    }
}

