/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceController;
import org.rhq.enterprise.server.core.concurrency.LatchedServiceException;
import org.testng.annotations.Test;

@Test
public class LatchedServiceDependenciesTest {
    public void testDependencies() throws Exception {
        Collection<DummyLatchedService> dummies = this.getDummiesFromDependencyGraph("1,2-1");
        LatchedServiceController controller = new LatchedServiceController(dummies);
        controller.setThreadPoolSize(1);
        controller.executeServices();
    }

    public void testDependencies2() throws Exception {
        Collection<DummyLatchedService> dummies = this.getDummiesFromDependencyGraph("1,6-1,2,7-2,3,8-3,4,9-4,5,10-5");
        LatchedServiceController controller = new LatchedServiceController(dummies);
        controller.setThreadPoolSize(1);
        controller.executeServices();
    }

    public void testDependencies3() throws Exception {
        Collection<DummyLatchedService> dummies = this.getDummiesFromDependencyGraph("1,6-1,2,7-2,3,8-3,4,9-4,5,10-5");
        LatchedServiceController controller = new LatchedServiceController(dummies);
        controller.setThreadPoolSize(5);
        controller.executeServices();
    }

    private Collection<DummyLatchedService> getDummiesFromDependencyGraph(String dependencyGraph) {
        String[] deps;
        HashMap<String, DummyLatchedService> knownServices = new HashMap<String, DummyLatchedService>();
        ArrayList<DummyLatchedService> orderedServices = new ArrayList<DummyLatchedService>();
        for (String dep : deps = dependencyGraph.replaceAll(" ", "").split(",")) {
            String[] parts = dep.split("-");
            DummyLatchedService service = this.getDummyServiceByName(parts[0], knownServices);
            if (parts.length > 1) {
                DummyLatchedService dependency = this.getDummyServiceByName(parts[1], knownServices);
                service.addDependency(dependency);
            }
            orderedServices.add(service);
        }
        return orderedServices;
    }

    private DummyLatchedService getDummyServiceByName(String name, Map<String, DummyLatchedService> dummies) {
        DummyLatchedService result = dummies.get(name);
        if (result == null) {
            result = new DummyLatchedService(name);
            dummies.put(name, result);
        }
        return result;
    }

    private class DummyLatchedService
    extends LatchedServiceController.LatchedService {
        public DummyLatchedService(String name) {
            super(name);
        }

        public void executeService() throws LatchedServiceException {
        }
    }
}

