/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.db;

import java.util.Set;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.DbSetupUtility;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"db"}, singleThreaded=true)
public class DbSetupTest
extends AbstractEJB3Test {
    @BeforeClass(groups={"db"})
    public void setUp() throws Exception {
        DbSetupUtility.dbreset();
        DbSetupUtility.dbsetup();
    }

    public void testRoles() throws Exception {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
        Subject overlord = subjectManager.getOverlord();
        Role superuserRole = roleManager.getRole(overlord, 1);
        Set superuserRoleOriginalPermissions = superuserRole.getPermissions();
        DbSetupTest.assertTrue((String)"[Superuser] role does not have all global permissions.", (boolean)superuserRoleOriginalPermissions.containsAll(Permission.GLOBAL_ALL));
        DbSetupTest.assertTrue((String)"[Superuser] role does not have all Resource permissions.", (boolean)superuserRoleOriginalPermissions.containsAll(Permission.RESOURCE_ALL));
        Role allResourcesRole = roleManager.getRole(overlord, 2);
        Set allResourcesRoleOriginalPermissions = allResourcesRole.getPermissions();
        DbSetupTest.assertTrue((String)"[All Resources] role does not have MANAGE_INVENTORY permission.", (boolean)allResourcesRoleOriginalPermissions.contains(Permission.MANAGE_INVENTORY));
        DbSetupTest.assertTrue((String)"[All Resources] role does not have all Resource permissions.", (boolean)allResourcesRoleOriginalPermissions.containsAll(Permission.RESOURCE_ALL));
    }
}

