/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.util.List;
import java.util.Random;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.mx.util.MBeanServerLocator;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsService;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceMBean;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.xml.sax.InputSource;

public class DiscoveryBossBeanTest
extends AbstractEJB3Test {
    private DiscoveryBossLocal discoveryBoss;
    private MBeanServer dummyJBossMBeanServer;
    private ResourceType platformType;
    private ResourceType serverType;
    private ResourceType serviceType1;
    private ResourceType serviceType2;
    private Agent agent;

    @BeforeClass
    public void beforeClass() throws Exception {
        this.discoveryBoss = LookupUtil.getDiscoveryBoss();
    }

    @BeforeMethod
    public void setupTestData() throws Exception {
        this.dummyJBossMBeanServer = MBeanServerFactory.createMBeanServer("jboss");
        MBeanServerLocator.setJBoss((MBeanServer)this.dummyJBossMBeanServer);
        this.dummyJBossMBeanServer.registerMBean(new ServerCommunicationsService(), ServerCommunicationsServiceMBean.OBJECT_NAME);
        this.initDB();
        this.platformType = (ResourceType)DiscoveryBossBeanTest.getEntityManager().find(ResourceType.class, (Object)1);
        this.serverType = (ResourceType)DiscoveryBossBeanTest.getEntityManager().find(ResourceType.class, (Object)2);
        this.serviceType1 = (ResourceType)DiscoveryBossBeanTest.getEntityManager().find(ResourceType.class, (Object)3);
        this.serviceType2 = (ResourceType)DiscoveryBossBeanTest.getEntityManager().find(ResourceType.class, (Object)4);
        this.agent = (Agent)DiscoveryBossBeanTest.getEntityManager().find(Agent.class, (Object)1);
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        MBeanServerFactory.releaseMBeanServer(this.dummyJBossMBeanServer);
        this.cleanDB();
    }

    @Test(groups={"integration.ejb3"})
    public void testBasicInventoryReport() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource("alpha", "platform", this.platformType);
        Resource server = new Resource("bravo", "server", this.serverType);
        platform.addChildResource(server);
        Resource service1 = new Resource("charlie", "service 1", this.serviceType1);
        Resource service2 = new Resource("delta", "service 2", this.serviceType2);
        server.addChildResource(service1);
        server.addChildResource(service2);
        platform.setUuid("" + new Random().nextInt());
        server.setUuid("" + new Random().nextInt());
        service1.setUuid("" + new Random().nextInt());
        service2.setUuid("" + new Random().nextInt());
        inventoryReport.addAddedRoot(platform);
        ResourceSyncInfo syncInfo = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (syncInfo != null);
    }

    @Test(groups={"integration.ejb3"})
    public void testUpdateInventoryReport() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource("alpha", "platform", this.platformType);
        platform.setUuid("" + new Random().nextInt());
        inventoryReport.addAddedRoot(platform);
        ResourceSyncInfo syncInfo = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (syncInfo != null);
        platform.setId(syncInfo.getId());
        inventoryReport = new InventoryReport(this.agent);
        Resource server = new Resource("bravo", "server", this.serverType);
        platform.addChildResource(server);
        Resource service1 = new Resource("charlie", "service 1", this.serviceType1);
        Resource service2 = new Resource("delta", "service 2", this.serviceType2);
        server.addChildResource(service1);
        server.addChildResource(service2);
        server.setUuid("" + new Random().nextInt());
        service1.setUuid("" + new Random().nextInt());
        service2.setUuid("" + new Random().nextInt());
        inventoryReport.addAddedRoot(server);
        syncInfo = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (syncInfo != null);
    }

    private static <T> T serialize(T object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            System.out.println("****** Size of serialized object: " + baos.size());
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            Object transfered = ois.readObject();
            return (T)transfered;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed serializing and deserializing object: " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDB() throws Exception {
        Connection connection = null;
        try {
            connection = DiscoveryBossBeanTest.getConnection();
            DatabaseConnection dbUnitConnection = new DatabaseConnection(connection);
            this.setDbType((IDatabaseConnection)dbUnitConnection);
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)dbUnitConnection, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanDB() throws Exception {
        Connection connection = null;
        EntityManager em = null;
        try {
            this.getTransactionManager().begin();
            em = DiscoveryBossBeanTest.getEntityManager();
            Query q = em.createQuery("SELECT r FROM Resource r WHERE r.resourceType.id <= 4 ORDER BY r.id DESC");
            List doomed = q.getResultList();
            for (Object removeMe : doomed) {
                em.remove(em.getReference(Resource.class, (Object)((Resource)removeMe).getId()));
            }
            em.flush();
            this.getTransactionManager().commit();
            em.close();
            em = null;
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT CLEAN UP TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        finally {
            if (null != em) {
                em.close();
            }
        }
        try {
            connection = DiscoveryBossBeanTest.getConnection();
            DatabaseConnection dbUnitConnection = new DatabaseConnection(connection);
            this.setDbType((IDatabaseConnection)dbUnitConnection);
            DatabaseOperation.DELETE.execute((IDatabaseConnection)dbUnitConnection, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    void setDbType(IDatabaseConnection connection) throws Exception {
        DatabaseConfig dbConfig = connection.getConfig();
        String name = connection.getConnection().getMetaData().getDatabaseProductName().toLowerCase();
        int major = connection.getConnection().getMetaData().getDatabaseMajorVersion();
        Object type = null;
        if (name.contains("postgres")) {
            type = new PostgresqlDataTypeFactory();
        } else if (name.contains("oracle")) {
            type = major >= 10 ? new Oracle10DataTypeFactory() : new OracleDataTypeFactory();
        }
        if (type != null) {
            dbConfig.setProperty("http://www.dbunit.org/properties/datatypeFactory", type);
        }
    }

    IDataSet getDataSet() throws Exception {
        FlatXmlProducer xmlProducer = new FlatXmlProducer(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream(this.getDataSetFile())));
        xmlProducer.setColumnSensing(true);
        return new FlatXmlDataSet(xmlProducer);
    }

    String getDataSetFile() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ".xml";
    }
}

