/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.io.FileUtils;
import org.rhq.common.drift.ChangeSetWriterImpl;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;
import org.rhq.core.clientapi.server.drift.DriftServerService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.JPADriftChangeSetCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.DriftFileStatus;
import org.rhq.core.domain.drift.JPADriftFile;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftServerServiceImpl;
import org.rhq.enterprise.server.drift.JPADriftServerLocal;
import org.rhq.enterprise.server.drift.TestDefService;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DriftManagerBeanTest
extends AbstractEJB3Test {
    private JPADriftServerLocal jpaDriftServer;
    private DriftManagerLocal driftManager;
    private Subject overlord;
    private Resource newResource;
    private DriftServerService driftServerService;
    MessageDigestGenerator digestGenerator;

    @BeforeClass
    public void beforeClass() throws Exception {
        this.digestGenerator = new MessageDigestGenerator("SHA-256");
        this.jpaDriftServer = LookupUtil.getJPADriftServer();
        this.driftManager = LookupUtil.getDriftManager();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.driftServerService = new DriftServerServiceImpl();
    }

    @AfterClass(alwaysRun=true)
    public void afterClass() {
        this.driftServerService = null;
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        agentServiceContainer.driftService = new TestDefService();
        this.prepareScheduler();
        this.deleteDriftFiles();
        this.newResource = this.createNewResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        try {
            this.deleteNewResource(this.newResource);
        }
        finally {
            this.unprepareForTestAgents();
            this.unprepareScheduler();
        }
    }

    @Test
    public void testStoreChangeSet() throws Exception {
        File rootDir = FileUtils.toFile((URL)((Object)((Object)this)).getClass().getResource("."));
        File changeSetsDir = new File(rootDir, "changesets");
        FileUtils.deleteDirectory((File)changeSetsDir);
        changeSetsDir.mkdirs();
        Headers headers = new Headers();
        headers.setResourceId(this.newResource.getId());
        headers.setDriftDefinitionId(1);
        headers.setDriftDefinitionName("test-1");
        headers.setBasedir(rootDir.getAbsolutePath());
        headers.setType(DriftChangeSetCategory.COVERAGE);
        headers.setVersion(0);
        String file1Hash = this.sha256("test-1-file-1");
        File changeSet1 = new File(changeSetsDir, "changeset-1.txt");
        ChangeSetWriterImpl writer = new ChangeSetWriterImpl(changeSet1, headers);
        writer.write(FileEntry.addedFileEntry((String)"test/file-1", (String)file1Hash, (Long)56789L, (Long)1024L));
        writer.close();
        File changeSet1Zip = new File(changeSetsDir, "changeset-1.zip");
        ZipUtil.zipFileOrDirectory((File)changeSet1, (File)changeSet1Zip);
        DriftManagerBeanTest.assertTrue((String)("Expected to find change set zip file: " + changeSet1Zip.getPath()), (boolean)changeSet1Zip.exists());
        this.jpaDriftServer.storeChangeSet(this.overlord, this.newResource.getId(), changeSet1Zip);
        JPADriftChangeSetCriteria c = new JPADriftChangeSetCriteria();
        c.addFilterResourceId(Integer.valueOf(this.newResource.getId()));
        c.fetchDrifts(true);
        PageList changeSets = this.jpaDriftServer.findDriftChangeSetsByCriteria(this.overlord, (DriftChangeSetCriteria)c);
        DriftManagerBeanTest.assertEquals((int)1, (int)changeSets.size());
        DriftChangeSet changeSet = (DriftChangeSet)changeSets.get(0);
        DriftManagerBeanTest.assertEquals((int)0, (int)changeSet.getVersion());
        DriftManagerBeanTest.assertEquals((String)"Expected to find one entry in change set", (int)1, (int)changeSet.getDrifts().size());
        JPADriftFile driftFile = this.jpaDriftServer.getDriftFile(this.overlord, file1Hash);
        DriftManagerBeanTest.assertNotNull((Object)driftFile);
        DriftManagerBeanTest.assertEquals((Object)DriftFileStatus.REQUESTED, (Object)driftFile.getStatus());
        String modifiedFile1Hash = this.sha256("test-2-file-1-modified");
        headers.setType(DriftChangeSetCategory.DRIFT);
        headers.setVersion(1);
        File changeSet2 = new File(changeSetsDir, "changeset-2.txt");
        writer = new ChangeSetWriterImpl(changeSet2, headers);
        writer.write(FileEntry.changedFileEntry((String)"test/file-1", (String)file1Hash, (String)modifiedFile1Hash, (Long)56789L, (Long)1024L));
        writer.close();
        File changeSet2Zip = new File(changeSetsDir, "changeset-2.zip");
        ZipUtil.zipFileOrDirectory((File)changeSet2, (File)changeSet2Zip);
        DriftManagerBeanTest.assertTrue((String)("Expected to find change set file: " + changeSet2Zip.getPath()), (boolean)changeSet2Zip.exists());
        this.jpaDriftServer.storeChangeSet(this.overlord, this.newResource.getId(), changeSet2Zip);
        c.addSortVersion(PageOrdering.ASC);
        c.addFilterCategory(DriftChangeSetCategory.DRIFT);
        changeSets = this.jpaDriftServer.findDriftChangeSetsByCriteria(this.overlord, (DriftChangeSetCriteria)c);
        DriftManagerBeanTest.assertEquals((int)1, (int)changeSets.size());
        changeSet = (DriftChangeSet)changeSets.get(0);
        DriftManagerBeanTest.assertEquals((String)"The change set version is wrong", (int)1, (int)changeSet.getVersion());
        DriftManagerBeanTest.assertEquals((String)"Expected to find one entry in change set", (int)1, (int)changeSet.getDrifts().size());
        changeSet = (DriftChangeSet)changeSets.get(0);
        DriftManagerBeanTest.assertEquals((int)1, (int)changeSet.getVersion());
        DriftManagerBeanTest.assertEquals((int)1, (int)changeSet.getDrifts().size());
        Drift drift = (Drift)changeSet.getDrifts().iterator().next();
        DriftManagerBeanTest.assertEquals((String)"test/file-1", (String)drift.getPath());
        DriftManagerBeanTest.assertEquals((String)file1Hash, (String)drift.getOldDriftFile().getHashId());
        DriftManagerBeanTest.assertEquals((String)modifiedFile1Hash, (String)drift.getNewDriftFile().getHashId());
        DriftManagerBeanTest.assertEquals((Object)DriftCategory.FILE_CHANGED, (Object)drift.getCategory());
        driftFile = this.jpaDriftServer.getDriftFile(this.overlord, modifiedFile1Hash);
        DriftManagerBeanTest.assertNotNull((Object)driftFile);
        DriftManagerBeanTest.assertEquals((Object)DriftFileStatus.REQUESTED, (Object)driftFile.getStatus());
    }

    @Test
    public void testDriftDef() throws Exception {
        Configuration config = new Configuration();
        DriftDefinition driftDefPojo = new DriftDefinition(config);
        driftDefPojo.setName("testDriftDef");
        driftDefPojo.setInterval(Long.valueOf(60L));
        driftDefPojo.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "foo/bar"));
        this.driftManager.updateDriftDefinition(this.overlord, EntityContext.forResource((int)this.newResource.getId()), driftDefPojo);
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        ResourceCriteria c = new ResourceCriteria();
        c.addFilterId(Integer.valueOf(this.newResource.getId()));
        c.fetchDriftDefinitions(true);
        PageList resources = resourceManager.findResourcesByCriteria(this.overlord, c);
        DriftManagerBeanTest.assertEquals((int)1, (int)resources.size());
        Set driftDefs = ((Resource)resources.get(0)).getDriftDefinitions();
        DriftManagerBeanTest.assertNotNull((Object)driftDefs);
        DriftManagerBeanTest.assertEquals((int)3, (int)driftDefs.size());
        DriftDefinition driftDef2 = null;
        for (DriftDefinition driftDef2 : driftDefs) {
            if (!driftDefPojo.getName().equals(driftDef2.getName())) continue;
        }
        DriftManagerBeanTest.assertTrue((driftDef2.getConfiguration().getId() > 0 ? 1 : 0) != 0);
        DriftManagerBeanTest.assertEquals((String)driftDefPojo.getName(), (String)driftDef2.getName());
        DriftManagerBeanTest.assertEquals((Object)driftDefPojo.getBasedir(), (Object)driftDef2.getBasedir());
        DriftManagerBeanTest.assertEquals((long)driftDefPojo.getInterval(), (long)driftDef2.getInterval());
        driftDefPojo.setInterval(Long.valueOf(120L));
        this.driftManager.updateDriftDefinition(this.overlord, EntityContext.forResource((int)this.newResource.getId()), driftDefPojo);
        resources = resourceManager.findResourcesByCriteria(this.overlord, c);
        DriftManagerBeanTest.assertEquals((int)1, (int)resources.size());
        driftDefs = ((Resource)resources.get(0)).getDriftDefinitions();
        DriftManagerBeanTest.assertNotNull((Object)driftDefs);
        DriftManagerBeanTest.assertEquals((int)3, (int)driftDefs.size());
        driftDef2 = null;
        for (DriftDefinition driftDef2 : driftDefs) {
            if (!driftDefPojo.getName().equals(driftDef2.getName())) continue;
        }
        DriftManagerBeanTest.assertEquals((String)driftDefPojo.getName(), (String)driftDef2.getName());
        DriftManagerBeanTest.assertTrue((driftDef2.getConfiguration().getId() > 0 ? 1 : 0) != 0);
        DriftManagerBeanTest.assertEquals((Object)driftDefPojo.getBasedir(), (Object)driftDef2.getBasedir());
        DriftManagerBeanTest.assertEquals((long)120L, (long)driftDef2.getInterval());
        driftDefPojo = new DriftDefinition(driftDef2.getConfiguration().deepCopyWithoutProxies());
        driftDefPojo.setName("testDriftDef-2");
        driftDefPojo.setInterval(Long.valueOf(30L));
        driftDefPojo.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "foo/baz"));
        this.driftManager.updateDriftDefinition(this.overlord, EntityContext.forResource((int)this.newResource.getId()), driftDefPojo);
        resources = resourceManager.findResourcesByCriteria(this.overlord, c);
        DriftManagerBeanTest.assertEquals((int)1, (int)resources.size());
        driftDefs = ((Resource)resources.get(0)).getDriftDefinitions();
        DriftManagerBeanTest.assertNotNull((Object)driftDefs);
        DriftManagerBeanTest.assertEquals((int)4, (int)driftDefs.size());
        for (DriftDefinition driftDef2 : driftDefs) {
            if ("testDriftDef".equals(driftDef2.getName())) {
                DriftManagerBeanTest.assertTrue((driftDef2.getConfiguration().getId() > 0 ? 1 : 0) != 0);
                DriftManagerBeanTest.assertEquals((String)"foo/bar", (String)driftDef2.getBasedir().getValueName());
                DriftManagerBeanTest.assertEquals((Object)DriftConfigurationDefinition.BaseDirValueContext.fileSystem, (Object)driftDef2.getBasedir().getValueContext());
                DriftManagerBeanTest.assertEquals((long)120L, (long)driftDef2.getInterval());
                continue;
            }
            if ("testDriftDef-2".equals(driftDef2.getName())) {
                DriftManagerBeanTest.assertTrue((driftDef2.getConfiguration().getId() > 0 ? 1 : 0) != 0);
                DriftManagerBeanTest.assertEquals((Object)driftDefPojo.getBasedir(), (Object)driftDef2.getBasedir());
                DriftManagerBeanTest.assertEquals((long)driftDefPojo.getInterval(), (long)driftDef2.getInterval());
                continue;
            }
            if ("test-1".equals(driftDef2.getName()) || "test-2".equals(driftDef2.getName())) continue;
            DriftManagerBeanTest.fail((String)("Unexpected drift def name: " + driftDef2.getName()));
        }
        this.driftManager.deleteDriftDefinition(this.overlord, EntityContext.forResource((int)this.newResource.getId()), "testDriftDef");
        resources = resourceManager.findResourcesByCriteria(this.overlord, c);
        DriftManagerBeanTest.assertEquals((int)1, (int)resources.size());
        driftDefs = ((Resource)resources.get(0)).getDriftDefinitions();
        DriftManagerBeanTest.assertNotNull((Object)driftDefs);
        DriftManagerBeanTest.assertEquals((int)3, (int)driftDefs.size());
        for (DriftDefinition driftDef2 : driftDefs) {
            if (!driftDefPojo.getName().equals(driftDef2.getName())) continue;
        }
        DriftManagerBeanTest.assertTrue((driftDef2.getConfiguration().getId() > 0 ? 1 : 0) != 0);
        DriftManagerBeanTest.assertEquals((String)driftDefPojo.getName(), (String)driftDef2.getName());
        DriftManagerBeanTest.assertEquals((Object)driftDefPojo.getBasedir(), (Object)driftDef2.getBasedir());
        DriftManagerBeanTest.assertEquals((long)driftDefPojo.getInterval(), (long)driftDef2.getInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDriftFiles() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = DriftManagerBeanTest.getEntityManager();
        try {
            try {
                int i = 0;
                int numDeleted = 1;
                while (numDeleted > 0) {
                    numDeleted = DriftManagerBeanTest.getEntityManager().createQuery("delete from JPADriftFile where hash_id = '" + i + "'").executeUpdate();
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("CANNOT PREPARE TEST: " + e);
                this.getTransactionManager().rollback();
                throw e;
            }
            em.flush();
            this.getTransactionManager().commit();
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource createNewResource() throws Exception {
        Resource resource;
        this.getTransactionManager().begin();
        EntityManager em = DriftManagerBeanTest.getEntityManager();
        try {
            try {
                ResourceType resourceType = new ResourceType("plat" + System.currentTimeMillis(), "test", ResourceCategory.PLATFORM, null);
                DriftDefinitionTemplate template = new DriftDefinitionTemplate();
                template.setName("test-template");
                DriftDefinition templateDef = new DriftDefinition(new Configuration());
                templateDef.setName("test-template-def");
                template.setTemplateDefinition(templateDef);
                template.setUserDefined(true);
                resourceType.addDriftDefinitionTemplate(template);
                em.persist((Object)resourceType);
                Agent agent = new Agent("testagent", "testaddress", 1, "", "testtoken");
                em.persist((Object)agent);
                em.flush();
                DriftDefinition test1Def = new DriftDefinition(new Configuration());
                test1Def.setName("test-1");
                DriftDefinition test2Def = new DriftDefinition(new Configuration());
                test2Def.setName("test-2");
                resource = new Resource("reskey" + System.currentTimeMillis(), "resname", resourceType);
                resource.setUuid("" + new Random().nextInt());
                resource.setAgent(agent);
                resource.setInventoryStatus(InventoryStatus.COMMITTED);
                resource.addDriftDefinition(test1Def);
                resource.addDriftDefinition(test2Def);
                em.persist((Object)resource);
            }
            catch (Exception e) {
                System.out.println("CANNOT PREPARE TEST: " + e);
                this.getTransactionManager().rollback();
                throw e;
            }
            em.flush();
            this.getTransactionManager().commit();
        }
        finally {
            em.close();
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNewResource(Resource resource) throws Exception {
        if (null != resource) {
            EntityManager em = null;
            try {
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                List deletedIds = resourceManager.uninventoryResource(this.overlord, resource.getId());
                for (Integer deletedResourceId : deletedIds) {
                    resourceManager.uninventoryResourceAsyncWork(this.overlord, deletedResourceId.intValue());
                }
                this.getTransactionManager().begin();
                em = DriftManagerBeanTest.getEntityManager();
                ResourceType type = (ResourceType)em.find(ResourceType.class, (Object)resource.getResourceType().getId());
                Agent agent = (Agent)em.find(Agent.class, (Object)resource.getAgent().getId());
                if (null != agent) {
                    em.remove((Object)agent);
                }
                if (null != type) {
                    em.remove((Object)type);
                }
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println("CANNOT CLEAN UP TEST (" + ((Object)((Object)this)).getClass().getSimpleName() + ") Cause: " + e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            finally {
                if (null != em) {
                    em.close();
                }
            }
        }
    }

    String sha256(String s) throws Exception {
        return this.digestGenerator.calcDigestString(s);
    }
}

